/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.net.URISyntaxException;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.LargeCatalogReadUtils;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssues;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;

public class LargeCatalogReadTiming {
    static final String catURL = "http://motherlode.ucar.edu:9080/thredds/radarServer/nexrad/level2/IDD?stn=KARX&time_start=2009-04-07T:00:00:00Z&time_end=2009-05-22T16:44:39Z";

    public static void main(String[] args) throws URISyntaxException, ThreddsXmlParserException, BuilderException {
        String catAsString = LargeCatalogReadUtils.createExampleRadarServiceCatalogAsString(9112);
        InvCatalogImpl cat = null;
        CatalogBuilder catalogBuilder = null;
        long cum = 0L;
        long cum2 = 0L;
        int numAttempts = 100;
        for (int i = 0; i < numAttempts; ++i) {
            long start = System.currentTimeMillis();
            cat = LargeCatalogReadUtils.parseCatalogIntoInvCatalogImpl(catAsString, catURL);
            long done = System.currentTimeMillis();
            long elapsed = done - start;
            BuilderIssues bldIssues = new BuilderIssues();
            start = System.currentTimeMillis();
            catalogBuilder = LargeCatalogReadUtils.parseCatalogIntoBuilder(catAsString, catURL);
            BuilderIssues issues = catalogBuilder.getIssues();
            if (!issues.isValid()) {
                System.out.println("Invalid catalog [" + i + "]: " + bldIssues.toString());
            }
            catalogBuilder.build();
            done = System.currentTimeMillis();
            long elapsed2 = done - start;
            cum += elapsed;
            cum2 += elapsed2;
            System.out.println("Read catalog [" + i + "]: InvCat=" + elapsed + " stax=" + elapsed2 + "\n");
        }
        System.out.println("Cum=" + cum);
        System.out.println("Avg=" + cum / (long)numAttempts);
        System.out.println("CumStax=" + cum2);
        System.out.println("AvgStax=" + cum2 / (long)numAttempts);
        System.out.println("InvCat");
        StringBuilder sb = new StringBuilder();
        if (cat.check(sb)) {
            System.out.println("Failed check:\n" + sb);
        } else {
            System.out.println("OK check:\n" + sb);
        }
        System.out.println("thredds.catalog2");
        BuilderIssues bldIssues = catalogBuilder.getIssues();
        if (!bldIssues.isValid()) {
            System.out.println("Invalid catalog: " + bldIssues.toString());
        } else {
            System.out.println("Valid catalog: " + (bldIssues.isEmpty() ? "" : bldIssues.toString()));
        }
        System.out.println("Done");
    }
}

