/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetScan;
import thredds.catalog.InvService;
import thredds.cataloggen.CatalogRefExpander;
import thredds.cataloggen.catalogrefexpander.BooleanCatalogRefExpander;
import thredds.crawlabledataset.CrawlableDatasetSorter;
import thredds.crawlabledataset.sorter.LexigraphicByNameSorter;
import ucar.nc2.TestAll;
import ucar.unidata.util.TestFileDirUtils;

public class DatasetScanExpandSubdirsTest {
    private String scanPath;
    private String scanLocation;

    @Before
    public void setupScanLocation() {
        File tmpDataDir = new File(TestAll.temporaryLocalDataDir);
        File testDir = TestFileDirUtils.createTempDirectory("dsScanExpandSubdirs", tmpDataDir);
        TestFileDirUtils.addFile(testDir, "file1.nc");
        TestFileDirUtils.addFile(testDir, "file2.nc");
        TestFileDirUtils.addFile(testDir, "file3.nc");
        File subdir1 = TestFileDirUtils.addDirectory(testDir, "subdir1");
        TestFileDirUtils.addFile(subdir1, "file4.nc");
        TestFileDirUtils.addFile(subdir1, "file5.nc");
        File subdir2 = TestFileDirUtils.addDirectory(testDir, "subdir2");
        TestFileDirUtils.addFile(subdir2, "file6.nc");
        TestFileDirUtils.addFile(subdir2, "file7.nc");
        File subdir3 = TestFileDirUtils.addDirectory(subdir2, "subdir2_1");
        TestFileDirUtils.addFile(subdir3, "file8.nc");
        TestFileDirUtils.addFile(subdir3, "file9.nc");
        this.scanPath = "test/path";
        this.scanLocation = testDir.getPath();
    }

    @Test
    public void checkExpandSubdirs() throws URISyntaxException, IOException {
        InvCatalogImpl configCat = new InvCatalogImpl("configCat", "1.0.2", new URI("http://server/thredds/catalog.xml"));
        configCat.addService(new InvService("odap", "OPENDAP", "/thredds/dodsC/", null, null));
        InvDatasetImpl configRootDs = new InvDatasetImpl(null, "root ds");
        configCat.addDataset(configRootDs);
        InvDatasetScan scan = new InvDatasetScan(configRootDs, "test", this.scanPath, this.scanLocation, null, null, null, null, null, true, (CrawlableDatasetSorter)new LexigraphicByNameSorter(true), null, null, (CatalogRefExpander)new BooleanCatalogRefExpander(true));
        scan.setServiceName("odap");
        configRootDs.addDataset((InvDatasetImpl)scan);
        Assert.assertTrue((boolean)configCat.finish());
        StringBuilder sb = new StringBuilder();
        boolean good = scan.check(sb, true);
        Assert.assertTrue((String)sb.toString(), (boolean)good);
        Assert.assertTrue((String)sb.toString(), (sb.length() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)scan.isValid());
        InvCatalogImpl cat = scan.makeCatalogForDirectory(this.scanPath + "/catalog.xml", new URI("http://server/thredds/catalogs/test/path/catalog.xml"));
        List dsList = cat.getDatasets();
        Assert.assertFalse((boolean)dsList.isEmpty());
        Assert.assertEquals((long)1L, (long)dsList.size());
        InvDataset rootDs = (InvDataset)dsList.get(0);
        Assert.assertTrue((boolean)rootDs.hasNestedDatasets());
        dsList = rootDs.getDatasets();
        Assert.assertFalse((boolean)dsList.isEmpty());
        Assert.assertEquals((long)5L, (long)dsList.size());
        Assert.assertEquals((String)"", (Object)"file1.nc", (Object)((InvDataset)dsList.get(0)).getName());
        Assert.assertEquals((Object)"file2.nc", (Object)((InvDataset)dsList.get(1)).getName());
        Assert.assertEquals((Object)"file3.nc", (Object)((InvDataset)dsList.get(2)).getName());
        InvDataset invDsSubdir1 = (InvDataset)dsList.get(3);
        InvDataset invDsSubdir2 = (InvDataset)dsList.get(4);
        Assert.assertEquals((Object)"subdir1", (Object)invDsSubdir1.getName());
        dsList = invDsSubdir1.getDatasets();
        Assert.assertEquals((long)2L, (long)dsList.size());
        Assert.assertEquals((Object)"file4.nc", (Object)((InvDataset)dsList.get(0)).getName());
        Assert.assertEquals((Object)"file5.nc", (Object)((InvDataset)dsList.get(1)).getName());
        Assert.assertEquals((Object)"subdir2", (Object)invDsSubdir2.getName());
        dsList = invDsSubdir2.getDatasets();
        Assert.assertEquals((long)3L, (long)dsList.size());
        Assert.assertEquals((Object)"file6.nc", (Object)((InvDataset)dsList.get(0)).getName());
        Assert.assertEquals((Object)"file7.nc", (Object)((InvDataset)dsList.get(1)).getName());
        InvDataset invDsSubdir2_1 = (InvDataset)dsList.get(2);
        Assert.assertEquals((Object)"subdir2_1", (Object)invDsSubdir2_1.getName());
        dsList = invDsSubdir2_1.getDatasets();
        Assert.assertEquals((long)2L, (long)dsList.size());
        Assert.assertEquals((Object)"file8.nc", (Object)((InvDataset)dsList.get(0)).getName());
        Assert.assertEquals((Object)"file9.nc", (Object)((InvDataset)dsList.get(1)).getName());
    }
}

