/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.IOException;
import java.util.ArrayList;
import ucar.ma2.Array;
import ucar.ma2.ArrayInt;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;

public class Simple_xy_wr {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int NX = 6;
        int NY = 12;
        String filename = "simple_xy.nc";
        NetcdfFileWriteable dataFile = null;
        try {
            dataFile = NetcdfFileWriteable.createNew((String)filename, (boolean)false);
            Dimension xDim = dataFile.addDimension("x", 6);
            Dimension yDim = dataFile.addDimension("y", 12);
            ArrayList<Dimension> dims = new ArrayList<Dimension>();
            dims.add(xDim);
            dims.add(yDim);
            dataFile.addVariable("data", DataType.INT, dims);
            dataFile.create();
            ArrayInt.D2 dataOut = new ArrayInt.D2(xDim.getLength(), yDim.getLength());
            for (int i = 0; i < xDim.getLength(); ++i) {
                for (int j = 0; j < yDim.getLength(); ++j) {
                    dataOut.set(i, j, i * 12 + j);
                }
            }
            dataFile.write("data", (Array)dataOut);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
        }
        finally {
            if (null != dataFile) {
                try {
                    dataFile.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        System.out.println("*** SUCCESS writing example file simple_xy.nc!");
    }
}

