/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;

public abstract class FileFormat
extends File {
    private static final long serialVersionUID = -4700692313888420796L;
    public static final int OPEN_NEW = 1;
    public static final int READ = 2;
    public static final int WRITE = 4;
    public static final int CREATE = 8;
    public static final int FILE_CREATE_DELETE = 10;
    public static final int FILE_CREATE_OPEN = 20;
    public static final int FILE_CREATE_EARLY_LIB = 40;
    public static final String FILE_TYPE_HDF4 = "HDF4";
    public static final String FILE_TYPE_HDF5 = "HDF5";
    public static final String FILE_OBJ_SEP = "://";
    private static final Map<String, FileFormat> FileList;
    private static String extensions;
    private int max_members = 10000;
    private int start_members = 0;
    protected int fid = -1;
    protected String fullFileName = null;
    protected boolean isReadOnly = false;

    public FileFormat(String filename) {
        super(filename);
        this.fullFileName = filename;
        if (filename != null && filename.length() > 0) {
            try {
                this.fullFileName = this.getAbsolutePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isReadOnly = false;
    }

    public static final void addFileFormat(String key, FileFormat fileformat) {
        if (fileformat == null || key == null) {
            return;
        }
        if (!FileList.containsKey(key = key.trim())) {
            FileList.put(key, fileformat);
        }
    }

    public static final FileFormat getFileFormat(String key) {
        return FileList.get(key);
    }

    public static final Enumeration getFileFormatKeys() {
        return ((Hashtable)FileList).keys();
    }

    public static final FileFormat[] getFileFormats() {
        int n = FileList.size();
        if (n <= 0) {
            return null;
        }
        int i = 0;
        FileFormat[] fileformats = new FileFormat[n];
        Enumeration local_enum = ((Hashtable)FileList).elements();
        while (local_enum.hasMoreElements()) {
            fileformats[i++] = (FileFormat)local_enum.nextElement();
        }
        return fileformats;
    }

    public static final FileFormat removeFileFormat(String key) {
        return FileList.remove(key);
    }

    public static final void addFileExtension(String extension) {
        if (extensions == null || extensions.length() <= 0) {
            extensions = extension;
        }
        StringTokenizer currentExt = new StringTokenizer(extensions, ",");
        Vector<String> tokens = new Vector<String>(currentExt.countTokens() + 5);
        while (currentExt.hasMoreTokens()) {
            tokens.add(currentExt.nextToken().trim().toLowerCase());
        }
        currentExt = new StringTokenizer(extension, ",");
        String ext = null;
        while (currentExt.hasMoreTokens()) {
            ext = currentExt.nextToken().trim().toLowerCase();
            if (tokens.contains(ext)) continue;
            extensions = extensions + ", " + ext;
        }
        tokens.setSize(0);
    }

    public static final String getFileExtensions() {
        return extensions;
    }

    public static final FileFormat getInstance(String filename) throws Exception {
        if (filename == null || filename.length() <= 0) {
            throw new IllegalArgumentException("Invalid file name: " + filename);
        }
        if (!new File(filename).exists()) {
            throw new IllegalArgumentException("File " + filename + " does not exist.");
        }
        FileFormat fileFormat = null;
        FileFormat knownFormat = null;
        Enumeration elms = ((Hashtable)FileList).elements();
        while (elms.hasMoreElements()) {
            knownFormat = (FileFormat)elms.nextElement();
            if (!knownFormat.isThisType(filename)) continue;
            try {
                fileFormat = knownFormat.createInstance(filename, 4);
            }
            catch (Exception ex) {}
            break;
        }
        return fileFormat;
    }

    public abstract String getLibversion();

    public abstract boolean isThisType(FileFormat var1);

    public abstract boolean isThisType(String var1);

    public FileFormat createFile(String filename, int createFlag) throws Exception {
        throw new UnsupportedOperationException("FileFormat FileFormat.createFile(...) is not implemented.");
    }

    public abstract FileFormat createInstance(String var1, int var2) throws Exception;

    public final String getFilePath() {
        return this.fullFileName;
    }

    public final int getFID() {
        return this.fid;
    }

    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    public final void setMaxMembers(int n) {
        this.max_members = n;
    }

    public final int getMaxMembers() {
        if (this.max_members < 0) {
            return Integer.MAX_VALUE;
        }
        return this.max_members;
    }

    public final void setStartMembers(int idx) {
        this.start_members = idx;
    }

    public final int getStartMembers() {
        return this.start_members;
    }

    public final int getNumberOfMembers() {
        int n_members = 0;
        TreeNode rootNode = this.getRootNode();
        if (rootNode != null) {
            Enumeration<TreeNode> local_enum = ((DefaultMutableTreeNode)rootNode).depthFirstEnumeration();
            while (local_enum.hasMoreElements()) {
                local_enum.nextElement();
                ++n_members;
            }
        }
        return n_members;
    }

    public abstract int open() throws Exception;

    public abstract void close() throws Exception;

    public abstract TreeNode getRootNode();

    public abstract HObject get(String var1) throws Exception;

    public abstract Datatype createDatatype(int var1, int var2, int var3, int var4, String var5) throws Exception;

    public abstract Datatype createDatatype(int var1, int var2, int var3, int var4) throws Exception;

    public abstract Dataset createScalarDS(String var1, Group var2, Datatype var3, long[] var4, long[] var5, long[] var6, int var7, Object var8, Object var9) throws Exception;

    public Dataset createScalarDS(String name, Group pgroup, Datatype type, long[] dims, long[] maxdims, long[] chunks, int gzip, Object data) throws Exception {
        return this.createScalarDS(name, pgroup, type, dims, maxdims, chunks, gzip, null, data);
    }

    public Dataset createCompoundDS(String name, Group pgroup, long[] dims, long[] maxdims, long[] chunks, int gzip, String[] memberNames, Datatype[] memberDatatypes, int[] memberSizes, Object data) throws Exception {
        throw new UnsupportedOperationException("Dataset FileFormat.createCompoundDS(...) is not implemented.");
    }

    public abstract Dataset createImage(String var1, Group var2, Datatype var3, long[] var4, long[] var5, long[] var6, int var7, int var8, int var9, Object var10) throws Exception;

    public abstract Group createGroup(String var1, Group var2) throws Exception;

    public HObject createLink(Group parentGroup, String name, HObject currentObj, int type) throws Exception {
        return this.createLink(parentGroup, name, currentObj);
    }

    public HObject createLink(Group parentGroup, String name, String currentObj, int type) throws Exception {
        return this.createLink(parentGroup, name, currentObj);
    }

    public abstract TreeNode copy(HObject var1, Group var2, String var3) throws Exception;

    public abstract void delete(HObject var1) throws Exception;

    public abstract void writeAttribute(HObject var1, Attribute var2, boolean var3) throws Exception;

    @Deprecated
    public final FileFormat create(String fileName) throws Exception {
        return this.createFile(fileName, 10);
    }

    @Deprecated
    public final FileFormat open(String pathname, int access) throws Exception {
        return this.createInstance(pathname, access);
    }

    @Deprecated
    public final Dataset createCompoundDS(String name, Group pgroup, long[] dims, String[] memberNames, Datatype[] memberDatatypes, int[] memberSizes, Object data) throws Exception {
        return this.createCompoundDS(name, pgroup, dims, null, null, -1, memberNames, memberDatatypes, memberSizes, data);
    }

    @Deprecated
    public final TreeNode copy(HObject srcObj, Group dstGroup) throws Exception {
        return this.copy(srcObj, dstGroup, null);
    }

    @Deprecated
    public static final HObject getHObject(String fullPath) throws Exception {
        if (fullPath == null || fullPath.length() <= 0) {
            return null;
        }
        String filename = null;
        String path = null;
        int idx = fullPath.indexOf(FILE_OBJ_SEP);
        if (idx > 0) {
            filename = fullPath.substring(0, idx);
            path = fullPath.substring(idx + FILE_OBJ_SEP.length());
            if (path == null || path.length() == 0) {
                path = "/";
            }
        } else {
            filename = fullPath;
            path = "/";
        }
        return FileFormat.getHObject(filename, path);
    }

    @Deprecated
    public static final HObject getHObject(String filename, String path) throws Exception {
        if (filename == null || filename.length() <= 0) {
            throw new IllegalArgumentException("Invalid file name. " + filename);
        }
        if (!new File(filename).exists()) {
            throw new IllegalArgumentException("File does not exists");
        }
        HObject obj = null;
        FileFormat file = FileFormat.getInstance(filename);
        if (file != null && (obj = file.get(path)) == null) {
            file.close();
        }
        return obj;
    }

    public static final HObject findObject(FileFormat file, long[] oid) {
        if (file == null || oid == null) {
            return null;
        }
        HObject theObj = null;
        DefaultMutableTreeNode theNode = null;
        MutableTreeNode theRoot = (MutableTreeNode)file.getRootNode();
        if (theRoot == null) {
            return null;
        }
        Enumeration<TreeNode> local_enum = ((DefaultMutableTreeNode)theRoot).breadthFirstEnumeration();
        while (local_enum.hasMoreElements() && !(theObj = (HObject)(theNode = (DefaultMutableTreeNode)local_enum.nextElement()).getUserObject()).equalsOID(oid)) {
        }
        return theObj;
    }

    public static final HObject findObject(FileFormat file, String path) {
        String fullPath;
        DefaultMutableTreeNode theRoot;
        if (file == null || path == null) {
            return null;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if ((theRoot = (DefaultMutableTreeNode)file.getRootNode()) == null) {
            return null;
        }
        if (path.equals("/")) {
            return (HObject)theRoot.getUserObject();
        }
        Enumeration<TreeNode> local_enum = theRoot.breadthFirstEnumeration();
        DefaultMutableTreeNode theNode = null;
        HObject theObj = null;
        while (local_enum.hasMoreElements() && (!path.equals(fullPath = (theObj = (HObject)(theNode = (DefaultMutableTreeNode)local_enum.nextElement()).getUserObject()).getFullName() + "/") || theObj.getPath() == null)) {
            theObj = null;
        }
        return theObj;
    }

    public int open(int ... propList) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation. Subclasses must implement it.");
    }

    public Group createGroup(String name, Group pgroup, int ... gplist) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation. Subclasses must implement it.");
    }

    public int createGcpl(int creationorder, int maxcompact, int mindense) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation. Subclasses must implement it.");
    }

    public HObject createLink(Group linkGroup, String name, Object currentObj) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation. Subclasses must implement it.");
    }

    public void renameAttribute(HObject obj, String oldAttrName, String newAttrName) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation. Subclasses must implement it.");
    }

    public void setLibBounds(int low, int high) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation. Subclasses must implement it.");
    }

    public int[] getLibBounds() throws Exception {
        throw new UnsupportedOperationException("Unsupported operation. Subclasses must implement it.");
    }

    public static int getIndexTypeValue(String strtype) {
        throw new UnsupportedOperationException("Unsupported operation. Subclasses must implement it.");
    }

    public int getIndexType(String strtype) {
        throw new UnsupportedOperationException("Unsupported operation. Subclasses must implement it.");
    }

    public void setIndexType(int indexType) {
        throw new UnsupportedOperationException("Unsupported operation. Subclasses must implement it.");
    }

    public static int getIndexOrderValue(String strorder) {
        throw new UnsupportedOperationException("Unsupported operation. Subclasses must implement it.");
    }

    public int getIndexOrder(String strorder) {
        throw new UnsupportedOperationException("Unsupported operation. Subclasses must implement it.");
    }

    public void setIndexOrder(int indexOrder) {
        throw new UnsupportedOperationException("Unsupported operation. Subclasses must implement it.");
    }

    static {
        FileFormat fileformat;
        Class<?> fileclass;
        FileList = new Hashtable<String, FileFormat>(10);
        extensions = "hdf, h4, hdf5, h5";
        if (FileFormat.getFileFormat(FILE_TYPE_HDF4) == null) {
            try {
                fileclass = Class.forName("ncsa.hdf.object.h4.H4File");
                fileformat = (FileFormat)fileclass.newInstance();
                if (fileformat != null) {
                    FileFormat.addFileFormat(FILE_TYPE_HDF4, fileformat);
                }
            }
            catch (Throwable err) {
                // empty catch block
            }
        }
        if (FileFormat.getFileFormat(FILE_TYPE_HDF5) == null) {
            try {
                fileclass = Class.forName("ncsa.hdf.object.h5.H5File");
                fileformat = (FileFormat)fileclass.newInstance();
                if (fileformat != null) {
                    FileFormat.addFileFormat(FILE_TYPE_HDF5, fileformat);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

