/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.coords;

import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis1D;
import uk.ac.rdg.resc.ncwms.coords.Irregular1DCoordAxis;
import uk.ac.rdg.resc.ncwms.coords.Regular1DCoordAxis;

abstract class OneDCoordAxis {
    protected AxisType type;
    protected int size;

    public static OneDCoordAxis create(CoordinateAxis1D axis1D) {
        AxisType axisType = axis1D.getAxisType();
        if (axisType == AxisType.Lon || axisType == AxisType.Lat || axisType == AxisType.GeoX || axisType == AxisType.GeoY) {
            OneDCoordAxis theAxis = null;
            theAxis = axis1D.isRegular() ? new Regular1DCoordAxis(axis1D.getStart(), axis1D.getIncrement(), (int)axis1D.getSize(), axisType) : new Irregular1DCoordAxis(axis1D.getCoordValues(), axisType);
            return theAxis;
        }
        throw new IllegalArgumentException("Illegal axis type " + axisType);
    }

    protected OneDCoordAxis(AxisType type, int size) {
        this.type = type;
        this.size = size;
    }

    public abstract int getIndex(double var1);

    public abstract double getCoordValue(int var1);

    public int getSize() {
        return this.size;
    }

    public AxisType getAxisType() {
        return this.type;
    }

    public boolean isLongitude() {
        return this.getAxisType() == AxisType.Lon;
    }
}

