/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.cdm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.GridDatatype;

final class RangesList {
    private static final Logger log = LoggerFactory.getLogger(RangesList.class);
    private static final Range ZERO_RANGE;
    private final List<Range> ranges;
    private int xAxisIndex = -1;
    private int yAxisIndex = -1;
    private int zAxisIndex = -1;
    private int tAxisIndex = -1;

    public RangesList(GridDatatype grid) {
        VariableDS var = grid.getVariable();
        int rank = var.getRank();
        this.ranges = new ArrayList<Range>(rank);
        for (int i = 0; i < rank; ++i) {
            this.ranges.add(ZERO_RANGE);
        }
        String xDimName = grid.getXDimension() == null ? null : grid.getXDimension().getName();
        String yDimName = grid.getYDimension() == null ? null : grid.getYDimension().getName();
        String zDimName = grid.getZDimension() == null ? null : grid.getZDimension().getName();
        String tDimName = grid.getTimeDimension() == null ? null : grid.getTimeDimension().getName();
        List dims = var.getDimensions();
        for (int i = 0; i < dims.size(); ++i) {
            Dimension dim = (Dimension)dims.get(i);
            if (dim.getName().equals(xDimName)) {
                this.xAxisIndex = i;
                continue;
            }
            if (dim.getName().equals(yDimName)) {
                this.yAxisIndex = i;
                continue;
            }
            if (dim.getName().equals(zDimName)) {
                this.zAxisIndex = i;
                continue;
            }
            if (!dim.getName().equals(tDimName)) continue;
            this.tAxisIndex = i;
        }
        log.debug("Created RangesList: Shape = {}", (Object)Arrays.toString(grid.getShape()));
        log.debug("            ....    Rank = {}, x = {}, y = {}, z = {}, t = {}", new Object[]{rank, this.xAxisIndex, this.yAxisIndex, this.zAxisIndex, this.tAxisIndex});
    }

    public void setXRange(int xmin, int xmax) {
        this.setRange(this.xAxisIndex, xmin, xmax);
    }

    public void setYRange(int ymin, int ymax) {
        this.setRange(this.yAxisIndex, ymin, ymax);
    }

    public void setZRange(int zmin, int zmax) {
        this.setRange(this.zAxisIndex, zmin, zmax);
    }

    public void setTRange(int tmin, int tmax) {
        this.setRange(this.tAxisIndex, tmin, tmax);
    }

    private void setRange(int index, int min, int max) {
        if (index >= 0) {
            try {
                this.ranges.set(index, new Range(min, max));
            }
            catch (InvalidRangeException ire) {
                throw new IllegalArgumentException(ire);
            }
        }
    }

    private Range getRange(int index) {
        if (index >= 0) {
            return this.ranges.get(index);
        }
        return null;
    }

    public int getXAxisIndex() {
        return this.xAxisIndex;
    }

    public int getYAxisIndex() {
        return this.yAxisIndex;
    }

    public int getZAxisIndex() {
        return this.zAxisIndex;
    }

    public int getTAxisIndex() {
        return this.tAxisIndex;
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public String toString() {
        Range tRange = this.getRange(this.tAxisIndex);
        Range zRange = this.getRange(this.zAxisIndex);
        Range yRange = this.getRange(this.yAxisIndex);
        Range xRange = this.getRange(this.xAxisIndex);
        return String.format("tRange(%d): %s, zRange(%d): %s, yRange(%d): %s, xRange(%d): %s", this.tAxisIndex, tRange, this.zAxisIndex, zRange, this.yAxisIndex, yRange, this.xAxisIndex, xRange);
    }

    static {
        try {
            ZERO_RANGE = new Range(0, 0);
        }
        catch (InvalidRangeException ire) {
            throw new ExceptionInInitializerError(ire);
        }
    }
}

