/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.util.tree.BasicTree;
import gov.nasa.worldwind.util.tree.BasicTreeLayout;
import gov.nasa.worldwind.util.tree.BasicTreeModel;
import gov.nasa.worldwind.util.tree.BasicTreeNode;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.HotSpotController;

public class TreeControl
extends ApplicationTemplate {
    private static final String ICON_PATH = "images/16x16-icon-nasa.png";

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("Tree Control", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        HotSpotController controller;

        public AppFrame() {
            super(true, true, false);
            RenderableLayer renderableLayer = new RenderableLayer();
            BasicTree basicTree = new BasicTree();
            BasicTreeLayout basicTreeLayout = new BasicTreeLayout(basicTree, 100, 200);
            basicTreeLayout.getFrame().setFrameTitle("TreeControl");
            basicTree.setLayout(basicTreeLayout);
            BasicTreeModel basicTreeModel = new BasicTreeModel();
            BasicTreeNode basicTreeNode = new BasicTreeNode("Root", TreeControl.ICON_PATH);
            basicTreeModel.setRoot(basicTreeNode);
            BasicTreeNode basicTreeNode2 = new BasicTreeNode("Child 1", TreeControl.ICON_PATH);
            basicTreeNode2.setDescription("This is a child node");
            basicTreeNode2.addChild(new BasicTreeNode("Subchild 1,1"));
            basicTreeNode2.addChild(new BasicTreeNode("Subchild 1,2"));
            basicTreeNode2.addChild(new BasicTreeNode("Subchild 1,3", TreeControl.ICON_PATH));
            basicTreeNode.addChild(basicTreeNode2);
            basicTreeNode2 = new BasicTreeNode("Child 2", TreeControl.ICON_PATH);
            basicTreeNode2.addChild(new BasicTreeNode("Subchild 2,1"));
            basicTreeNode2.addChild(new BasicTreeNode("Subchild 2,2"));
            basicTreeNode2.addChild(new BasicTreeNode("Subchild 2,3"));
            basicTreeNode.addChild(basicTreeNode2);
            basicTreeNode2 = new BasicTreeNode("Child 3");
            basicTreeNode2.addChild(new BasicTreeNode("Subchild 3,1"));
            basicTreeNode2.addChild(new BasicTreeNode("Subchild 3,2"));
            basicTreeNode2.addChild(new BasicTreeNode("Subchild 3,3"));
            basicTreeNode.addChild(basicTreeNode2);
            basicTree.setModel(basicTreeModel);
            basicTree.expandPath(basicTreeNode.getPath());
            this.controller = new HotSpotController(this.getWwd());
            renderableLayer.addRenderable(basicTree);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

