/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.kml;

import gov.nasa.worldwind.Exportable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class KMLDocumentBuilder {
    protected XMLStreamWriter writer;

    public KMLDocumentBuilder(Writer writer) throws XMLStreamException {
        this.writer = XMLOutputFactory.newInstance().createXMLStreamWriter(writer);
        this.startDocument();
    }

    public KMLDocumentBuilder(OutputStream outputStream) throws XMLStreamException {
        this.writer = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream);
        this.startDocument();
    }

    protected void startDocument() throws XMLStreamException {
        this.writer.writeStartDocument();
        this.writer.writeStartElement("kml");
        this.writer.writeDefaultNamespace("http://www.opengis.net/kml/2.2");
        this.writer.setPrefix("gx", "http://www.google.com/kml/ext/2.2");
        this.writer.writeNamespace("gx", "http://www.google.com/kml/ext/2.2");
        this.writer.writeStartElement("Document");
    }

    protected void endDocument() throws XMLStreamException {
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.close();
    }

    public void close() throws XMLStreamException {
        this.endDocument();
        this.writer.close();
    }

    public void writeObject(Exportable exportable) throws IOException {
        String string = exportable.isExportFormatSupported("application/vnd.google-earth.kml+xml");
        if ("Export.FormatSupported".equals(string) || "Export.FormatPartiallySupported".equals(string)) {
            exportable.export("application/vnd.google-earth.kml+xml", this.writer);
        }
    }

    public void writeObjects(Exportable ... exportableArray) throws IOException {
        for (Exportable exportable : exportableArray) {
            String string = exportable.isExportFormatSupported("application/vnd.google-earth.kml+xml");
            if (!"Export.FormatSupported".equals(string) && !"Export.FormatPartiallySupported".equals(string)) continue;
            exportable.export("application/vnd.google-earth.kml+xml", this.writer);
        }
    }
}

