/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.analytics;

import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.util.Logging;

public class AnalyticSurfaceAttributes {
    protected boolean drawInterior = true;
    protected boolean drawOutline = true;
    protected boolean drawShadow = true;
    protected Material interiorMaterial = Material.GRAY;
    protected Material outlineMaterial = Material.WHITE;
    protected double interiorOpacity = 1.0;
    protected double outlineOpacity = 1.0;
    protected double shadowOpacity = 1.0;
    protected double outlineWidth = 1.0;

    public AnalyticSurfaceAttributes(Material material, double d) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.interiorMaterial = material;
        this.interiorOpacity = d;
    }

    public AnalyticSurfaceAttributes() {
        this(Material.GRAY, 1.0);
    }

    public AnalyticSurfaceAttributes(AnalyticSurfaceAttributes analyticSurfaceAttributes) {
        if (analyticSurfaceAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.drawInterior = analyticSurfaceAttributes.isDrawInterior();
        this.drawOutline = analyticSurfaceAttributes.isDrawOutline();
        this.drawShadow = analyticSurfaceAttributes.isDrawShadow();
        this.interiorMaterial = analyticSurfaceAttributes.getInteriorMaterial();
        this.outlineMaterial = analyticSurfaceAttributes.getOutlineMaterial();
        this.interiorOpacity = analyticSurfaceAttributes.getInteriorOpacity();
        this.outlineOpacity = analyticSurfaceAttributes.getOutlineOpacity();
        this.shadowOpacity = analyticSurfaceAttributes.getShadowOpacity();
        this.outlineWidth = analyticSurfaceAttributes.getOutlineWidth();
    }

    public AnalyticSurfaceAttributes copy() {
        return new AnalyticSurfaceAttributes(this);
    }

    public boolean isDrawInterior() {
        return this.drawInterior;
    }

    public void setDrawInterior(boolean bl) {
        this.drawInterior = bl;
    }

    public boolean isDrawOutline() {
        return this.drawOutline;
    }

    public void setDrawOutline(boolean bl) {
        this.drawOutline = bl;
    }

    public boolean isDrawShadow() {
        return this.drawShadow;
    }

    public void setDrawShadow(boolean bl) {
        this.drawShadow = bl;
    }

    public Material getInteriorMaterial() {
        return this.interiorMaterial;
    }

    public void setInteriorMaterial(Material material) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.interiorMaterial = material;
    }

    public Material getOutlineMaterial() {
        return this.outlineMaterial;
    }

    public void setOutlineMaterial(Material material) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlineMaterial = material;
    }

    public double getInteriorOpacity() {
        return this.interiorOpacity;
    }

    public void setInteriorOpacity(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.OpacityOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.interiorOpacity = d;
    }

    public double getOutlineOpacity() {
        return this.outlineOpacity;
    }

    public void setOutlineOpacity(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.OpacityOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlineOpacity = d;
    }

    public double getShadowOpacity() {
        return this.shadowOpacity;
    }

    public void setShadowOpacity(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.OpacityOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.shadowOpacity = d;
    }

    public double getOutlineWidth() {
        return this.outlineWidth;
    }

    public void setOutlineWidth(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("Geom.LineWidthInvalid", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlineWidth = d;
    }
}

