/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.CrosshairLayer;
import gov.nasa.worldwind.view.firstperson.BasicFlyView;
import gov.nasa.worldwind.view.orbit.OrbitView;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ViewLookAround
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind View Look Around", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private ViewControlPanel vcp = new ViewControlPanel(this.getWwd());

        public AppFrame() {
            super(true, true, false);
            this.getWwd().setView(new BasicFlyView());
            this.getLayerPanel().add((Component)this.vcp, "South");
            Position position = new Position(new LatLon(Angle.fromDegrees(45.0), Angle.fromDegrees(-120.0)), 2000.0);
            this.getWwd().getView().setEyePosition(position);
        }

        private class ViewControlPanel
        extends JPanel {
            private WorldWindow wwd;
            private JSlider pitchSlider;
            private JSlider headingSlider;
            private JSlider rollSlider;
            private JSlider fovSlider;
            private boolean suspendEvents = false;

            public ViewControlPanel(WorldWindow worldWindow) {
                this.wwd = worldWindow;
                this.wwd.getView().addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        ViewControlPanel.this.update();
                    }
                });
                this.setLayout(new BoxLayout(this, 1));
                ApplicationTemplate.insertBeforeCompass(AppFrame.this.getWwd(), new CrosshairLayer());
                JPanel jPanel = new JPanel(new GridLayout(0, 1, 5, 5));
                jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                jPanel.add(new JLabel("Pitch:"));
                this.pitchSlider = new JSlider(0, 180, 90);
                this.pitchSlider.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        ViewControlPanel.this.updateView();
                    }
                });
                jPanel.add(this.pitchSlider);
                JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 5, 5));
                jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                jPanel2.add(new JLabel("Heading:"));
                this.headingSlider = new JSlider(-180, 180, 0);
                this.headingSlider.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        ViewControlPanel.this.updateView();
                    }
                });
                jPanel2.add(this.headingSlider);
                JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 5, 5));
                jPanel3.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                jPanel3.add(new JLabel("Roll:"));
                this.rollSlider = new JSlider(-180, 180, 0);
                this.rollSlider.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        ViewControlPanel.this.updateView();
                    }
                });
                jPanel3.add(this.rollSlider);
                JPanel jPanel4 = new JPanel(new GridLayout(0, 1, 5, 5));
                jPanel4.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                jPanel4.add(new JLabel("Field of view:"));
                this.fovSlider = new JSlider(10, 120, 45);
                this.fovSlider.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        ViewControlPanel.this.updateView();
                    }
                });
                jPanel4.add(this.fovSlider);
                this.add(jPanel);
                this.add(jPanel2);
                this.add(jPanel3);
                this.add(jPanel4);
                JButton jButton = new JButton("Reset");
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ViewControlPanel.this.pitchSlider.setValue(90);
                        ViewControlPanel.this.rollSlider.setValue(0);
                        ViewControlPanel.this.headingSlider.setValue(0);
                        ViewControlPanel.this.fovSlider.setValue(45);
                        ViewControlPanel.this.updateView();
                    }
                });
                this.add(jButton);
                this.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("View")));
                this.setToolTipText("View controls");
            }

            private void updateView() {
                if (!this.suspendEvents) {
                    BasicFlyView basicFlyView = (BasicFlyView)this.wwd.getView();
                    basicFlyView.stopAnimations();
                    Position position = basicFlyView.getEyePosition();
                    basicFlyView.setHeading(Angle.fromDegrees(this.headingSlider.getValue()));
                    basicFlyView.setPitch(Angle.fromDegrees(this.pitchSlider.getValue()));
                    basicFlyView.setFieldOfView(Angle.fromDegrees(this.fovSlider.getValue()));
                    basicFlyView.setRoll(Angle.fromDegrees(this.rollSlider.getValue()));
                    basicFlyView.setEyePosition(position);
                    this.wwd.redraw();
                }
            }

            public void update() {
                this.suspendEvents = true;
                OrbitView orbitView = (OrbitView)this.wwd.getView();
                this.pitchSlider.setValue((int)orbitView.getPitch().degrees);
                this.headingSlider.setValue((int)orbitView.getHeading().degrees);
                this.fovSlider.setValue((int)orbitView.getFieldOfView().degrees);
                this.suspendEvents = false;
            }
        }
    }
}

