/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ParallelPaths
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLatitude", 49.05);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLongitude", -122.78);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialAltitude", 8000);
        ApplicationTemplate.start("World Wind Multi Path", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            List<Position> list = Arrays.asList(Position.fromDegrees(49.0457, -122.8115, 100.0), Position.fromDegrees(49.0539, -122.8091, 110.0), Position.fromDegrees(49.0621, -122.7937, 120.0), Position.fromDegrees(49.0681, -122.8044, 130.0), Position.fromDegrees(49.0682, -122.773, 140.0), Position.fromDegrees(49.0482, -122.7764, 150.0), Position.fromDegrees(49.0498, -122.7466, 140.0), Position.fromDegrees(49.0389, -122.7453, 130.0), Position.fromDegrees(49.0321, -122.7759, 120.0), Position.fromDegrees(49.0394, -122.7689, 110.0), Position.fromDegrees(49.0629, -122.7666, 100.0));
            ArrayList<Position> arrayList = new ArrayList<Position>();
            ArrayList<Position> arrayList2 = new ArrayList<Position>();
            ArrayList<Position> arrayList3 = new ArrayList<Position>();
            ArrayList<Position> arrayList4 = new ArrayList<Position>();
            Globe globe = this.getWwd().getModel().getGlobe();
            WWMath.generateParallelLines(list, arrayList, arrayList2, 50.0, globe);
            WWMath.generateParallelLines(list, arrayList3, arrayList4, 100.0, globe);
            RenderableLayer renderableLayer = new RenderableLayer();
            this.addPath(renderableLayer, list, "Control Path");
            this.addPath(renderableLayer, arrayList, "Path 1");
            this.addPath(renderableLayer, arrayList2, "Path 2");
            this.addPath(renderableLayer, arrayList3, "Path 3");
            this.addPath(renderableLayer, arrayList4, "Path 4");
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), renderableLayer);
        }

        protected void addPath(RenderableLayer renderableLayer, List<Position> list, String string) {
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setOutlineWidth(5.0);
            Path path = new Path(list);
            path.setPathType("gov.nasa.worldwind.avkey.Linear");
            path.setAltitudeMode(2);
            path.setAttributes(basicShapeAttributes);
            path.setValue("gov.nasa.worldwind.avkey.DisplayName", string);
            renderableLayer.addRenderable(path);
            path.setPositionColors(new ExamplePositionColors());
        }

        public static class ExamplePositionColors
        implements Path.PositionColors {
            @Override
            public Color getColor(Position position, int n) {
                double d = position.getAltitude();
                return d < 115.0 ? Color.GREEN : (d < 135.0 ? Color.BLUE : Color.RED);
            }
        }
    }
}

