/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.render.SurfaceQuad;
import gov.nasa.worldwind.util.measure.MeasureTool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class MeasureToolPanel
extends JPanel {
    private final WorldWindow wwd;
    private final MeasureTool measureTool;
    private JComboBox shapeCombo;
    private JComboBox pathTypeCombo;
    private JComboBox unitsCombo;
    private JComboBox anglesCombo;
    private JButton lineColorButton;
    private JButton pointColorButton;
    private JButton annotationColorButton;
    private JCheckBox followCheck;
    private JCheckBox showControlsCheck;
    private JCheckBox showAnnotationCheck;
    private JCheckBox rubberBandCheck;
    private JCheckBox freeHandCheck;
    private JButton newButton;
    private JButton pauseButton;
    private JButton endButton;
    private JLabel[] pointLabels;
    private JLabel lengthLabel;
    private JLabel areaLabel;
    private JLabel widthLabel;
    private JLabel heightLabel;
    private JLabel headingLabel;
    private JLabel centerLabel;
    private static ArrayList<Position> LINE = new ArrayList();
    private static ArrayList<Position> PATH = new ArrayList();
    private static ArrayList<Position> POLYGON = new ArrayList();

    public MeasureToolPanel(WorldWindow worldWindow, MeasureTool measureTool) {
        super(new BorderLayout());
        this.wwd = worldWindow;
        this.measureTool = measureTool;
        this.makePanel(new Dimension(200, 300));
        this.measureTool.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("MeasureTool.AddPosition") || propertyChangeEvent.getPropertyName().equals("MeasureTool.RemovePosition") || propertyChangeEvent.getPropertyName().equals("MeasureTool.ReplacePosition")) {
                    MeasureToolPanel.this.fillPointsPanel();
                } else if (propertyChangeEvent.getPropertyName().equals("MeasureTool.Armed")) {
                    if (MeasureToolPanel.this.measureTool.isArmed()) {
                        MeasureToolPanel.this.newButton.setEnabled(false);
                        MeasureToolPanel.this.pauseButton.setText("Pause");
                        MeasureToolPanel.this.pauseButton.setEnabled(true);
                        MeasureToolPanel.this.endButton.setEnabled(true);
                        ((Component)((Object)MeasureToolPanel.this.wwd)).setCursor(Cursor.getPredefinedCursor(1));
                    } else {
                        MeasureToolPanel.this.newButton.setEnabled(true);
                        MeasureToolPanel.this.pauseButton.setText("Pause");
                        MeasureToolPanel.this.pauseButton.setEnabled(false);
                        MeasureToolPanel.this.endButton.setEnabled(false);
                        ((Component)((Object)MeasureToolPanel.this.wwd)).setCursor(Cursor.getDefaultCursor());
                    }
                } else if (propertyChangeEvent.getPropertyName().equals("MeasureTool.MetricChanged")) {
                    MeasureToolPanel.this.updateMetric();
                }
            }
        });
    }

    public MeasureTool getMeasureTool() {
        return this.measureTool;
    }

    private void makePanel(Dimension dimension) {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel.add(new JLabel("Shape:"));
        this.shapeCombo = new JComboBox<String>(new String[]{"Line", "Path", "Polygon", "Circle", "Ellipse", "Square", "Rectangle"});
        this.shapeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
                if (string.equals("Line")) {
                    MeasureToolPanel.this.measureTool.setMeasureShapeType("MeasureTool.ShapeLine");
                } else if (string.equals("Path")) {
                    MeasureToolPanel.this.measureTool.setMeasureShapeType("MeasureTool.ShapePath");
                } else if (string.equals("Polygon")) {
                    MeasureToolPanel.this.measureTool.setMeasureShapeType("MeasureTool.ShapePolygon");
                } else if (string.equals("Circle")) {
                    MeasureToolPanel.this.measureTool.setMeasureShapeType("MeasureTool.ShapeCircle");
                } else if (string.equals("Ellipse")) {
                    MeasureToolPanel.this.measureTool.setMeasureShapeType("MeasureTool.ShapeEllipse");
                } else if (string.equals("Square")) {
                    MeasureToolPanel.this.measureTool.setMeasureShapeType("MeasureTool.ShapeSquare");
                } else if (string.equals("Rectangle")) {
                    MeasureToolPanel.this.measureTool.setMeasureShapeType("MeasureTool.ShapeQuad");
                }
            }
        });
        jPanel.add(this.shapeCombo);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel2.add(new JLabel("Path type:"));
        this.pathTypeCombo = new JComboBox<String>(new String[]{"Linear", "Rhumb", "Great circle"});
        this.pathTypeCombo.setSelectedIndex(2);
        this.pathTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
                if (string.equals("Linear")) {
                    MeasureToolPanel.this.measureTool.setPathType("gov.nasa.worldwind.avkey.Linear");
                } else if (string.equals("Rhumb")) {
                    MeasureToolPanel.this.measureTool.setPathType("gov.nasa.worldwind.avkey.RhumbLine");
                } else if (string.equals("Great circle")) {
                    MeasureToolPanel.this.measureTool.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
                }
            }
        });
        jPanel2.add(this.pathTypeCombo);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel3.add(new JLabel("Units:"));
        this.unitsCombo = new JComboBox<String>(new String[]{"M/M\u00b2", "KM/KM\u00b2", "KM/Hectare", "Feet/Feet\u00b2", "Miles/Miles\u00b2", "Nm/Miles\u00b2", "Yards/Acres"});
        this.unitsCombo.setSelectedItem("KM/KM\u00b2");
        this.unitsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
                if (string.equals("M/M\u00b2")) {
                    MeasureToolPanel.this.measureTool.getUnitsFormat().setLengthUnits("UnitsFormat.Meters");
                    MeasureToolPanel.this.measureTool.getUnitsFormat().setAreaUnits("UnitsFormat.SquareMeters");
                } else if (string.equals("KM/KM\u00b2")) {
                    MeasureToolPanel.this.measureTool.getUnitsFormat().setLengthUnits("UnitsFormat.Kilometers");
                    MeasureToolPanel.this.measureTool.getUnitsFormat().setAreaUnits("UnitsFormat.SquareKilometers");
                } else if (string.equals("KM/Hectare")) {
                    MeasureToolPanel.this.measureTool.getUnitsFormat().setLengthUnits("UnitsFormat.Kilometers");
                    MeasureToolPanel.this.measureTool.getUnitsFormat().setAreaUnits("UnitsFormat.Hectare");
                } else if (string.equals("Feet/Feet\u00b2")) {
                    MeasureToolPanel.this.measureTool.getUnitsFormat().setLengthUnits("UnitsFormat.Feet");
                    MeasureToolPanel.this.measureTool.getUnitsFormat().setAreaUnits("UnitsFormat.SquareFeet");
                } else if (string.equals("Miles/Miles\u00b2")) {
                    MeasureToolPanel.this.measureTool.getUnitsFormat().setLengthUnits("UnitsFormat.Miles");
                    MeasureToolPanel.this.measureTool.getUnitsFormat().setAreaUnits("UnitsFormat.SquareMiles");
                } else if (string.equals("Nm/Miles\u00b2")) {
                    MeasureToolPanel.this.measureTool.getUnitsFormat().setLengthUnits("UnitsFormat.NauticalMiles");
                    MeasureToolPanel.this.measureTool.getUnitsFormat().setAreaUnits("UnitsFormat.SquareMiles");
                } else if (string.equals("Yards/Acres")) {
                    MeasureToolPanel.this.measureTool.getUnitsFormat().setLengthUnits("UnitsFormat.Yards");
                    MeasureToolPanel.this.measureTool.getUnitsFormat().setAreaUnits("UnitsFormat.Acre");
                }
            }
        });
        jPanel3.add(this.unitsCombo);
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel4.add(new JLabel("Angle Format:"));
        this.anglesCombo = new JComboBox<String>(new String[]{"DD", "DMS"});
        this.anglesCombo.setSelectedItem("DD");
        this.anglesCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
                MeasureToolPanel.this.measureTool.getUnitsFormat().setShowDMS(string.equals("DMS"));
            }
        });
        jPanel4.add(this.anglesCombo);
        JPanel jPanel5 = new JPanel(new GridLayout(3, 2, 5, 5));
        jPanel5.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.followCheck = new JCheckBox("Follow terrain");
        this.followCheck.setSelected(this.measureTool.isFollowTerrain());
        this.followCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                MeasureToolPanel.this.measureTool.setFollowTerrain(jCheckBox.isSelected());
                MeasureToolPanel.this.wwd.redraw();
            }
        });
        jPanel5.add(this.followCheck);
        this.showControlsCheck = new JCheckBox("Control points");
        this.showControlsCheck.setSelected(this.measureTool.isShowControlPoints());
        this.showControlsCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                MeasureToolPanel.this.measureTool.setShowControlPoints(jCheckBox.isSelected());
                MeasureToolPanel.this.wwd.redraw();
            }
        });
        jPanel5.add(this.showControlsCheck);
        this.rubberBandCheck = new JCheckBox("Rubber band");
        this.rubberBandCheck.setSelected(this.measureTool.getController().isUseRubberBand());
        this.rubberBandCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                MeasureToolPanel.this.measureTool.getController().setUseRubberBand(jCheckBox.isSelected());
                MeasureToolPanel.this.freeHandCheck.setEnabled(jCheckBox.isSelected());
                MeasureToolPanel.this.wwd.redraw();
            }
        });
        jPanel5.add(this.rubberBandCheck);
        this.freeHandCheck = new JCheckBox("Free Hand");
        this.freeHandCheck.setSelected(this.measureTool.getController().isFreeHand());
        this.freeHandCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                MeasureToolPanel.this.measureTool.getController().setFreeHand(jCheckBox.isSelected());
                MeasureToolPanel.this.wwd.redraw();
            }
        });
        jPanel5.add(this.freeHandCheck);
        this.showAnnotationCheck = new JCheckBox("Tooltip");
        this.showAnnotationCheck.setSelected(this.measureTool.isShowAnnotation());
        this.showAnnotationCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                MeasureToolPanel.this.measureTool.setShowAnnotation(jCheckBox.isSelected());
                MeasureToolPanel.this.wwd.redraw();
            }
        });
        jPanel5.add(this.showAnnotationCheck);
        final JPanel jPanel6 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel6.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.lineColorButton = new JButton("Line");
        this.lineColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(jPanel6, "Choose a color...", ((JButton)actionEvent.getSource()).getBackground());
                if (color != null) {
                    ((JButton)actionEvent.getSource()).setBackground(color);
                    MeasureToolPanel.this.measureTool.setLineColor(color);
                    Color color2 = new Color((float)color.getRed() / 255.0f * 0.5f, (float)color.getGreen() / 255.0f * 0.5f, (float)color.getBlue() / 255.0f * 0.5f, 0.5f);
                    MeasureToolPanel.this.measureTool.setFillColor(color2);
                }
            }
        });
        jPanel6.add(this.lineColorButton);
        this.lineColorButton.setBackground(this.measureTool.getLineColor());
        this.pointColorButton = new JButton("Points");
        this.pointColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(jPanel6, "Choose a color...", ((JButton)actionEvent.getSource()).getBackground());
                if (color != null) {
                    ((JButton)actionEvent.getSource()).setBackground(color);
                    MeasureToolPanel.this.measureTool.getControlPointsAttributes().setBackgroundColor(color);
                }
            }
        });
        jPanel6.add(this.pointColorButton);
        this.pointColorButton.setBackground(this.measureTool.getControlPointsAttributes().getBackgroundColor());
        this.annotationColorButton = new JButton("Tooltip");
        this.annotationColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(jPanel6, "Choose a color...", ((JButton)actionEvent.getSource()).getBackground());
                if (color != null) {
                    ((JButton)actionEvent.getSource()).setBackground(color);
                    MeasureToolPanel.this.measureTool.getAnnotationAttributes().setTextColor(color);
                }
            }
        });
        this.annotationColorButton.setBackground(this.measureTool.getAnnotationAttributes().getTextColor());
        jPanel6.add(this.annotationColorButton);
        JPanel jPanel7 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel7.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.newButton = new JButton("New");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasureToolPanel.this.measureTool.clear();
                MeasureToolPanel.this.measureTool.setArmed(true);
            }
        });
        jPanel7.add(this.newButton);
        this.newButton.setEnabled(true);
        this.pauseButton = new JButton("Pause");
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasureToolPanel.this.measureTool.setArmed(!MeasureToolPanel.this.measureTool.isArmed());
                MeasureToolPanel.this.pauseButton.setText(!MeasureToolPanel.this.measureTool.isArmed() ? "Resume" : "Pause");
                MeasureToolPanel.this.pauseButton.setEnabled(true);
                ((Component)((Object)MeasureToolPanel.this.wwd)).setCursor(!MeasureToolPanel.this.measureTool.isArmed() ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(1));
            }
        });
        jPanel7.add(this.pauseButton);
        this.pauseButton.setEnabled(false);
        this.endButton = new JButton("End");
        this.endButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasureToolPanel.this.measureTool.setArmed(false);
            }
        });
        jPanel7.add(this.endButton);
        this.endButton.setEnabled(false);
        JPanel jPanel8 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel8.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JButton jButton = new JButton("Polyline");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasureToolPanel.this.shapeCombo.setSelectedIndex(1);
                MeasureToolPanel.this.measureTool.setMeasureShape(new Polyline(PATH));
            }
        });
        jPanel8.add(jButton);
        jButton = new JButton("Surf. Quad");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasureToolPanel.this.shapeCombo.setSelectedIndex(6);
                MeasureToolPanel.this.measureTool.setMeasureShape(new SurfaceQuad(Position.fromDegrees(44.0, 7.0, 0.0), 100000.0, 50000.0, Angle.fromDegrees(30.0)));
            }
        });
        jPanel8.add(jButton);
        jButton = new JButton("Polygon");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasureToolPanel.this.shapeCombo.setSelectedIndex(2);
                MeasureToolPanel.this.measureTool.setMeasureShape(new SurfacePolygon(POLYGON));
            }
        });
        jPanel8.add(jButton);
        JPanel jPanel9 = new JPanel(new GridLayout(0, 1, 0, 4));
        jPanel9.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.pointLabels = new JLabel[100];
        for (int i = 0; i < this.pointLabels.length; ++i) {
            this.pointLabels[i] = new JLabel("");
            jPanel9.add(this.pointLabels[i]);
        }
        JPanel jPanel10 = new JPanel(new BorderLayout());
        jPanel10.add((Component)jPanel9, "North");
        JScrollPane jScrollPane = new JScrollPane(jPanel10);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (dimension != null) {
            jScrollPane.setPreferredSize(dimension);
        }
        JPanel jPanel11 = new JPanel(new GridLayout(0, 2, 0, 4));
        jPanel11.setBorder(new CompoundBorder(new TitledBorder("Metric"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jPanel11.add(new JLabel("Length:"));
        this.lengthLabel = new JLabel();
        jPanel11.add(this.lengthLabel);
        jPanel11.add(new JLabel("Area:"));
        this.areaLabel = new JLabel();
        jPanel11.add(this.areaLabel);
        jPanel11.add(new JLabel("Width:"));
        this.widthLabel = new JLabel();
        jPanel11.add(this.widthLabel);
        jPanel11.add(new JLabel("Height:"));
        this.heightLabel = new JLabel();
        jPanel11.add(this.heightLabel);
        jPanel11.add(new JLabel("Heading:"));
        this.headingLabel = new JLabel();
        jPanel11.add(this.headingLabel);
        jPanel11.add(new JLabel("Center:"));
        this.centerLabel = new JLabel();
        jPanel11.add(this.centerLabel);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BoxLayout(jPanel12, 1));
        jPanel12.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Measure")));
        jPanel12.setToolTipText("Measure tool control and info");
        jPanel12.add(jPanel6);
        jPanel12.add(jPanel);
        jPanel12.add(jPanel2);
        jPanel12.add(jPanel3);
        jPanel12.add(jPanel4);
        jPanel12.add(jPanel5);
        jPanel12.add(jPanel7);
        jPanel12.add(jPanel11);
        jPanel12.add(jScrollPane);
        this.add((Component)jPanel12, "North");
    }

    private void fillPointsPanel() {
        int n = 0;
        if (this.measureTool.getPositions() != null) {
            for (Position position : this.measureTool.getPositions()) {
                if (n == this.pointLabels.length) break;
                String string = String.format("Lat %7.4f\u00b0", position.getLatitude().getDegrees());
                String string2 = String.format("Lon %7.4f\u00b0", position.getLongitude().getDegrees());
                this.pointLabels[n++].setText(string + "  " + string2);
            }
        }
        while (n < this.pointLabels.length) {
            this.pointLabels[n].setText("");
            ++n;
        }
    }

    private void updateMetric() {
        double d = this.measureTool.getLength();
        String string = d <= 0.0 ? "na" : (d < 1000.0 ? String.format("%,7.1f m", d) : String.format("%,7.3f km", d / 1000.0));
        this.lengthLabel.setText(string);
        d = this.measureTool.getArea();
        string = d < 0.0 ? "na" : (d < 1000000.0 ? String.format("%,7.1f m2", d) : String.format("%,7.3f km2", d / 1000000.0));
        this.areaLabel.setText(string);
        d = this.measureTool.getWidth();
        string = d < 0.0 ? "na" : (d < 1000.0 ? String.format("%,7.1f m", d) : String.format("%,7.3f km", d / 1000.0));
        this.widthLabel.setText(string);
        d = this.measureTool.getHeight();
        string = d < 0.0 ? "na" : (d < 1000.0 ? String.format("%,7.1f m", d) : String.format("%,7.3f km", d / 1000.0));
        this.heightLabel.setText(string);
        Angle angle = this.measureTool.getOrientation();
        string = angle != null ? String.format("%,6.2f\u00b0", angle.degrees) : "na";
        this.headingLabel.setText(string);
        Position position = this.measureTool.getCenterPosition();
        string = position != null ? String.format("%,7.4f\u00b0 %,7.4f\u00b0", position.getLatitude().degrees, position.getLongitude().degrees) : "na";
        this.centerLabel.setText(string);
    }

    static {
        LINE.add(Position.fromDegrees(44.0, 7.0, 0.0));
        LINE.add(Position.fromDegrees(45.0, 8.0, 0.0));
        PATH.addAll(LINE);
        PATH.add(Position.fromDegrees(46.0, 6.0, 0.0));
        PATH.add(Position.fromDegrees(47.0, 5.0, 0.0));
        PATH.add(Position.fromDegrees(45.0, 6.0, 0.0));
        POLYGON.addAll(PATH);
        POLYGON.add(Position.fromDegrees(44.0, 7.0, 0.0));
    }
}

