/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.layers.Layer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class LayerPanel
extends JPanel {
    protected JPanel layersPanel;
    protected JPanel westPanel;
    protected JScrollPane scrollPane;
    protected Font defaultFont;

    public LayerPanel(WorldWindow worldWindow) {
        super(new BorderLayout());
        this.makePanel(worldWindow, new Dimension(200, 400));
    }

    public LayerPanel(WorldWindow worldWindow, Dimension dimension) {
        super(new BorderLayout());
        this.makePanel(worldWindow, dimension);
    }

    protected void makePanel(WorldWindow worldWindow, Dimension dimension) {
        this.layersPanel = new JPanel(new GridLayout(0, 1, 0, 4));
        this.layersPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.fill(worldWindow);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.layersPanel, "North");
        this.scrollPane = new JScrollPane(jPanel);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (dimension != null) {
            this.scrollPane.setPreferredSize(dimension);
        }
        this.westPanel = new JPanel(new GridLayout(0, 1, 0, 10));
        this.westPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Layers")));
        this.westPanel.setToolTipText("Layers to Show");
        this.westPanel.add(this.scrollPane);
        this.add((Component)this.westPanel, "Center");
    }

    protected void fill(WorldWindow worldWindow) {
        for (Layer layer : worldWindow.getModel().getLayers()) {
            LayerAction layerAction = new LayerAction(layer, worldWindow, layer.isEnabled());
            JCheckBox jCheckBox = new JCheckBox(layerAction);
            jCheckBox.setSelected(layerAction.selected);
            this.layersPanel.add(jCheckBox);
            if (this.defaultFont != null) continue;
            this.defaultFont = jCheckBox.getFont();
        }
    }

    public void update(WorldWindow worldWindow) {
        this.layersPanel.removeAll();
        this.fill(worldWindow);
        this.westPanel.revalidate();
        this.westPanel.repaint();
    }

    @Override
    public void setToolTipText(String string) {
        this.scrollPane.setToolTipText(string);
    }

    protected static class LayerAction
    extends AbstractAction {
        protected WorldWindow wwd;
        protected Layer layer;
        protected boolean selected;

        public LayerAction(Layer layer, WorldWindow worldWindow, boolean bl) {
            super(layer.getName());
            this.wwd = worldWindow;
            this.layer = layer;
            this.selected = bl;
            this.layer.setEnabled(this.selected);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                this.layer.setEnabled(true);
            } else {
                this.layer.setEnabled(false);
            }
            this.wwd.redraw();
        }
    }
}

