/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.IconLayer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.UserFacingIcon;
import gov.nasa.worldwind.render.WWIcon;
import gov.nasa.worldwind.util.BasicDragger;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.AudioPlayerAnnotation;
import gov.nasa.worldwindx.examples.util.AudioPlayerAnnotationController;
import gov.nasa.worldwindx.examples.util.DialogAnnotation;
import gov.nasa.worldwindx.examples.util.DialogAnnotationController;
import gov.nasa.worldwindx.examples.util.SlideShowAnnotation;
import gov.nasa.worldwindx.examples.util.SlideShowAnnotationController;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.swing.SwingUtilities;

public class AnnotationControls
extends ApplicationTemplate {
    protected static final String AUDIO = "Audio";
    protected static final String IMAGES = "Images";
    protected static final String ICON_AUDIO = "gov/nasa/worldwindx/examples/images/audioicon-64.png";
    protected static final String ICON_IMAGES = "gov/nasa/worldwindx/examples/images/imageicon-64.png";
    protected static final String AUDIO_PATH_MUSIC = "gov/nasa/worldwindx/examples/data/spacemusic.au";
    protected static final String IMAGE_PATH_MT_ST_HELENS = "gov/nasa/worldwindx/examples/images/MountStHelens.jpg";
    protected static final String IMAGE_PATH_THE_NUT = "gov/nasa/worldwindx/examples/images/the_nut.jpg";
    protected static final String IMAGE_PATH_IRELAND = "gov/nasa/worldwindx/examples/images/ireland.jpg";
    protected static final String IMAGE_PATH_NEW_ZEALAND = "gov/nasa/worldwindx/examples/images/new_zealand.gif";

    public static IconLayer createIconLayer() {
        IconLayer iconLayer = new IconLayer();
        iconLayer.setPickEnabled(true);
        WWIcon wWIcon = AnnotationControls.createIcon(AUDIO, Position.fromDegrees(28.533513, -81.375789, 0.0), "Music from the Java Sound demo", AUDIO_PATH_MUSIC);
        iconLayer.addIcon(wWIcon);
        wWIcon = AnnotationControls.createIcon(IMAGES, Position.fromDegrees(46.1912, -122.1944, 0.0), "", Arrays.asList(IMAGE_PATH_MT_ST_HELENS));
        iconLayer.addIcon(wWIcon);
        wWIcon = AnnotationControls.createIcon(IMAGES, Position.fromDegrees(-12.0, -70.0, 0.0), "", Arrays.asList(IMAGE_PATH_IRELAND, IMAGE_PATH_NEW_ZEALAND, IMAGE_PATH_THE_NUT));
        iconLayer.addIcon(wWIcon);
        return iconLayer;
    }

    public static WWIcon createIcon(Object object, Position position, String string, Object object2) {
        if (position == null) {
            String string2 = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (object2 == null) {
            String string4 = Logging.getMessage("nullValue.DataSetIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        String string5 = object == AUDIO ? ICON_AUDIO : ICON_IMAGES;
        UserFacingIcon userFacingIcon = new UserFacingIcon(string5, position);
        userFacingIcon.setSize(new Dimension(64, 64));
        userFacingIcon.setValue("gov.nasa.worldwind.avkey.DataType", object);
        userFacingIcon.setValue("gov.nasa.worldwind.avkey.Title", string);
        userFacingIcon.setValue("gov.nasa.worldwind.avkey.URL", object2);
        return userFacingIcon;
    }

    public static ContentAnnotation createContentAnnotation(AppFrame appFrame, Position position, AVList aVList) {
        if (appFrame == null) {
            String string = "AppFrameIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParamsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = aVList.getStringValue("gov.nasa.worldwind.avkey.DataType");
        String string2 = aVList.getStringValue("gov.nasa.worldwind.avkey.Title");
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.URL");
        if (string == AUDIO) {
            return AnnotationControls.createAudioAnnotation(appFrame, position, string2, object);
        }
        if (string == IMAGES) {
            return AnnotationControls.createImageAnnotation(appFrame, position, string2, (Iterable)object);
        }
        return null;
    }

    public static ContentAnnotation createAudioAnnotation(AppFrame appFrame, Position position, String string, Object object) {
        if (appFrame == null) {
            String string2 = "AppFrameIsNull";
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (position == null) {
            String string3 = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (object == null) {
            String string5 = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        AudioPlayerAnnotation audioPlayerAnnotation = new AudioPlayerAnnotation(position);
        audioPlayerAnnotation.setAlwaysOnTop(true);
        audioPlayerAnnotation.getTitleLabel().setText(string);
        AudioPlayerAnnotationController audioPlayerAnnotationController = new AudioPlayerAnnotationController(appFrame.getWwd(), audioPlayerAnnotation);
        return new AudioContentAnnotation(appFrame, audioPlayerAnnotation, audioPlayerAnnotationController, object);
    }

    public static ContentAnnotation createImageAnnotation(AppFrame appFrame, Position position, String string, Iterable iterable) {
        if (appFrame == null) {
            String string2 = "AppFrameIsNull";
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (position == null) {
            String string3 = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (iterable == null) {
            String string5 = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        SlideShowAnnotation slideShowAnnotation = new SlideShowAnnotation(position);
        slideShowAnnotation.setAlwaysOnTop(true);
        slideShowAnnotation.getTitleLabel().setText(string);
        SlideShowAnnotationController slideShowAnnotationController = new SlideShowAnnotationController(appFrame.getWwd(), slideShowAnnotation, iterable);
        return new ImageContentAnnotation(appFrame, slideShowAnnotation, slideShowAnnotationController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Clip openAudioStream(InputStream inputStream) throws Exception {
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Clip clip = null;
        AudioInputStream audioInputStream = null;
        try {
            Object object;
            audioInputStream = AudioSystem.getAudioInputStream(WWIO.getBufferedInputStream(inputStream));
            Object object2 = audioInputStream.getFormat();
            if (((AudioFormat)object2).getEncoding() == AudioFormat.Encoding.ULAW || ((AudioFormat)object2).getEncoding() == AudioFormat.Encoding.ALAW) {
                object = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, ((AudioFormat)object2).getSampleRate(), ((AudioFormat)object2).getSampleSizeInBits() * 2, ((AudioFormat)object2).getChannels(), ((AudioFormat)object2).getFrameSize() * 2, ((AudioFormat)object2).getFrameRate(), true);
                audioInputStream = AudioSystem.getAudioInputStream((AudioFormat)object, audioInputStream);
                object2 = object;
            }
            object = new DataLine.Info(Clip.class, audioInputStream.getFormat(), (int)audioInputStream.getFrameLength() * ((AudioFormat)object2).getFrameSize());
            clip = (Clip)AudioSystem.getLine((Line.Info)object);
            clip.open(audioInputStream);
        }
        finally {
            if (audioInputStream != null) {
                audioInputStream.close();
            }
        }
        return clip;
    }

    public static String createErrorTitle(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot open the resource at <i>").append(string).append("</i>");
        return stringBuilder.toString();
    }

    public static String createTitle(Iterable iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            stringBuilder.append(t);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Annotation Controls", AppFrame.class);
    }

    public static class ImageContentAnnotation
    extends ContentAnnotation {
        public ImageContentAnnotation(AppFrame appFrame, SlideShowAnnotation slideShowAnnotation, SlideShowAnnotationController slideShowAnnotationController) {
            super(appFrame, slideShowAnnotation, slideShowAnnotationController);
        }

        @Override
        public void detach() {
            super.detach();
            SlideShowAnnotationController slideShowAnnotationController = (SlideShowAnnotationController)this.getController();
            if (slideShowAnnotationController != null) {
                this.stopController(slideShowAnnotationController);
            }
        }

        protected void stopController(SlideShowAnnotationController slideShowAnnotationController) {
            String string = slideShowAnnotationController.getState();
            if (string == "gov.nasa.worldwind.avkey.Play") {
                slideShowAnnotationController.stopSlideShow();
            }
            slideShowAnnotationController.stopRetrievalTasks();
        }
    }

    public static class AudioContentAnnotation
    extends ContentAnnotation {
        protected Clip clip;
        protected Object source;
        protected Thread readThread;

        public AudioContentAnnotation(AppFrame appFrame, AudioPlayerAnnotation audioPlayerAnnotation, AudioPlayerAnnotationController audioPlayerAnnotationController, Object object) {
            super(appFrame, audioPlayerAnnotation, audioPlayerAnnotationController);
            this.source = object;
            this.retrieveAndSetClip(object);
        }

        public Object getSource() {
            return this.source;
        }

        @Override
        public void detach() {
            super.detach();
            AudioPlayerAnnotationController audioPlayerAnnotationController = (AudioPlayerAnnotationController)this.getController();
            if (audioPlayerAnnotationController != null) {
                this.stopController(audioPlayerAnnotationController);
            }
            this.stopClipRetrieval();
        }

        protected void stopController(AudioPlayerAnnotationController audioPlayerAnnotationController) {
            String string = audioPlayerAnnotationController.getClipStatus();
            if (string == "gov.nasa.worldwind.avkey.Play") {
                audioPlayerAnnotationController.stopClip();
            }
        }

        protected void retrieveAndSetClip(Object object) {
            this.startClipRetrieval(object);
        }

        protected void doRetrieveAndSetClip(final Object object) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AudioContentAnnotation.this.getAnnotation().setBusy(true);
                    AudioContentAnnotation.this.appFrame.getWwd().redraw();
                }
            });
            final Clip clip = this.readClip(object);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AudioPlayerAnnotation audioPlayerAnnotation;
                    AudioPlayerAnnotationController audioPlayerAnnotationController = (AudioPlayerAnnotationController)AudioContentAnnotation.this.getController();
                    if (audioPlayerAnnotationController != null) {
                        audioPlayerAnnotationController.setClip(clip);
                    }
                    if ((audioPlayerAnnotation = (AudioPlayerAnnotation)AudioContentAnnotation.this.getAnnotation()) != null && clip == null) {
                        audioPlayerAnnotation.getTitleLabel().setText(AnnotationControls.createErrorTitle(object.toString()));
                    }
                    AudioContentAnnotation.this.getAnnotation().setBusy(false);
                    AudioContentAnnotation.this.appFrame.getWwd().redraw();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Clip readClip(Object object) {
            InputStream inputStream = null;
            try {
                inputStream = WWIO.openStream(object);
                Clip clip = AnnotationControls.openAudioStream(inputStream);
                return clip;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                WWIO.closeStream(inputStream, object.toString());
            }
            return null;
        }

        protected void startClipRetrieval(final Object object) {
            this.readThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    AudioContentAnnotation.this.doRetrieveAndSetClip(object);
                }
            });
            this.readThread.start();
        }

        protected void stopClipRetrieval() {
            if (this.readThread != null && this.readThread.isAlive()) {
                this.readThread.interrupt();
            }
            this.readThread = null;
        }
    }

    public static class ContentAnnotation
    implements ActionListener {
        protected AppFrame appFrame;
        protected DialogAnnotation annnotation;
        protected DialogAnnotationController controller;

        public ContentAnnotation(AppFrame appFrame, DialogAnnotation dialogAnnotation, DialogAnnotationController dialogAnnotationController) {
            this.appFrame = appFrame;
            this.annnotation = dialogAnnotation;
            this.annnotation.addActionListener(this);
            this.controller = dialogAnnotationController;
        }

        public AppFrame getAppFrame() {
            return this.appFrame;
        }

        public DialogAnnotation getAnnotation() {
            return this.annnotation;
        }

        public DialogAnnotationController getController() {
            return this.controller;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent == null) {
                return;
            }
            if (actionEvent.getActionCommand() == "gov.nasa.worldwind.avkey.Close") {
                this.getAppFrame().closeResource(this);
            }
        }

        public void detach() {
            this.getController().setEnabled(false);
            RenderableLayer renderableLayer = this.getAppFrame().getContentLayer();
            renderableLayer.removeRenderable(this.getAnnotation());
        }

        public void attach() {
            this.getController().setEnabled(true);
            RenderableLayer renderableLayer = this.appFrame.getContentLayer();
            renderableLayer.removeRenderable(this.getAnnotation());
            renderableLayer.addRenderable(this.getAnnotation());
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame
    implements SelectListener {
        protected IconLayer iconLayer = AnnotationControls.createIconLayer();
        protected WWIcon highlit;
        protected RenderableLayer contentLayer = new RenderableLayer();
        protected BasicDragger dragger;

        public AppFrame() {
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), this.iconLayer);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), this.contentLayer);
            this.getWwd().addSelectListener(this);
            this.dragger = new BasicDragger(this.getWwd());
        }

        public IconLayer getIconLayer() {
            return this.iconLayer;
        }

        public RenderableLayer getContentLayer() {
            return this.contentLayer;
        }

        @Override
        public void selected(SelectEvent selectEvent) {
            if (selectEvent == null) {
                return;
            }
            PickedObject pickedObject = selectEvent.getTopPickedObject();
            if (selectEvent.getEventAction() == "gov.nasa.worldwind.SelectEvent.LeftPress") {
                if (pickedObject != null && pickedObject.getObject() instanceof WWIcon) {
                    WWIcon wWIcon = (WWIcon)pickedObject.getObject();
                    this.highlight(wWIcon);
                } else {
                    this.highlight(null);
                }
            } else if (selectEvent.getEventAction() == "gov.nasa.worldwind.SelectEvent.LeftDoubleClick") {
                if (pickedObject != null && pickedObject.getObject() instanceof WWIcon) {
                    WWIcon wWIcon = (WWIcon)pickedObject.getObject();
                    this.highlight(wWIcon);
                    this.openResource(wWIcon);
                }
            } else if (selectEvent.getEventAction() == "gov.nasa.worldwind.SelectEvent.Drag" || selectEvent.getEventAction() == "gov.nasa.worldwind.SelectEvent.DragEnd") {
                this.dragger.selected(selectEvent);
            }
        }

        public void highlight(WWIcon wWIcon) {
            if (this.highlit == wWIcon) {
                return;
            }
            if (this.highlit != null) {
                this.highlit.setHighlighted(false);
                this.highlit = null;
            }
            if (wWIcon != null) {
                this.highlit = wWIcon;
                this.highlit.setHighlighted(true);
            }
            this.getWwd().redraw();
        }

        protected void closeResource(ContentAnnotation contentAnnotation) {
            if (contentAnnotation == null) {
                return;
            }
            contentAnnotation.detach();
        }

        protected void openResource(WWIcon wWIcon) {
            if (wWIcon == null) {
                return;
            }
            ContentAnnotation contentAnnotation = this.createContent(wWIcon.getPosition(), wWIcon);
            if (contentAnnotation != null) {
                contentAnnotation.attach();
            }
        }

        protected ContentAnnotation createContent(Position position, AVList aVList) {
            return AnnotationControls.createContentAnnotation(this, position, aVList);
        }
    }
}

