/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar.actions;

import gov.nasa.worldwindx.applications.sar.PositionTable;
import gov.nasa.worldwindx.applications.sar.SARPosition;
import gov.nasa.worldwindx.applications.sar.SARTrack;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class InsertPositionAction
extends AbstractAction {
    private final boolean above;
    protected final PositionTable table;

    public InsertPositionAction(boolean bl, PositionTable positionTable) {
        this.table = positionTable;
        this.above = bl;
        if (this.above) {
            this.putValue("Name", "Insert New Position Above Selection");
            this.putValue("LongDescription", "Insert a new position above the selected positions");
        } else {
            this.putValue("Name", "Insert New Position Below Selection");
            this.putValue("LongDescription", "Insert a new position below the selected positions");
        }
        if (positionTable.getSelectedRowCount() == 0) {
            this.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SARTrack sARTrack = this.table.getSarTrack();
        if (sARTrack == null) {
            return;
        }
        int n = this.table.getSelectionModel().getMinSelectionIndex();
        if (!this.above) {
            n = this.table.getSelectionModel().getMaxSelectionIndex();
        }
        if (n < 0) {
            return;
        }
        sARTrack.insertPosition(n, new SARPosition());
        this.table.getSelectionModel().setSelectionInterval(n, n);
    }
}

