/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.event.PositionListener;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwindx.applications.sar.SARPosition;
import gov.nasa.worldwindx.applications.sar.SARTrack;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class SARTrackBuilder {
    private WorldWindow wwd;
    private SARTrack sarTrack;
    private boolean armed = false;
    private boolean active = false;
    private boolean useTrackElevation = false;
    private MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SARTrackBuilder.this.armed && SARTrackBuilder.this.sarTrack != null && mouseEvent.getButton() == 1) {
                if (SARTrackBuilder.this.armed && (mouseEvent.getModifiersEx() & 0x400) != 0 && mouseEvent.isAltDown() && !mouseEvent.isControlDown()) {
                    SARTrackBuilder.this.active = true;
                    SARTrackBuilder.this.addPosition();
                }
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SARTrackBuilder.this.armed && SARTrackBuilder.this.sarTrack != null && mouseEvent.getButton() == 1) {
                SARTrackBuilder.this.active = false;
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SARTrackBuilder.this.armed && SARTrackBuilder.this.sarTrack != null && mouseEvent.getButton() == 1) {
                if (mouseEvent.isControlDown()) {
                    SARTrackBuilder.this.removeLastTrackPoint();
                }
                mouseEvent.consume();
            }
        }
    };
    private MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(){

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (SARTrackBuilder.this.armed && SARTrackBuilder.this.sarTrack != null && (mouseEvent.getModifiersEx() & 0x400) != 0 && SARTrackBuilder.this.active) {
                mouseEvent.consume();
            }
        }
    };
    private PositionListener positionListener = new PositionListener(){

        @Override
        public void moved(PositionEvent positionEvent) {
            if (!SARTrackBuilder.this.active || SARTrackBuilder.this.sarTrack == null) {
                return;
            }
            SARTrackBuilder.this.replacePosition();
        }
    };

    public void setWwd(WorldWindow worldWindow) {
        if (this.wwd == worldWindow) {
            return;
        }
        if (this.wwd != null) {
            this.wwd.getInputHandler().removeMouseListener(this.mouseAdapter);
            this.wwd.getInputHandler().removeMouseMotionListener(this.mouseMotionAdapter);
            this.wwd.removePositionListener(this.positionListener);
        }
        this.wwd = worldWindow;
        this.wwd.getInputHandler().addMouseListener(this.mouseAdapter);
        this.wwd.getInputHandler().addMouseMotionListener(this.mouseMotionAdapter);
        this.wwd.addPositionListener(this.positionListener);
    }

    public void setTrack(SARTrack sARTrack) {
        this.sarTrack = sARTrack;
    }

    public boolean isUseTrackElevation() {
        return this.useTrackElevation;
    }

    public void setUseTrackElevation(boolean bl) {
        this.useTrackElevation = bl;
    }

    public boolean isArmed() {
        return this.armed;
    }

    public void setArmed(boolean bl) {
        this.armed = bl;
        if (this.armed) {
            ((Component)((Object)this.wwd)).setCursor(new Cursor(1));
        } else {
            ((Component)((Object)this.wwd)).setCursor(Cursor.getDefaultCursor());
        }
    }

    private void addPosition() {
        Position position;
        Position position2 = position = this.wwd != null ? this.wwd.getCurrentPosition() : null;
        if (position == null) {
            return;
        }
        if (this.useTrackElevation && this.sarTrack.size() > 0) {
            position = new Position(position, this.sarTrack.get(this.sarTrack.size() - 1).getElevation());
        }
        this.sarTrack.appendPosition(new SARPosition(position));
    }

    private void replacePosition() {
        int n;
        Position position;
        Position position2 = position = this.wwd != null ? this.wwd.getCurrentPosition() : null;
        if (position == null) {
            return;
        }
        if (this.useTrackElevation && this.sarTrack.size() > 0) {
            position = new Position(position, this.sarTrack.get(this.sarTrack.size() - 1).getElevation());
        }
        if ((n = this.sarTrack.size() - 1) < 0) {
            n = 0;
        }
        this.sarTrack.set(n, new SARPosition(position));
    }

    public boolean canRemoveLastTrackPoint() {
        return this.sarTrack != null && this.sarTrack.size() != 0;
    }

    public void removeLastTrackPoint() {
        if (this.sarTrack == null || this.sarTrack.size() == 0) {
            return;
        }
        this.sarTrack.removePosition(this.sarTrack.size() - 1);
    }
}

