/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwindx.applications.sar.NOSALicenseAgreement;
import gov.nasa.worldwindx.applications.sar.SAR2;

public class SARApp {
    public static final String APP_NAME = "World Wind Search and Rescue Prototype";
    public static final String APP_VERSION = "(Version 6.2 released 7/15/2010)";
    public static final String APP_NAME_AND_VERSION = "World Wind Search and Rescue Prototype (Version 6.2 released 7/15/2010)";

    private static boolean checkLicenseAgreement() {
        NOSALicenseAgreement nOSALicenseAgreement = new NOSALicenseAgreement(APP_NAME_AND_VERSION);
        String string = nOSALicenseAgreement.checkForLicenseAgreement(null);
        return string.equals("gov.nasa.worldwind.LicenseAccepted") || string.equals("gov.nasa.worldwind.LicenseAcceptedAndInstalled");
    }

    public static void main(String[] stringArray) {
        boolean bl = SARApp.checkLicenseAgreement();
        if (bl) {
            SAR2 sAR2 = new SAR2();
            sAR2.setVisible(true);
        } else {
            System.exit(0);
        }
    }

    static {
        System.setProperty("gov.nasa.worldwind.config.file", "gov/nasa/worldwindx/applications/sar/config/SAR.properties");
        if (Configuration.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", APP_NAME);
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
        }
    }
}

