/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.dataimporter;

import gov.nasa.worldwindx.applications.dataimporter.FileStoreDataSet;
import gov.nasa.worldwindx.applications.dataimporter.FileStoreTableModel;
import gov.nasa.worldwindx.applications.dataimporter.TableCellColorRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class FileStoreTable
extends JTable {
    public static final String VISIBLE = "gov.nasa.worldwindx.dataimport.FileStoreTable.Visible";

    public FileStoreTable() {
        super(new FileStoreTableModel());
        this.setIntercellSpacing(new Dimension(10, 1));
        this.setDefaultRenderer(Color.class, new TableCellColorRenderer(true));
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(2);
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(10);
        tableColumn = this.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(20);
        NameRenderer nameRenderer = new NameRenderer();
        tableColumn = this.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(nameRenderer);
        tableColumn = this.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(nameRenderer);
        tableColumn = this.getColumnModel().getColumn(3);
        tableColumn.setCellRenderer(nameRenderer);
    }

    public void setDataSets(List<FileStoreDataSet> list) {
        ((FileStoreTableModel)this.getModel()).setDataSets(list);
        this.setPreferredColumnWidths();
    }

    public List<FileStoreDataSet> getSelectedDataSets() {
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<FileStoreDataSet> arrayList = new ArrayList<FileStoreDataSet>();
        for (int n : nArray) {
            int n2 = this.convertRowIndexToModel(n);
            if (n2 >= ((FileStoreTableModel)this.getModel()).dataSets.size() || ((FileStoreTableModel)this.getModel()).dataSets.get(n2).getValue(VISIBLE) == null) continue;
            arrayList.add(((FileStoreTableModel)this.getModel()).dataSets.get(n2));
        }
        return arrayList;
    }

    protected void setPreferredColumnWidths() {
        for (int i = 1; i < this.getColumnModel().getColumnCount(); ++i) {
            JLabel jLabel = new JLabel(this.getColumnName(i));
            int n = jLabel.getPreferredSize().width;
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            for (int j = 0; j < this.getModel().getRowCount(); ++j) {
                jLabel = new JLabel(this.getValueAt(j, i).toString());
                if (jLabel.getPreferredSize().width <= n) continue;
                n = jLabel.getPreferredSize().width;
            }
            tableColumn.setPreferredWidth(n);
        }
    }

    public void scrollToDataSet(FileStoreDataSet fileStoreDataSet) {
        Integer n = ((FileStoreTableModel)this.getModel()).getRowForDataSet(fileStoreDataSet);
        if (n != null) {
            this.scrollToVisible(n, 0);
        }
    }

    public void scrollToVisible(int n, int n2) {
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jViewport = (JViewport)this.getParent();
        Rectangle rectangle = this.getCellRect(n, n2, true);
        Point point = jViewport.getViewPosition();
        rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
        jViewport.scrollRectToVisible(rectangle);
    }

    class NameRenderer
    extends DefaultTableCellRenderer {
        protected boolean enabled;

        NameRenderer() {
        }

        @Override
        public void setValue(Object object) {
            super.setValue(object);
            FileStoreDataSet fileStoreDataSet = ((FileStoreTableModel)FileStoreTable.this.getModel()).getDataSetByName(object.toString());
            if (fileStoreDataSet != null) {
                this.enabled = fileStoreDataSet.getValue(FileStoreTable.VISIBLE) != null;
            }
            this.setEnabled(this.enabled);
            this.setHorizontalAlignment(object instanceof Formatter ? 4 : 2);
        }
    }
}

