/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.antenna;

import com.jogamp.common.nio.Buffers;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Sphere;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.AbstractShape;
import gov.nasa.worldwind.render.BasicWWTexture;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.terrain.Terrain;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.applications.antenna.Interpolator2D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import javax.media.opengl.GL2;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class AntennaModel
extends AbstractShape {
    public static final int DISPLAY_MODE_FILL = 6914;
    public static final int DISPLAY_MODE_LINE = 6913;
    public static final int DISPLAY_MODE_POINT = 6912;
    protected int nThetaIntervals;
    protected int nPhiIntervals;
    protected WWTexture texture;
    protected Interpolator2D interpolator;
    protected Position position = Position.ZERO;
    protected Angle azimuth;
    protected Angle elevationAngle;
    protected double gainOffset = 0.0;
    protected double gainScale = 1.0;
    protected int nThetaPoints = 61;
    protected int nPhiPoints = 121;

    @Override
    protected AbstractShape.AbstractShapeData createCacheEntry(DrawContext drawContext) {
        return new ShapeData(drawContext, this);
    }

    protected ShapeData getCurrent() {
        return (ShapeData)this.getCurrentData();
    }

    public AntennaModel(Interpolator2D interpolator2D) {
        this.interpolator = interpolator2D;
        this.nThetaIntervals = this.nThetaPoints - 1;
        this.nPhiIntervals = this.nPhiPoints - 1;
    }

    @Override
    protected void initialize() {
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.position = position;
        this.reset();
    }

    public Angle getAzimuth() {
        return this.azimuth;
    }

    public void setAzimuth(Angle angle) {
        this.azimuth = angle;
    }

    public Angle getElevationAngle() {
        return this.elevationAngle;
    }

    public void setElevationAngle(Angle angle) {
        this.elevationAngle = angle;
    }

    public double getGainOffset() {
        return this.gainOffset;
    }

    public void setGainOffset(double d) {
        this.gainOffset = d;
        this.reset();
    }

    public double getGainScale() {
        return this.gainScale;
    }

    public void setGainScale(double d) {
        this.gainScale = d;
        this.reset();
    }

    public int getThetaResolution() {
        return this.nThetaPoints;
    }

    public void setThetaResolution(int n) {
        this.nThetaPoints = n;
        this.nThetaIntervals = n - 1;
        this.reset();
    }

    public int getPhiResolution() {
        return this.nPhiPoints;
    }

    public void setPhiResolution(int n) {
        this.nPhiPoints = n;
        this.nPhiIntervals = n - 1;
        this.reset();
    }

    public double getRadius() {
        return this.interpolator.getMaxValue() + this.gainOffset;
    }

    @Override
    public Position getReferencePosition() {
        return this.getPosition();
    }

    public void setColorRamp(BufferedImage bufferedImage) {
        if (bufferedImage != null) {
            this.texture = new BasicWWTexture(bufferedImage, true);
        }
    }

    public BufferedImage getColorRamp() {
        if (this.texture != null && this.texture.getImageSource() instanceof BufferedImage) {
            return (BufferedImage)this.texture.getImageSource();
        }
        return null;
    }

    @Override
    public Extent getExtent(Globe globe, double d) {
        Extent extent = super.getExtent(globe, d);
        if (extent != null) {
            return extent;
        }
        this.getCurrent().setExtent(new Sphere(globe.computePointFromPosition(this.getReferencePosition()), this.getRadius()));
        return this.getCurrent().getExtent();
    }

    @Override
    public Sector getSector() {
        if (this.sector == null) {
            this.sector = null;
        }
        return this.sector;
    }

    @Override
    protected boolean mustApplyTexture(DrawContext drawContext) {
        return true;
    }

    @Override
    protected boolean shouldUseVBOs(DrawContext drawContext) {
        return false;
    }

    @Override
    protected boolean mustRegenerateGeometry(DrawContext drawContext) {
        ShapeData shapeData = this.getCurrent();
        if (shapeData.vertices == null) {
            return true;
        }
        if (this.getAltitudeMode() == 0 && shapeData.getGlobeStateKey() != null && shapeData.getGlobeStateKey().equals(drawContext.getGlobe().getGlobeStateKey(drawContext))) {
            return false;
        }
        Vec4 vec4 = this.computePoint(drawContext.getTerrain(), this.getPosition());
        if (shapeData.getReferencePoint() != null && shapeData.getReferencePoint().equals(vec4)) {
            return false;
        }
        return super.mustRegenerateGeometry(drawContext);
    }

    @Override
    protected boolean doMakeOrderedRenderable(DrawContext drawContext) {
        if (!this.intersectsFrustum(drawContext)) {
            return false;
        }
        this.makeVertices(drawContext);
        ShapeData shapeData = this.getCurrent();
        if (shapeData.indices == null) {
            this.makeIndices();
        }
        if (shapeData.normals == null) {
            this.makeNormals();
        }
        return true;
    }

    @Override
    protected boolean isOrderedRenderableValid(DrawContext drawContext) {
        ShapeData shapeData = this.getCurrent();
        return shapeData.vertices != null && shapeData.indices != null && shapeData.normals != null;
    }

    @Override
    protected void doDrawOutline(DrawContext drawContext) {
        this.drawModel(drawContext, 6913, !this.isHighlighted());
    }

    @Override
    protected void doDrawInterior(DrawContext drawContext) {
        this.drawModel(drawContext, 6914, true);
    }

    public void drawModel(DrawContext drawContext, int n, boolean bl) {
        ShapeData shapeData = this.getCurrent();
        GL2 gL2 = drawContext.getGL().getGL2();
        if (this.texture == null) {
            this.makeTexture();
        }
        gL2.glPolygonMode(1032, n);
        if (!drawContext.isPickingMode() && bl) {
            gL2.glEnable(3553);
            gL2.glEnableClientState(32888);
            gL2.glTexCoordPointer(2, 5126, 0, shapeData.texCoords.rewind());
            this.texture.bind(drawContext);
        }
        gL2.glPushMatrix();
        gL2.glRotated(this.getPosition().getLongitude().degrees, 0.0, 1.0, 0.0);
        gL2.glRotated(Math.abs(90.0 - this.getPosition().getLatitude().degrees), 1.0, 0.0, 0.0);
        if (this.getAzimuth() != null) {
            gL2.glRotated(-this.getAzimuth().degrees, 0.0, 1.0, 0.0);
        }
        if (this.getElevationAngle() != null) {
            gL2.glRotated(this.getElevationAngle().degrees, 1.0, 0.0, 0.0);
        }
        gL2.glVertexPointer(3, 5126, 0, shapeData.vertices.rewind());
        if (!drawContext.isPickingMode() && this.mustApplyLighting(drawContext, null)) {
            gL2.glNormalPointer(5126, 0, shapeData.normals.rewind());
        }
        for (IntBuffer intBuffer : shapeData.indices) {
            gL2.glDrawElements(5, intBuffer.limit(), 5125, intBuffer.rewind());
        }
        gL2.glPopMatrix();
        if (!drawContext.isPickingMode()) {
            gL2.glDisableClientState(32888);
        }
    }

    private void makeVertices(DrawContext drawContext) {
        ShapeData shapeData = this.getCurrent();
        Vec4 vec4 = this.computePoint(drawContext.getTerrain(), this.getPosition());
        if (shapeData.getReferencePoint() != null && shapeData.getReferencePoint().equals(vec4)) {
            return;
        }
        shapeData.setReferencePoint(vec4);
        int n = (this.nThetaIntervals + 1) * (this.nPhiIntervals + 1);
        shapeData.vertices = Buffers.newDirectFloatBuffer((int)(3 * n));
        shapeData.texCoords = Buffers.newDirectFloatBuffer((int)(2 * n));
        double d = 1.0 / (this.getMaxR() - this.getMinR());
        double d2 = -1.7976931348623157E308;
        double d3 = -1.7976931348623157E308;
        double d4 = -1.7976931348623157E308;
        double d5 = 180 / this.nThetaIntervals;
        double d6 = 360 / this.nPhiIntervals;
        for (int i = 0; i <= this.nThetaIntervals; ++i) {
            for (int j = 0; j <= this.nPhiIntervals; ++j) {
                double d7 = (double)i * d5;
                double d8 = (double)j * d6;
                double d9 = d7 * Math.PI / 180.0;
                double d10 = d8 * Math.PI / 180.0;
                Double d11 = this.interpolator.getValue(d7, d8);
                double d12 = d11 != null ? (d11 - this.getMinR()) * d : 0.0;
                shapeData.texCoords.put((float)d12).put(0.0f);
                double d13 = d11 != null ? (d11 + this.gainOffset) * this.gainScale : 0.0;
                double d14 = d13 * Math.sin(d9) * Math.cos(d10);
                double d15 = d13 * Math.sin(d9) * Math.sin(d10);
                double d16 = d13 * Math.cos(d9);
                double d17 = Math.abs(d15);
                double d18 = Math.abs(d16);
                double d19 = Math.abs(d14);
                if (d17 > d2) {
                    d2 = d17;
                }
                if (d18 > d3) {
                    d3 = d18;
                }
                if (d19 > d4) {
                    d4 = d19;
                }
                shapeData.vertices.put((float)d15).put((float)d16).put((float)d14);
            }
        }
        shapeData.setExtent(new Sphere(vec4, Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4)));
    }

    private double getMinR() {
        Double d = this.interpolator.getMinValue();
        return d != null ? d : 0.0;
    }

    private double getMaxR() {
        Double d = this.interpolator.getMaxValue();
        return d != null ? d : 1.0;
    }

    private void makeIndices() {
        ShapeData shapeData = this.getCurrent();
        shapeData.indices = new IntBuffer[this.nThetaIntervals];
        for (int i = 0; i < this.nThetaIntervals; ++i) {
            shapeData.indices[i] = Buffers.newDirectIntBuffer((int)(2 * this.nPhiIntervals + 2));
            for (int j = 0; j <= this.nPhiIntervals; ++j) {
                int n = j + i * (this.nPhiIntervals + 1);
                int n2 = n + this.nPhiIntervals + 1;
                shapeData.indices[i].put(n).put(n2);
            }
        }
    }

    private void makeTexture() {
        BufferedImage bufferedImage = new BufferedImage(240, 2, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            graphics2D.setPaint(Color.getHSBColor((float)((double)(bufferedImage.getWidth() - i) / 360.0), 1.0f, 1.0f));
            graphics2D.fillRect(i, 0, 1, 2);
        }
        this.texture = new BasicWWTexture(bufferedImage, true);
    }

    protected void makeNormals() {
        ShapeData shapeData = this.getCurrent();
        shapeData.normals = Buffers.newDirectFloatBuffer((int)shapeData.vertices.limit());
        for (int i = 0; i <= this.nThetaIntervals; ++i) {
            for (int j = 0; j <= this.nPhiIntervals; ++j) {
                Vec4 vec4;
                Vec4 vec42;
                Vec4 vec43;
                Vec4 vec44;
                Vec4 vec45;
                Vec4 vec46 = this.getVec(shapeData, j, i);
                if (j == 0 && i == 0) {
                    vec45 = this.getVec(shapeData, j, i + 1).subtract3(vec46);
                    vec44 = this.getVec(shapeData, j + 1, i).subtract3(vec46);
                    this.putVec(j, i, vec45.cross3(vec44).normalize3(), shapeData.normals);
                    continue;
                }
                if (j == this.nPhiIntervals && i == 0) {
                    vec45 = this.getVec(shapeData, j - 1, i).subtract3(vec46);
                    vec44 = this.getVec(shapeData, j, i + 1).subtract3(vec46);
                    this.putVec(j, i, vec45.cross3(vec44).normalize3(), shapeData.normals);
                    continue;
                }
                if (j == 0 && i == this.nThetaIntervals) {
                    vec45 = this.getVec(shapeData, j + 1, i).subtract3(vec46);
                    vec44 = this.getVec(shapeData, j, i - 1).subtract3(vec46);
                    this.putVec(j, i, vec45.cross3(vec44).normalize3(), shapeData.normals);
                    continue;
                }
                if (j == this.nPhiIntervals && i == this.nThetaIntervals) {
                    vec45 = this.getVec(shapeData, j, i - 1).subtract3(vec46);
                    vec44 = this.getVec(shapeData, j - 1, i).subtract3(vec46);
                    this.putVec(j, i, vec45.cross3(vec44).normalize3(), shapeData.normals);
                    continue;
                }
                if (j == 0) {
                    vec45 = this.getVec(shapeData, j, i - 1).subtract3(vec46);
                    vec44 = this.getVec(shapeData, j + 1, i).subtract3(vec46);
                    vec43 = this.getVec(shapeData, j, i - 1).subtract3(vec46);
                    vec42 = vec45.cross3(vec44).multiply3(0.5);
                    vec4 = vec44.cross3(vec43).multiply3(0.5);
                    this.putVec(j, i, vec42.add3(vec4).normalize3(), shapeData.normals);
                    continue;
                }
                if (j == this.nPhiIntervals) {
                    vec45 = this.getVec(shapeData, j, i - 1).subtract3(vec46);
                    vec44 = this.getVec(shapeData, j - 1, i).subtract3(vec46);
                    vec43 = this.getVec(shapeData, j, i + 1).subtract3(vec46);
                    vec42 = vec45.cross3(vec44).multiply3(0.5);
                    vec4 = vec44.cross3(vec43).multiply3(0.5);
                    this.putVec(j, i, vec42.add3(vec4).normalize3(), shapeData.normals);
                    continue;
                }
                if (i == 0) {
                    vec45 = this.getVec(shapeData, j - 1, i).subtract3(vec46);
                    vec44 = this.getVec(shapeData, j, i + 1).subtract3(vec46);
                    vec43 = this.getVec(shapeData, j + 1, i).subtract3(vec46);
                    vec42 = vec45.cross3(vec44).multiply3(0.5);
                    vec4 = vec44.cross3(vec43).multiply3(0.5);
                    this.putVec(j, i, vec42.add3(vec4).normalize3(), shapeData.normals);
                    continue;
                }
                if (i == this.nThetaIntervals) {
                    vec45 = this.getVec(shapeData, j + 1, i).subtract3(vec46);
                    vec44 = this.getVec(shapeData, j, i - 1).subtract3(vec46);
                    vec43 = this.getVec(shapeData, j - 1, i).subtract3(vec46);
                    vec42 = vec45.cross3(vec44).multiply3(0.5);
                    vec4 = vec44.cross3(vec43).multiply3(0.5);
                    this.putVec(j, i, vec42.add3(vec4).normalize3(), shapeData.normals);
                    continue;
                }
                vec45 = this.getVec(shapeData, j, i - 1).subtract3(vec46);
                vec44 = this.getVec(shapeData, j - 1, i).subtract3(vec46);
                vec43 = this.getVec(shapeData, j, i + 1).subtract3(vec46);
                Vec4 vec47 = this.getVec(shapeData, j + 1, i).subtract3(vec46);
                vec42 = vec45.cross3(vec44).multiply3(0.25);
                vec4 = vec44.cross3(vec43).multiply3(0.25);
                Vec4 vec48 = vec43.cross3(vec47).multiply3(0.25);
                Vec4 vec49 = vec47.cross3(vec45).multiply3(0.25);
                this.putVec(j, i, vec42.add3(vec4).add3(vec48).add3(vec49).normalize3(), shapeData.normals);
            }
        }
    }

    protected Vec4 getVec(ShapeData shapeData, int n, int n2) {
        int n3 = 3 * (n2 * this.nPhiIntervals + n);
        float f = shapeData.vertices.get(n3);
        float f2 = shapeData.vertices.get(n3 + 1);
        float f3 = shapeData.vertices.get(n3 + 2);
        return new Vec4(f, f2, f3);
    }

    protected void putVec(int n, int n2, Vec4 vec4, FloatBuffer floatBuffer) {
        int n3 = 3 * (n2 * this.nPhiIntervals + n);
        floatBuffer.put(n3, (float)vec4.getX());
        floatBuffer.put(n3 + 1, (float)vec4.getY());
        floatBuffer.put(n3 + 2, (float)vec4.getZ());
    }

    @Override
    protected void fillVBO(DrawContext drawContext) {
    }

    @Override
    public void moveTo(Position position) {
    }

    @Override
    public List<Intersection> intersect(Line line, Terrain terrain) throws InterruptedException {
        return null;
    }

    @Override
    public String isExportFormatSupported(String string) {
        return "Export.FormatNotSupported";
    }

    @Override
    protected void doExportAsKML(XMLStreamWriter xMLStreamWriter) throws IOException, XMLStreamException {
        throw new UnsupportedOperationException("KML output not supported for AntennaModel");
    }

    protected static class ShapeData
    extends AbstractShape.AbstractShapeData {
        protected FloatBuffer vertices;
        protected FloatBuffer texCoords;
        protected IntBuffer[] indices;
        protected FloatBuffer normals;

        public ShapeData(DrawContext drawContext, AntennaModel antennaModel) {
            super(drawContext, antennaModel.minExpiryTime, antennaModel.maxExpiryTime);
        }
    }
}

