/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications;

import gov.nasa.worldwind.BasicFactory;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.event.BulkRetrievalEvent;
import gov.nasa.worldwind.event.BulkRetrievalListener;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.retrieve.BulkRetrievable;
import gov.nasa.worldwind.retrieve.BulkRetrievalThread;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import java.util.ArrayList;

public class BulkDownloadAlaska {
    public static void main(String[] stringArray) {
        try {
            ArrayList<Sector> arrayList = new ArrayList<Sector>(3);
            arrayList.add(Sector.fromDegrees(59.0, 71.4, -168.2, -141.0));
            arrayList.add(Sector.fromDegrees(51.0, 59.0, -180.0, -151.7));
            arrayList.add(Sector.fromDegrees(54.6, 60.5, -141.0, -130.0));
            AVListImpl aVListImpl = new AVListImpl();
            for (Sector sector : arrayList) {
                BulkRetrievable bulkRetrievable = (BulkRetrievable)BasicFactory.create("gov.nasa.worldwind.avkey.LayerFactory", "config/Earth/BMNG256.xml");
                System.out.println(bulkRetrievable.getName());
                BulkRetrievalThread bulkRetrievalThread = bulkRetrievable.makeLocal(sector, 0.0, new BulkRetrievalListener(){

                    @Override
                    public void eventOccurred(BulkRetrievalEvent bulkRetrievalEvent) {
                        System.out.println(bulkRetrievalEvent.getItem());
                    }
                });
                bulkRetrievalThread.join();
                aVListImpl.setValue("gov.nasa.worldwind.avkey.NumLevels", 9);
                bulkRetrievable = (BulkRetrievable)BasicFactory.create("gov.nasa.worldwind.avkey.LayerFactory", "config/Earth/Landsat256.xml");
                System.out.println(bulkRetrievable.getName());
                bulkRetrievalThread = bulkRetrievable.makeLocal(sector, 0.0, new BulkRetrievalListener(){

                    @Override
                    public void eventOccurred(BulkRetrievalEvent bulkRetrievalEvent) {
                        System.out.println(bulkRetrievalEvent.getItem());
                    }
                });
                bulkRetrievalThread.join();
                aVListImpl.setValue("gov.nasa.worldwind.avkey.NumLevels", 8);
                bulkRetrievable = (BulkRetrievable)BasicFactory.create("gov.nasa.worldwind.avkey.LayerFactory", "config/Earth/AlaskaFAASectionals.xml", aVListImpl);
                System.out.println(bulkRetrievable.getName());
                bulkRetrievalThread = bulkRetrievable.makeLocal(sector, 0.0, new BulkRetrievalListener(){

                    @Override
                    public void eventOccurred(BulkRetrievalEvent bulkRetrievalEvent) {
                        System.out.println(bulkRetrievalEvent.getItem());
                    }
                });
                bulkRetrievalThread.join();
                aVListImpl.setValue("gov.nasa.worldwind.avkey.NumLevels", 9);
                CompoundElevationModel compoundElevationModel = (CompoundElevationModel)BasicFactory.create("gov.nasa.worldwind.avkey.ElevationModelFactory", "config/Earth/EarthElevations256.xml");
                bulkRetrievable = (BulkRetrievable)((Object)compoundElevationModel.getElevationModels().get(0));
                System.out.println(bulkRetrievable.getName());
                bulkRetrievalThread = bulkRetrievable.makeLocal(sector, 0.0, new BulkRetrievalListener(){

                    @Override
                    public void eventOccurred(BulkRetrievalEvent bulkRetrievalEvent) {
                        System.out.println(bulkRetrievalEvent.getItem());
                    }
                });
                bulkRetrievalThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

