/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind.handler;

import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.SurfacePolylines;
import jams.worldwind.handler.MaterialClassCellEditor;
import jams.worldwind.ui.model.ShapefilePropertiesModel;
import jams.worldwind.ui.renderer.MaterialClassCellRenderer;
import jams.worldwind.ui.view.GlobeView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class SurfacePolylineClassCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private final String buttonText = "...";
    private final JButton theButton = new JButton(this.buttonText);
    private JOptionPane propertiesDialog;
    private SurfacePolylines polylines;

    public SurfacePolylineClassCellEditor() {
        this.theButton.addActionListener(this);
        this.theButton.setBorderPainted(true);
    }

    @Override
    public Object getCellEditorValue() {
        return this.polylines;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof SurfacePolylines) {
            this.polylines = (SurfacePolylines)value;
        }
        return this.theButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFrame propertiesFrame = new JFrame("OBJECT PROPERTIES");
        JTable propertiesTable = new JTable();
        propertiesTable.setIntercellSpacing(new Dimension(6, 6));
        propertiesTable.setRowHeight(propertiesTable.getRowHeight() + 6);
        JScrollPane scrollPane = new JScrollPane(propertiesTable);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout());
        mainPanel.add(scrollPane);
        propertiesFrame.getContentPane().add(mainPanel);
        propertiesFrame.setSize(propertiesFrame.getPreferredSize());
        propertiesTable.setModel(new ShapefilePropertiesModel(this.polylines));
        propertiesTable.setDefaultEditor(Material.class, new MaterialClassCellEditor());
        propertiesTable.setDefaultRenderer(Material.class, new MaterialClassCellRenderer(true));
        propertiesTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                GlobeView.getInstance().getWorldWindow().redrawNow();
            }
        });
        TableCellRenderer rendererFromHeader = propertiesTable.getTableHeader().getDefaultRenderer();
        JLabel headerLabel = (JLabel)((Object)rendererFromHeader);
        headerLabel.setHorizontalAlignment(0);
        this.autoResizeColWidth(propertiesTable, (DefaultTableModel)propertiesTable.getModel());
        propertiesFrame.setDefaultCloseOperation(1);
        propertiesFrame.setVisible(true);
        this.fireEditingStopped();
    }

    public JTable autoResizeColWidth(JTable table, DefaultTableModel model) {
        table.setAutoResizeMode(0);
        int margin = 5;
        for (int i = 0; i < table.getColumnCount(); ++i) {
            int vColIndex = i;
            DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
            TableColumn col = colModel.getColumn(vColIndex);
            int width = 0;
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = table.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
            width = comp.getPreferredSize().width;
            for (int r = 0; r < table.getRowCount(); ++r) {
                renderer = table.getCellRenderer(r, vColIndex);
                comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, vColIndex), false, false, r, vColIndex);
                Object o = table.getValueAt(r, vColIndex);
                if (o instanceof Material) continue;
                width = Math.max(width, comp.getPreferredSize().width);
            }
            col.setPreferredWidth(width += 2 * margin);
        }
        ((DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
        table.getTableHeader().setReorderingAllowed(false);
        return table;
    }
}

