/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.math.interpolation.splines;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.List;
import org.jgrasstools.gears.utils.math.interpolation.splines.ControlCurve;

public class Bspline
extends ControlCurve {
    final int STEPS = 12;

    double b(int i, double t) {
        switch (i) {
            case -2: {
                return (((-t + 3.0) * t - 3.0) * t + 1.0) / 6.0;
            }
            case -1: {
                return ((3.0 * t - 6.0) * t * t + 4.0) / 6.0;
            }
            case 0: {
                return (((-3.0 * t + 3.0) * t + 3.0) * t + 1.0) / 6.0;
            }
            case 1: {
                return t * t * t / 6.0;
            }
        }
        return 0.0;
    }

    private Coordinate p(int i, double t) {
        double px = 0.0;
        double py = 0.0;
        for (int j = -2; j <= 1; ++j) {
            Coordinate coordinate = (Coordinate)this.pts.get(i + j);
            px += this.b(j, t) * coordinate.x;
            py += this.b(j, t) * coordinate.y;
        }
        return new Coordinate(px, py);
    }

    @Override
    public List<Coordinate> getInterpolated() {
        ArrayList<Coordinate> interpolatedCoordinates = new ArrayList<Coordinate>();
        Coordinate q = this.p(2, 0.0);
        interpolatedCoordinates.add(q);
        for (int i = 2; i < this.pts.size() - 1; ++i) {
            for (int j = 1; j <= 12; ++j) {
                q = this.p(i, (double)j / 12.0);
                interpolatedCoordinates.add(q);
            }
        }
        return interpolatedCoordinates;
    }
}

