/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils;

public class DynamicDoubleArray {
    private double[] internalArray = null;
    private final int growingSize;
    private int lastIndex = 0;

    public DynamicDoubleArray(int initalSize) {
        this(initalSize, 50);
    }

    public DynamicDoubleArray(int initalSize, int growingSize) {
        this.growingSize = growingSize;
        this.internalArray = new double[initalSize];
    }

    public void setValue(int position, double value) {
        if (position >= this.internalArray.length) {
            double[] newArray = new double[position + this.growingSize];
            System.arraycopy(this.internalArray, 0, newArray, 0, this.internalArray.length);
            this.internalArray = newArray;
        }
        this.internalArray[position] = value;
        this.lastIndex = Math.max(this.lastIndex, position);
    }

    public void addValue(double value) {
        int position = this.lastIndex + 1;
        this.setValue(position, value);
    }

    public double getValue(int position) {
        return this.internalArray[position];
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public double[] getInternalArray() {
        return this.internalArray;
    }

    public double[] getTrimmedInternalArray() {
        if (this.internalArray.length == this.lastIndex + 1) {
            return this.internalArray;
        }
        double[] newArray = new double[this.lastIndex + 1];
        System.arraycopy(this.internalArray, 0, newArray, 0, newArray.length);
        return newArray;
    }
}

