/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.rastercattofeatureattribute;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.image.RenderedImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.modules.r.scanline.OmsScanLineRasterizer;
import org.jgrasstools.gears.modules.r.summary.OmsRasterSummary;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.jgrasstools.gears.utils.features.FeatureExtender;
import org.jgrasstools.gears.utils.features.FeatureUtilities;
import org.jgrasstools.gears.utils.geometry.GeometryType;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

@Description(value="Module that extracts raster categories and adds them to a feature collection.")
@Documentation(value="OmsRasterCatToFeatureAttribute.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector")
@Label(value="Vector Processing")
@Name(value="rat2featureattr")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsRasterCatToFeatureAttribute
extends JGTModel {
    @Description(value="The raster on which to map the vector features.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The vector to use for the geometric mapping.")
    @In
    public SimpleFeatureCollection inVector = null;
    @Description(value="The name for the new field to create.")
    @In
    public String fNew = "new";
    @Description(value="The position of the coordinate to take in the case of multi geometries.")
    @In
    public String pPos = "middle";
    @Description(value="The extended vector.")
    @Out
    public SimpleFeatureCollection outVector = null;
    private static final String MIDDLE = "middle";
    private static final String START = "start";
    private static final String END = "end";
    private RandomIter inIter = null;
    private GridGeometry2D gridGeometry;
    private CoordinateReferenceSystem crs;
    private RegionMap regionMap;

    @Execute
    public void process() throws Exception {
        if (this.inIter == null) {
            RenderedImage inputRI = this.inRaster.getRenderedImage();
            this.inIter = RandomIterFactory.create((RenderedImage)inputRI, null);
            this.regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
            this.gridGeometry = this.inRaster.getGridGeometry();
        }
        SimpleFeatureType featureType = (SimpleFeatureType)this.inVector.getSchema();
        this.crs = ((SimpleFeatureType)this.inVector.getSchema()).getCoordinateReferenceSystem();
        FeatureExtender fExt = null;
        Envelope2D inCoverageEnvelope = this.inRaster.getEnvelope2D();
        this.outVector = new DefaultFeatureCollection();
        SimpleFeatureIterator featureIterator = this.inVector.features();
        int all = this.inVector.size();
        this.pm.beginTask("Extracting raster information...", all);
        while (featureIterator.hasNext()) {
            SimpleFeature extendedFeature;
            Coordinate c;
            SimpleFeature feature = (SimpleFeature)featureIterator.next();
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            double value = -1.0;
            Coordinate[] coordinates = geometry.getCoordinates();
            if (GeometryUtilities.getGeometryType(geometry) == GeometryType.POINT || GeometryUtilities.getGeometryType(geometry) == GeometryType.MULTIPOINT) {
                c = coordinates[0];
                if (!inCoverageEnvelope.contains(c.x, c.y)) continue;
                value = this.getRasterValue(c);
                if (fExt == null) {
                    fExt = new FeatureExtender(featureType, new String[]{this.fNew}, new Class[]{Double.class});
                }
                extendedFeature = fExt.extendFeature(feature, new Object[]{value});
                ((DefaultFeatureCollection)this.outVector).add(extendedFeature);
            } else if (GeometryUtilities.getGeometryType(geometry) == GeometryType.LINE || GeometryUtilities.getGeometryType(geometry) == GeometryType.MULTILINE) {
                c = this.pPos.trim().equalsIgnoreCase(START) ? coordinates[0] : (this.pPos.trim().equalsIgnoreCase(END) ? coordinates[coordinates.length - 1] : coordinates[coordinates.length / 2]);
                if (!inCoverageEnvelope.contains(c.x, c.y)) continue;
                value = this.getRasterValue(c);
                if (fExt == null) {
                    fExt = new FeatureExtender(featureType, new String[]{this.fNew}, new Class[]{Double.class});
                }
                extendedFeature = fExt.extendFeature(feature, new Object[]{value});
                ((DefaultFeatureCollection)this.outVector).add(extendedFeature);
            } else if (GeometryUtilities.getGeometryType(geometry) == GeometryType.POLYGON || GeometryUtilities.getGeometryType(geometry) == GeometryType.MULTIPOLYGON) {
                if (fExt == null) {
                    String max = this.fNew + "_max";
                    String min = this.fNew + "_min";
                    String sum = this.fNew + "_sum";
                    String avg = this.fNew + "_avg";
                    fExt = new FeatureExtender(featureType, new String[]{min, max, sum, avg}, new Class[]{Double.class, Double.class, Double.class, Double.class});
                }
                SimpleFeature singleFeature = FeatureUtilities.toDummyFeature(geometry, this.crs);
                DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
                newCollection.add(singleFeature);
                OmsScanLineRasterizer raster = new OmsScanLineRasterizer();
                raster.inVector = newCollection;
                raster.inRaster = this.inRaster;
                raster.pValue = 1.0;
                raster.process();
                GridCoverage2D rasterizedVector = raster.outRaster;
                double[] minMaxAvgSum = OmsRasterSummary.getMinMaxAvgSum(rasterizedVector);
                SimpleFeature extendedFeature2 = fExt.extendFeature(feature, new Object[]{minMaxAvgSum[0], minMaxAvgSum[1], minMaxAvgSum[2], minMaxAvgSum[3]});
                ((DefaultFeatureCollection)this.outVector).add(extendedFeature2);
            } else {
                throw new ModelsIllegalargumentException("The Geometry type is not supported.", this, this.pm);
            }
            this.pm.worked(1);
        }
        featureIterator.close();
        this.pm.done();
    }

    private double getRasterValue(Coordinate c) throws TransformException {
        GridCoordinates2D gridCoord = this.gridGeometry.worldToGrid((DirectPosition)new DirectPosition2D(c.x, c.y));
        double value = this.inIter.getSampleDouble(gridCoord.x, gridCoord.y, 0);
        if (JGTConstants.isNovalue(value) || value >= 3.4028234663852886E38 || value <= -3.4028234663852886E38) {
            value = -9999.0;
        }
        return value;
    }
}

