/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.houghes;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.util.ArrayList;
import java.util.List;
import javax.media.jai.iterator.RandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.Unit;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.jgrasstools.gears.io.rasterreader.OmsRasterReader;
import org.jgrasstools.gears.io.vectorreader.OmsVectorReader;
import org.jgrasstools.gears.io.vectorwriter.OmsVectorWriter;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.modules.ThreadedRunnable;
import org.jgrasstools.gears.modules.r.houghes.OmsHoughCirclesRaster;
import org.jgrasstools.gears.modules.r.summary.OmsZonalStats;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.jgrasstools.gears.utils.features.FeatureUtilities;
import org.opengis.feature.simple.SimpleFeature;

@Description(value="Module to remove circles after the HoughCirclesRaster module.")
@Author(name="Andrea Antonello (www.hydrologis.com)", contact="")
@Keywords(value="Hough, circle, cleaner")
@Label(value="Raster Processing")
@Name(value="houghcirclesrastercleaner")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsHoughCirclesRasterCleaner
extends JGTModel {
    @Description(value="The input circles vector.")
    @In
    public SimpleFeatureCollection inVector;
    @Description(value="The raster from which the circles where generated.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The maximum permitted overlap count.")
    @In
    public int pMaxOverlapCount = 3;
    @Description(value="The maximum permitted overlap.")
    @Unit(value="%")
    @In
    public Double pMaxOverlap;
    @Description(value="The leftover circles.")
    @In
    public SimpleFeatureCollection outCircles;
    public static final String NAME = "houghcirclesrastercleaner";
    public static final String KEYWORDS = "Hough, circle, cleaner";
    public static final String AUTHORS = "Andrea Antonello (www.hydrologis.com)";
    public static final String DESCRIPTIO = "Module to remove circles after the HoughCirclesRaster module.";
    public static final String inVector_DESCR = "The input circles vector.";
    public static final String inRaster_DESCR = "The raster from which the circles where generated.";
    public static final String pMaxOverlap_DESCR = "The maximum permitted overlap.";
    public static final String pMaxOverlapCount_DESCR = "The maximum permitted overlap count.";
    public static final String outCircles_DESCR = "The leftover circles.";

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inVector, this.pMaxOverlap, this.inRaster);
        RandomIter rasterIter = CoverageUtilities.getRandomIterator(this.inRaster);
        GridGeometry2D gridGeometry = this.inRaster.getGridGeometry();
        double[] tm_utm_tac = new double[3];
        STRtree circlesTree = FeatureUtilities.featureCollectionToSTRtree(this.inVector);
        List<SimpleFeature> circlesList = FeatureUtilities.featureCollectionToList(this.inVector);
        DefaultFeatureCollection outFC = new DefaultFeatureCollection();
        for (SimpleFeature circleFeature : circlesList) {
            double novalues;
            double[] stats;
            double activeCells;
            double value;
            Geometry geometry = (Geometry)circleFeature.getDefaultGeometry();
            Polygon circle = (Polygon)geometry.getGeometryN(0);
            PreparedGeometry preparedCircle = PreparedGeometryFactory.prepare((Geometry)circle);
            List circlesAround = circlesTree.query(circle.getEnvelopeInternal());
            ArrayList<Geometry> intersectedCircles = new ArrayList<Geometry>();
            for (SimpleFeature circleAround : circlesAround) {
                Geometry circleAroundGeometry;
                if (circleAround.equals(circleFeature) || !preparedCircle.intersects(circleAroundGeometry = (Geometry)circleAround.getDefaultGeometry())) continue;
                intersectedCircles.add(circleAroundGeometry);
            }
            Point centroid = circle.getCentroid();
            int intersectionsCount = intersectedCircles.size();
            if (intersectionsCount != 0) {
                if (intersectionsCount > this.pMaxOverlapCount) continue;
                boolean intersected = false;
                for (Geometry intersectedCircle : intersectedCircles) {
                    if (!intersectedCircle.intersects((Geometry)centroid)) continue;
                    intersected = true;
                    break;
                }
                if (intersected) continue;
            }
            if (!JGTConstants.isNovalue(value = CoverageUtilities.getValue(this.inRaster, centroid.getCoordinate())) || (activeCells = (stats = OmsZonalStats.polygonStats((Geometry)circle, gridGeometry, rasterIter, false, tm_utm_tac, 0.0, this.pm))[5]) * 1.5 > (novalues = stats[6])) continue;
            outFC.add(circleFeature);
        }
        this.outCircles = outFC;
        rasterIter.done();
    }

    public static void main(String[] args) throws Exception {
        int[] i;
        ThreadedRunnable runner = new ThreadedRunnable(8, null);
        int[] nArray = i = new int[]{2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30};
        int n = nArray.length;
        for (int j = 0; j < n; ++j) {
            int index;
            final int _index = index = nArray[j];
            runner.executeRunnable(new Runnable(){

                @Override
                public void run() {
                    try {
                        String inRaster = "/home/hydrologis/data/rilievo_tls/avgres/las/vertical_slices/slice_" + _index + ".0.asc";
                        String inShp = "/home/hydrologis/data/rilievo_tls/avgres/las/vertical_slices/slice_vector_" + _index + ".0.shp";
                        String outShp = "/home/hydrologis/data/rilievo_tls/avgres/las/vertical_slices/slice_vector_cleaned_" + _index + ".0.shp";
                        GridCoverage2D src = OmsRasterReader.readRaster(inRaster);
                        OmsHoughCirclesRaster h = new OmsHoughCirclesRaster();
                        h.inRaster = src;
                        h.pMinRadius = 0.1;
                        h.pMaxRadius = 0.5;
                        h.pRadiusIncrement = 0.01;
                        h.pMaxCircleCount = 500;
                        h.process();
                        OmsVectorWriter.writeVector(inShp, h.outCircles);
                        SimpleFeatureCollection inVector = OmsVectorReader.readVector(inShp);
                        OmsHoughCirclesRasterCleaner hCleaner = new OmsHoughCirclesRasterCleaner();
                        hCleaner.inRaster = src;
                        hCleaner.inVector = inVector;
                        hCleaner.pMaxOverlap = 0.1;
                        hCleaner.pMaxOverlapCount = 5;
                        hCleaner.process();
                        OmsVectorWriter.writeVector(outShp, hCleaner.outCircles);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        runner.waitAndClose();
    }
}

