/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.rasterwriter;

import java.io.File;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.arcgrid.ArcGridFormat;
import org.geotools.gce.arcgrid.ArcGridWriteParams;
import org.geotools.gce.arcgrid.ArcGridWriter;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.gce.grassraster.GrassCoverageWriter;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.gce.grassraster.format.GrassCoverageFormat;
import org.geotools.gce.grassraster.format.GrassCoverageFormatFactory;
import org.jgrasstools.gears.io.grasslegacy.GrassLegacyGridCoverage2D;
import org.jgrasstools.gears.io.grasslegacy.OmsGrassLegacyWriter;
import org.jgrasstools.gears.io.grasslegacy.utils.GrassLegacyUtilities;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;

@Description(value="Raster writer module.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Grass, Coverage, Raster, Writing")
@Label(value="Raster Writer")
@Name(value="rasterwriter")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsRasterWriter
extends JGTModel {
    @Description(value="The raster map to write.")
    @In
    public GridCoverage2D inRaster = null;
    @Description(value="The file to write the raster to with extension (supported are: asc, tiff, grass).")
    @UI(value="outfile")
    @In
    public String file = null;

    @Execute
    public void process() throws Exception {
        block13: {
            this.checkNull(this.inRaster);
            if (this.inRaster.getName().toString().equals("dummy")) {
                this.pm.message("WARNING: Not writing dummy raster to file.");
                return;
            }
            String pType = null;
            if (this.file.toLowerCase().endsWith("asc")) {
                pType = "asc";
            } else if (this.file.toLowerCase().endsWith("tiff") || this.file.toLowerCase().endsWith("tif")) {
                pType = "tiff";
            } else if (CoverageUtilities.isGrass(this.file)) {
                pType = "grass";
            } else {
                throw new ModelsIllegalargumentException("Can't recognize the data format. Supported are: asc, tiff, grass.", this.getClass().getSimpleName(), this.pm);
            }
            File mapFile = new File(this.file);
            try {
                this.pm.beginTask("Writing coverage: " + mapFile.getName(), -1);
                if (pType.equals("asc")) {
                    this.writeArcGrid(mapFile);
                    break block13;
                }
                if (pType.equals("tiff")) {
                    this.writeGeotiff(mapFile);
                    break block13;
                }
                if (pType.equals("grass")) {
                    this.writeGrass(mapFile);
                    break block13;
                }
                throw new ModelsIllegalargumentException("Data type not supported: " + pType, this.getClass().getSimpleName(), this.pm);
            }
            finally {
                this.pm.done();
            }
        }
    }

    private void writeArcGrid(File mapFile) throws Exception {
        ArcGridFormat format = new ArcGridFormat();
        ArcGridWriteParams wp = new ArcGridWriteParams();
        ParameterValueGroup paramWrite = format.getWriteParameters();
        paramWrite.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)wp);
        ArcGridWriter gtw = (ArcGridWriter)format.getWriter((Object)new File(this.file));
        gtw.write((GridCoverage)this.inRaster, paramWrite.values().toArray(new GeneralParameterValue[1]));
        gtw.dispose();
    }

    private void writeGeotiff(File mapFile) throws Exception {
        GeoTiffFormat format = new GeoTiffFormat();
        GeoTiffWriteParams wp = new GeoTiffWriteParams();
        wp.setCompressionMode(1);
        wp.setTilingMode(1);
        ParameterValueGroup paramWrite = format.getWriteParameters();
        paramWrite.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)wp);
        GeoTiffWriter gtw = (GeoTiffWriter)format.getWriter((Object)mapFile);
        gtw.write((GridCoverage)this.inRaster, paramWrite.values().toArray(new GeneralParameterValue[1]));
    }

    private void writeGrass(File mapFile) throws Exception {
        File cellFile = mapFile;
        JGrassMapEnvironment mapEnvironment = new JGrassMapEnvironment(cellFile);
        GeneralParameterValue[] readParams = null;
        JGrassRegion jGrassRegion = null;
        boolean doLarge = false;
        if (this.inRaster instanceof GrassLegacyGridCoverage2D) {
            doLarge = true;
        }
        if (!doLarge) {
            GrassCoverageFormat format = new GrassCoverageFormatFactory().createFormat();
            GrassCoverageWriter writer = format.getWriter((Object)mapEnvironment.getCELL(), null);
            writer.write((GridCoverage)this.inRaster, readParams);
            writer.dispose();
        } else {
            GrassLegacyGridCoverage2D gd2 = (GrassLegacyGridCoverage2D)this.inRaster;
            OmsGrassLegacyWriter writer = new OmsGrassLegacyWriter();
            writer.geodata = gd2.getData();
            writer.file = this.file;
            if (jGrassRegion == null) {
                jGrassRegion = mapEnvironment.getActiveRegion();
            }
            writer.inWindow = GrassLegacyUtilities.jgrassRegion2legacyWindow(jGrassRegion);
            writer.writeRaster();
        }
    }

    public static void writeRaster(String path, GridCoverage2D coverage) throws Exception {
        OmsRasterWriter writer = new OmsRasterWriter();
        writer.inRaster = coverage;
        writer.file = path;
        writer.process();
    }
}

