/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.las.utils;

import java.util.Comparator;
import org.jgrasstools.gears.io.las.core.LasRecord;
import org.jgrasstools.gears.io.las.utils.LasUtils;

public class LasRecordDistanceComparator
implements Comparator<LasRecord> {
    private boolean doReverse;
    private LasRecord center;

    public LasRecordDistanceComparator(LasRecord center) {
        this(center, false);
    }

    public LasRecordDistanceComparator(LasRecord center, boolean doReverse) {
        this.center = center;
        this.doReverse = doReverse;
    }

    @Override
    public int compare(LasRecord o1, LasRecord o2) {
        double d1 = LasUtils.distance(this.center, o1);
        double d2 = LasUtils.distance(this.center, o2);
        if (this.doReverse) {
            if (d1 < d2) {
                return 1;
            }
            if (d1 > d2) {
                return -1;
            }
            return 0;
        }
        if (d1 < d2) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        return 0;
    }
}

