/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.las.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.jgrasstools.gears.io.las.core.ALasReader;
import org.jgrasstools.gears.io.las.core.ALasWriter;
import org.jgrasstools.gears.io.las.core.liblas.LiblasJNALibrary;
import org.jgrasstools.gears.io.las.core.liblas.LiblasReader;
import org.jgrasstools.gears.io.las.core.liblas.LiblasWrapper;
import org.jgrasstools.gears.io.las.core.liblas.LiblasWriter;
import org.jgrasstools.gears.io.las.core.v_1_0.LasReader;
import org.jgrasstools.gears.io.las.core.v_1_0.LasWriter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class Las {
    private static volatile boolean testedLibLoading = false;
    private static volatile boolean isNativeLibAvailable;

    public static boolean supportsNative() {
        if (!testedLibLoading) {
            LiblasJNALibrary wrapper = LiblasWrapper.getWrapper();
            if (wrapper != null) {
                isNativeLibAvailable = true;
            }
            testedLibLoading = true;
        }
        return isNativeLibAvailable;
    }

    public static String[] getLibraryPaths() {
        String path = System.getProperty("java.library.path");
        String[] split = path.trim().split(File.pathSeparator);
        ArrayList<String> pathList = new ArrayList<String>();
        for (String pathItem : split) {
            if ((pathItem = pathItem.trim()).length() == 0 || pathList.contains(pathItem)) continue;
            pathList.add(pathItem);
        }
        Collections.sort(pathList);
        return pathList.toArray(new String[0]);
    }

    public static ALasReader getReader(File lasFile, CoordinateReferenceSystem crs) throws Exception {
        if (Las.supportsNative()) {
            return new LiblasReader(lasFile, crs);
        }
        return new LasReader(lasFile, crs);
    }

    public static ALasWriter getWriter(File lasFile, CoordinateReferenceSystem crs) throws Exception {
        if (Las.supportsNative()) {
            return new LiblasWriter(lasFile, crs);
        }
        return new LasWriter(lasFile, crs);
    }
}

