/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.gridgeometryreader;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.referencing.CRS;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.modules.JGTProcessingRegion;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="GridGeometry reader module.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, GridGeometry, Raster, Reading")
@Label(value="Grid Geometry Reader")
@Name(value="gridgeomreader")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsGridGeometryReader
extends JGTModel {
    @Description(value="The boundary north coordinate.")
    @UI(value="process_north")
    @In
    public Double pNorth = null;
    @Description(value="The boundary south coordinate.")
    @UI(value="process_south")
    @In
    public Double pSouth = null;
    @Description(value="The boundary west coordinate.")
    @UI(value="process_west")
    @In
    public Double pWest = null;
    @Description(value="The boundary east coordinate.")
    @UI(value="process_east")
    @In
    public Double pEast = null;
    @Description(value="The resolution in x.")
    @UI(value="process_xres")
    @In
    public Double pXres = null;
    @Description(value="The resolution in y.")
    @UI(value="process_yres")
    @In
    public Double pYres = null;
    @Description(value="The code defining the coordinate reference system, composed by authority and code number (ex. EPSG:4328).")
    @UI(value="crs")
    @In
    public String pCode;
    @Description(value="The output GridGeometry.")
    @Out
    public GridGeometry2D outGridgeom = null;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.pNorth, this.pSouth, this.pWest, this.pEast, this.pXres, this.pYres, this.pCode);
        JGTProcessingRegion region = new JGTProcessingRegion((double)this.pWest, (double)this.pEast, (double)this.pSouth, (double)this.pNorth, this.pXres, this.pYres);
        CoordinateReferenceSystem crs = CRS.decode((String)this.pCode);
        this.outGridgeom = CoverageUtilities.gridGeometryFromRegionValues(this.pNorth, this.pSouth, this.pEast, this.pWest, region.getCols(), region.getRows(), crs);
    }
}

