/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.grasslegacy.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.util.Date;
import org.jgrasstools.gears.io.grasslegacy.io.CompressesRasterWriter;
import org.jgrasstools.gears.io.grasslegacy.io.MapWriter;
import org.jgrasstools.gears.io.grasslegacy.utils.FileUtilities;
import org.jgrasstools.gears.io.grasslegacy.utils.Window;

public class GrassRasterWriter
extends MapWriter {
    private String name = null;
    private String mapsetPath = null;
    private String locationPath = null;
    private String fcellFilePath = null;
    private long[] rowaddresses;
    private long pointerInFilePosition;
    private double[] range = new double[2];
    private static final String ERROR_IN_WRITING_RASTER = "Error in writing raster: ";
    private int outputToDiskType = 2;

    public GrassRasterWriter() {
        super(1);
    }

    @Override
    public boolean open(String fileName, String locationPath, String mapsetName) {
        if (this.dataWindow != null) {
            this.name = fileName;
            this.locationPath = locationPath;
            this.mapsetPath = locationPath + File.separator + mapsetName;
            this.fcellFilePath = this.mapsetPath + File.separator + "fcell" + File.separator + this.name;
            if (!this.checkStructure()) {
                return false;
            }
            return this.createEmptyHeader(this.fcellFilePath, this.dataWindow.getRows());
        }
        return false;
    }

    @Override
    public boolean write(Object dataObject) throws Exception {
        File ds1 = new File(this.fcellFilePath);
        RandomAccessFile theCreatedFile = new RandomAccessFile(ds1, "rw");
        File ds2 = new File(this.mapsetPath + File.separator + "cell_misc" + File.separator + this.name + File.separator + "null");
        RandomAccessFile theCreatedNullFile = new RandomAccessFile(ds2, "rw");
        CompressesRasterWriter crwriter = new CompressesRasterWriter(this.outputToDiskType, this.range, this.pointerInFilePosition, this.rowaddresses, this.dataWindow);
        crwriter.compressAndWriteObj(theCreatedFile, theCreatedNullFile, dataObject);
        this.outputToDiskType = crwriter.getOutputToDiskType();
        this.range = crwriter.getRange();
        this.pointerInFilePosition = crwriter.getPointerInFilePosition();
        this.rowaddresses = crwriter.getRowaddresses();
        this.dataWindow = crwriter.getDataWindow();
        theCreatedFile.close();
        theCreatedNullFile.close();
        this.createUtilityFiles();
        return true;
    }

    private boolean checkStructure() {
        File ds = new File(this.mapsetPath + File.separator + "cats" + File.separator);
        if (!ds.exists() && !ds.mkdir()) {
            return false;
        }
        ds = new File(this.mapsetPath + File.separator + "cell" + File.separator);
        if (!ds.exists() && !ds.mkdir()) {
            return false;
        }
        ds = new File(this.mapsetPath + File.separator + "cell_misc" + File.separator);
        if (!ds.exists() && !ds.mkdir()) {
            return false;
        }
        ds = new File(this.mapsetPath + File.separator + "cell_misc" + File.separator + this.name);
        if (!ds.exists() && !ds.mkdir()) {
            return false;
        }
        ds = new File(this.mapsetPath + File.separator + "fcell" + File.separator);
        if (!ds.exists() && !ds.mkdir()) {
            return false;
        }
        ds = new File(this.mapsetPath + File.separator + "cellhd" + File.separator);
        if (!ds.exists() && !ds.mkdir()) {
            return false;
        }
        ds = new File(this.mapsetPath + File.separator + "colr" + File.separator);
        if (!ds.exists() && !ds.mkdir()) {
            return false;
        }
        ds = new File(this.mapsetPath + File.separator + "hist" + File.separator);
        return ds.exists() || ds.mkdir();
    }

    private boolean createEmptyHeader(String filePath, int rows) {
        try {
            RandomAccessFile theCreatedFile = new RandomAccessFile(filePath, "rw");
            this.rowaddresses = new long[rows + 1];
            theCreatedFile.write(4);
            for (int i = 0; i < rows + 1; ++i) {
                theCreatedFile.writeInt(0);
            }
            this.rowaddresses[0] = this.pointerInFilePosition = theCreatedFile.getFilePointer();
            theCreatedFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void createUtilityFiles() throws Exception {
        File ds = new File(this.mapsetPath + File.separator + "cats" + File.separator + this.name);
        OutputStreamWriter catsWriter = new OutputStreamWriter(new FileOutputStream(ds));
        catsWriter.write("# xyz categories\n#\n#\n 0.00 0.00 0.00 0.00");
        catsWriter.close();
        ds = new File(this.mapsetPath + File.separator + "cell" + File.separator + this.name);
        OutputStreamWriter cellWriter = new OutputStreamWriter(new FileOutputStream(ds));
        cellWriter.write("");
        cellWriter.close();
        ds = new File(this.mapsetPath + File.separator + "cell_misc" + File.separator + this.name + File.separator + "f_format");
        OutputStreamWriter cell_miscFormatWriter = new OutputStreamWriter(new FileOutputStream(ds));
        if (this.outputToDiskType * 4 == 8) {
            cell_miscFormatWriter.write("type: double\nbyte_order: xdr\nlzw_compression_bits: -1");
        } else {
            cell_miscFormatWriter.write("type: float\nbyte_order: xdr\nlzw_compression_bits: -1");
        }
        cell_miscFormatWriter.close();
        ds = new File(this.mapsetPath + File.separator + "cell_misc" + File.separator + this.name + File.separator + "f_quant");
        OutputStreamWriter cell_miscQantWriter = new OutputStreamWriter(new FileOutputStream(ds));
        cell_miscQantWriter.write("round");
        cell_miscQantWriter.close();
        ds = new File(this.mapsetPath + File.separator + "cell_misc" + File.separator + this.name + File.separator + "f_range");
        FileOutputStream cell_miscRangeStream = new FileOutputStream(ds);
        ((OutputStream)cell_miscRangeStream).write(FileUtilities.double2bytearray(this.range[0]));
        ((OutputStream)cell_miscRangeStream).write(FileUtilities.double2bytearray(this.range[1]));
        ((OutputStream)cell_miscRangeStream).close();
        Window tmp = new Window(this.locationPath + File.separator + "PERMANENT" + File.separator + "WIND");
        this.createCellhd(tmp.getProj(), tmp.getZone(), this.dataWindow.getNorth(), this.dataWindow.getSouth(), this.dataWindow.getEast(), this.dataWindow.getWest(), this.dataWindow.getCols(), this.dataWindow.getRows(), this.dataWindow.getNSResolution(), this.dataWindow.getWEResolution(), -1, 1);
        ds = new File(this.mapsetPath + File.separator + "hist" + File.separator + this.name);
        OutputStreamWriter windFile = new OutputStreamWriter(new FileOutputStream(ds));
        Date date = new Date();
        windFile.write(date + "\n");
        windFile.write(this.name + "\n");
        windFile.write(this.mapsetPath + "\n");
        windFile.write("generic user\n");
        windFile.write("DCELL\n");
        windFile.write("\n\nCreated by JGrass\n");
        windFile.write(this.historyComment + "\n");
        windFile.close();
    }

    private void createCellhd(int chproj, int chzone, double chn, double chs, double che, double chw, int chcols, int chrows, double chnsres, double chewres, int chformat, int chcompressed) throws Exception {
        StringBuffer data = new StringBuffer(512);
        data.append("proj:   " + chproj + "\n").append("zone:   " + chzone + "\n").append("north:   " + chn + "\n").append("south:   " + chs + "\n").append("east:   " + che + "\n").append("west:   " + chw + "\n").append("cols:   " + chcols + "\n").append("rows:   " + chrows + "\n").append("n-s resol:   " + chnsres + "\n").append("e-w resol:   " + chewres + "\n").append("format:   " + chformat + "\n").append("compressed:   " + chcompressed);
        File ds = new File(this.mapsetPath + File.separator + "cellhd" + File.separator + this.name);
        OutputStreamWriter windFile = new OutputStreamWriter(new FileOutputStream(ds));
        windFile.write(data.toString());
        windFile.close();
    }

    @Override
    public void setOutputDataObject(Object _dataObject) {
        this.dataObject = _dataObject;
        if (_dataObject instanceof Double) {
            this.outputToDiskType = 2;
        } else if (_dataObject instanceof Float) {
            this.outputToDiskType = 1;
        }
    }

    @Override
    public void setParameter(String key, Object obj) {
    }

    @Override
    public void setDataWindow(Window window) {
        this.dataWindow = window;
    }

    @Override
    public boolean open(String mapPath) {
        File mapFile = new File(mapPath);
        String fileName = mapFile.getName();
        File mapsetFile = mapFile.getParentFile().getParentFile();
        String mapsetName = mapsetFile.getName();
        String locationPath = mapsetFile.getParent();
        return this.open(fileName, locationPath, mapsetName);
    }
}

