/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.dxfdwg.libs.dxf;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jgrasstools.gears.io.dxfdwg.libs.dxf.DxfGroup;
import org.jgrasstools.gears.io.dxfdwg.libs.dxf.DxfTABLE_ITEM;

public class DxfTABLE_UCS_ITEM
extends DxfTABLE_ITEM {
    private double[] origin = new double[3];
    private double[] xAxisDirection = new double[3];
    private double[] yAxisDirection = new double[3];

    public DxfTABLE_UCS_ITEM(String name, int flags) {
        super(name, flags);
        this.origin = new double[3];
        this.xAxisDirection = new double[3];
        this.yAxisDirection = new double[3];
    }

    public DxfTABLE_UCS_ITEM(String name, int flags, double[] origin, double[] xAxisDirection, double[] yAxisDirection) {
        super(name, flags);
        this.origin = origin;
        this.xAxisDirection = xAxisDirection;
        this.yAxisDirection = yAxisDirection;
    }

    public double[] getOrigin() {
        return this.origin;
    }

    public double getOriginX() {
        return this.origin[0];
    }

    public double getOriginY() {
        return this.origin[1];
    }

    public double getOriginZ() {
        return this.origin[2];
    }

    public double[] getXAxisDirection() {
        return this.xAxisDirection;
    }

    public double getXAxisDirectionX() {
        return this.xAxisDirection[0];
    }

    public double getXAxisDirectionY() {
        return this.xAxisDirection[1];
    }

    public double getXAxisDirectionZ() {
        return this.xAxisDirection[2];
    }

    public double[] getYAxisDirection() {
        return this.yAxisDirection;
    }

    public double getYAxisDirectionX() {
        return this.yAxisDirection[0];
    }

    public double getYAxisDirectionY() {
        return this.yAxisDirection[1];
    }

    public double getYAxisDirectionZ() {
        return this.yAxisDirection[2];
    }

    public void setOrigin(double[] origin) {
        this.origin = origin;
    }

    public void setOriginX(double originX) {
        this.origin[0] = originX;
    }

    public void setOriginY(double originY) {
        this.origin[1] = originY;
    }

    public void setOriginZ(double originZ) {
        this.origin[2] = originZ;
    }

    public void setXAxisDirection(double[] xAxisDirection) {
        this.xAxisDirection = xAxisDirection;
    }

    public void setXAxisDirectionX(double xAxisDirectionX) {
        this.xAxisDirection[0] = xAxisDirectionX;
    }

    public void setXAxisDirectionY(double xAxisDirectionY) {
        this.xAxisDirection[1] = xAxisDirectionY;
    }

    public void setXAxisDirectionZ(double xAxisDirectionZ) {
        this.xAxisDirection[2] = xAxisDirectionZ;
    }

    public void setYAxisDirection(double[] yAxisDirection) {
        this.yAxisDirection = yAxisDirection;
    }

    public void setYAxisDirectionX(double yAxisDirectionX) {
        this.yAxisDirection[0] = yAxisDirectionX;
    }

    public void setYAxisDirectionY(double yAxisDirectionY) {
        this.yAxisDirection[1] = yAxisDirectionY;
    }

    public void setYAxisDirectionZ(double yAxisDirectionZ) {
        this.yAxisDirection[2] = yAxisDirectionZ;
    }

    public static Map readTable(RandomAccessFile raf) throws IOException {
        DxfGroup group;
        DxfTABLE_UCS_ITEM item = new DxfTABLE_UCS_ITEM("DEFAULT", 0);
        LinkedHashMap<String, DxfTABLE_UCS_ITEM> table = new LinkedHashMap<String, DxfTABLE_UCS_ITEM>();
        while (null != (group = DxfGroup.readGroup(raf)) && !group.equals(ENDTAB)) {
            if (group.equals(UCS)) {
                item = new DxfTABLE_UCS_ITEM("DEFAULT", 0);
                continue;
            }
            if (group.getCode() == 2) {
                item.setName(group.getValue());
                table.put(item.getName(), item);
                continue;
            }
            if (group.getCode() == 5 || group.getCode() == 100) continue;
            if (group.getCode() == 70) {
                item.setFlags(group.getIntValue());
                continue;
            }
            if (group.getCode() == 10) {
                item.setOriginX(group.getDoubleValue());
                continue;
            }
            if (group.getCode() == 20) {
                item.setOriginY(group.getDoubleValue());
                continue;
            }
            if (group.getCode() == 30) {
                item.setOriginZ(group.getDoubleValue());
                continue;
            }
            if (group.getCode() == 11) {
                item.setXAxisDirectionX(group.getDoubleValue());
                continue;
            }
            if (group.getCode() == 21) {
                item.setXAxisDirectionY(group.getDoubleValue());
                continue;
            }
            if (group.getCode() == 31) {
                item.setXAxisDirectionZ(group.getDoubleValue());
                continue;
            }
            if (group.getCode() == 12) {
                item.setYAxisDirectionX(group.getDoubleValue());
                continue;
            }
            if (group.getCode() == 22) {
                item.setYAxisDirectionY(group.getDoubleValue());
                continue;
            }
            if (group.getCode() != 32) continue;
            item.setYAxisDirectionZ(group.getDoubleValue());
        }
        return table;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(DxfGroup.toString(10, this.origin[0], 6));
        sb.append(DxfGroup.toString(20, this.origin[1], 6));
        sb.append(DxfGroup.toString(30, this.origin[2], 6));
        sb.append(DxfGroup.toString(11, this.xAxisDirection[0], 6));
        sb.append(DxfGroup.toString(21, this.xAxisDirection[1], 6));
        sb.append(DxfGroup.toString(31, this.xAxisDirection[2], 6));
        sb.append(DxfGroup.toString(12, this.yAxisDirection[0], 6));
        sb.append(DxfGroup.toString(22, this.yAxisDirection[1], 6));
        sb.append(DxfGroup.toString(32, this.yAxisDirection[2], 6));
        return sb.toString();
    }
}

