/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.decoder;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import jj2000.j2k.decoder.Grib2JpegDecoder;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.util.StringFormatException;
import ucar.grib.GribNumbers;
import ucar.unidata.io.RandomAccessFile;

public class CmdLnDecoder {
    private ParameterList pl;
    private ParameterList defpl = new ParameterList();
    private Grib2JpegDecoder dec;

    public static void main(String[] argv) {
        if (argv.length == 0) {
            FacilityManager.getMsgLogger().println("CmdLnDecoder: JJ2000's JPEG 2000 Decoder\n    use jj2000.j2k.decoder.CmdLnDecoder -u to get help\n", 0, 0);
            System.exit(1);
        }
        new CmdLnDecoder(argv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmdLnDecoder(String[] argv) {
        String[][] param = Grib2JpegDecoder.getAllParameters();
        for (int i = param.length - 1; i >= 0; --i) {
            if (param[i][3] == null) continue;
            this.defpl.put(param[i][0], param[i][3]);
        }
        this.pl = new ParameterList(this.defpl);
        if (argv.length == 0) {
            throw new IllegalArgumentException("No arguments!");
        }
        try {
            this.pl.parseArgs(argv);
        }
        catch (StringFormatException e) {
            System.err.println("An error occured while parsing the arguments:\n" + e.getMessage());
            return;
        }
        if (this.pl.getParameter("pfile") != null) {
            InputStream is;
            try {
                is = new FileInputStream(this.pl.getParameter("pfile"));
                is = new BufferedInputStream(is);
                this.pl.load(is);
            }
            catch (FileNotFoundException e) {
                System.err.println("Could not load the argument file " + this.pl.getParameter("pfile"));
                return;
            }
            catch (IOException e) {
                System.err.println("An error ocurred while reading from the argument file " + this.pl.getParameter("pfile"));
                return;
            }
            try {
                is.close();
            }
            catch (IOException e) {
                System.out.println("[WARNING]: Could not close the argument file after reading");
            }
            try {
                this.pl.parseArgs(argv);
            }
            catch (StringFormatException e) {
                System.err.println("An error occured while re-parsing the arguments:\n" + e.getMessage());
                return;
            }
        }
        this.dec = new Grib2JpegDecoder(argv);
        if (this.dec.getExitCode() != 0) {
            System.exit(this.dec.getExitCode());
        }
        try {
            System.out.println("raf processing CmdLnDecoder");
            RandomAccessFile raf = new RandomAccessFile("/home/rkambic/jpeg2000/test/eta.j2k", "r");
            this.dec.decode(raf, (int)raf.length());
            int packBytes = this.dec.getPackBytes();
            int[] data = this.dec.getGdata();
            for (int i = 0; i < data.length; i += 2) {
                System.out.println("data[ " + i / 2 + " ] = " + GribNumbers.int2((int)data[i], (int)data[i + 1]));
            }
        }
        catch (IOException e) {
            return;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (this.dec.getExitCode() != 0) {
                System.exit(this.dec.getExitCode());
            }
        }
    }
}

