/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.xsd.XSDConstrainingFacet;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDFixedFacet;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDConstrainingFacetImpl;
import org.eclipse.xsd.impl.XSDFractionDigitsFacetImpl;
import org.eclipse.xsd.impl.XSDLengthFacetImpl;
import org.eclipse.xsd.impl.XSDMaxExclusiveFacetImpl;
import org.eclipse.xsd.impl.XSDMaxInclusiveFacetImpl;
import org.eclipse.xsd.impl.XSDMaxLengthFacetImpl;
import org.eclipse.xsd.impl.XSDMinExclusiveFacetImpl;
import org.eclipse.xsd.impl.XSDMinInclusiveFacetImpl;
import org.eclipse.xsd.impl.XSDMinLengthFacetImpl;
import org.eclipse.xsd.impl.XSDTotalDigitsFacetImpl;
import org.eclipse.xsd.impl.XSDWhiteSpaceFacetImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XSDFixedFacetImpl
extends XSDConstrainingFacetImpl
implements XSDFixedFacet {
    protected static final boolean FIXED_EDEFAULT = false;
    protected static final int FIXED_EFLAG = 256;
    protected static final int FIXED_ESETFLAG = 512;

    public static XSDFixedFacet createFixedFacet(Node node) {
        switch (XSDConstants.nodeType(node)) {
            case 15: {
                return XSDFractionDigitsFacetImpl.createFractionDigitsFacet(node);
            }
            case 21: {
                return XSDLengthFacetImpl.createLengthFacet(node);
            }
            case 23: {
                return XSDMaxExclusiveFacetImpl.createMaxExclusiveFacet(node);
            }
            case 24: {
                return XSDMaxInclusiveFacetImpl.createMaxInclusiveFacet(node);
            }
            case 25: {
                return XSDMaxLengthFacetImpl.createMaxLengthFacet(node);
            }
            case 26: {
                return XSDMinExclusiveFacetImpl.createMinExclusiveFacet(node);
            }
            case 27: {
                return XSDMinInclusiveFacetImpl.createMinInclusiveFacet(node);
            }
            case 28: {
                return XSDMinLengthFacetImpl.createMinLengthFacet(node);
            }
            case 38: {
                return XSDTotalDigitsFacetImpl.createTotalDigitsFacet(node);
            }
            case 41: {
                return XSDWhiteSpaceFacetImpl.createWhiteSpaceFacet(node);
            }
        }
        return null;
    }

    protected XSDFixedFacetImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_FIXED_FACET;
    }

    public boolean isFixed() {
        return (this.eFlags & 0x100) != 0;
    }

    public void setFixed(boolean newFixed) {
        boolean oldFixed;
        boolean bl = oldFixed = (this.eFlags & 0x100) != 0;
        this.eFlags = newFixed ? (this.eFlags |= 0x100) : (this.eFlags &= 0xFFFFFEFF);
        boolean oldFixedESet = (this.eFlags & 0x200) != 0;
        this.eFlags |= 0x200;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldFixed, newFixed, !oldFixedESet));
        }
    }

    public void unsetFixed() {
        boolean oldFixed = (this.eFlags & 0x100) != 0;
        boolean oldFixedESet = (this.eFlags & 0x200) != 0;
        this.eFlags &= 0xFFFFFEFF;
        this.eFlags &= 0xFFFFFDFF;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 10, oldFixed, false, oldFixedESet));
        }
    }

    public boolean isSetFixed() {
        return (this.eFlags & 0x200) != 0;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.isFixed() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setFixed((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.unsetFixed();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return this.isSetFixed();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (fixed: ");
        if ((this.eFlags & 0x200) != 0) {
            result.append((this.eFlags & 0x100) != 0);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    public void validate() {
        XSDSimpleTypeDefinition baseTypeDefinition;
        super.validate();
        Element theElement = this.getElement();
        this.checkBuiltInTypeConstraint("boolean", null, "http://www.w3.org/TR/xmlschema-2/", "element-" + this.getFacetName(), theElement, "fixed", false);
        this.checkAttributes("http://www.w3.org/TR/xmlschema-2/", "element-" + this.getFacetName(), theElement, new String[]{"fixed", "value", "id"});
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = this.getSimpleTypeDefinition();
        Iterator facets = xsdSimpleTypeDefinition.getFacetContents().iterator();
        while (facets.hasNext()) {
            XSDFacet xsdFacet = (XSDFacet)facets.next();
            if (xsdFacet == this) break;
            if (xsdFacet.eClass() != this.eClass()) continue;
            XSDDiagnostic xsdDiagnostic = this.reportConstraintViolation("http://www.w3.org/TR/xmlschema-2/", "src-single-facet-value", theElement, "value", new Object[]{this.getFacetName()});
            xsdDiagnostic.getComponents().add((Object)xsdFacet);
            break;
        }
        if ((baseTypeDefinition = xsdSimpleTypeDefinition.getBaseTypeDefinition()) != null) {
            Iterator facets2 = baseTypeDefinition.getFacets().iterator();
            while (facets2.hasNext()) {
                XSDConstrainingFacet xsdConstrainingFacet = (XSDConstrainingFacet)facets2.next();
                if (!(xsdConstrainingFacet instanceof XSDFixedFacet)) continue;
                XSDFixedFacet xsdFixedFacet = (XSDFixedFacet)xsdConstrainingFacet;
                if (this.eClass() == xsdFixedFacet.eClass() && xsdFixedFacet.isFixed() && !baseTypeDefinition.equalValues(this.getEffectiveValue(), xsdFixedFacet.getEffectiveValue())) {
                    XSDDiagnostic xsdDiagnostic = this.reportConstraintViolation("http://www.w3.org/TR/xmlschema-2/", "facet-fixed-valid-restriction", theElement, "value", new Object[]{this.getLexicalValue(), xsdFixedFacet.getLexicalValue(), this.getFacetName(), baseTypeDefinition.getURI()});
                    xsdDiagnostic.getComponents().add((Object)xsdFixedFacet);
                    xsdDiagnostic.setAnnotationURI("http://www.w3.org/TR/xmlschema-2/#dc-" + this.getFacetName());
                    break;
                }
                if (!this.restrictionMatch(xsdFixedFacet)) continue;
                this.validateRestriction(xsdFixedFacet);
                break;
            }
        }
    }

    protected void validateValue() {
        this.checkBuiltInTypeConstraint("nonNegativeInteger", this.getLexicalValue(), "http://www.w3.org/TR/xmlschema-2/", "element" + this.getFacetName(), this.getElement(), "value", true);
    }

    protected boolean restrictionMatch(XSDFixedFacet xsdFixedFacet) {
        return xsdFixedFacet.eClass() == this.eClass();
    }

    protected void validateRestriction(XSDFixedFacet xsdFixedFacet) {
    }

    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        if (changedElement == this.getElement()) {
            if (changedElement.hasAttributeNS(null, "fixed")) {
                boolean newFixed = "true".equals(changedElement.getAttributeNS(null, "fixed"));
                if (!this.isSetFixed() || newFixed != this.isFixed()) {
                    this.setFixed(newFixed);
                }
            } else {
                this.unsetFixed();
            }
        }
    }

    protected void changeAttribute(EAttribute eAttribute) {
        Element theElement;
        super.changeAttribute(eAttribute);
        if (!(this.isReconciling || eAttribute != null && eAttribute != XSDPackage.Literals.XSD_FIXED_FACET__FIXED || (theElement = this.getElement()) == null)) {
            this.niceSetAttribute(theElement, "fixed", this.isSetFixed() ? (this.isFixed() ? "true" : "false") : null);
        }
    }
}

