/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.lineofsight;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.ExtrudedPolygon;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.terrain.HighResolutionTerrain;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;

public class ExtrudedPolygonIntersection
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLatitude", 40.5);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLongitude", -120.4);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialAltitude", 125000.0);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialHeading", 27);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialPitch", 30);
        ApplicationTemplate.start("World Wind Extruded Polygon Intersection", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected HighResolutionTerrain terrain;
        protected ExtrudedPolygon polygon;
        protected RenderableLayer resultsLayer;
        protected RenderableLayer shapeLayer;

        public AppFrame() {
            super(true, true, false);
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
            arrayList.add(LatLon.fromDegrees(40.4, -120.6));
            arrayList.add(LatLon.fromDegrees(40.4, -120.4));
            arrayList.add(LatLon.fromDegrees(40.6, -120.4));
            arrayList.add(LatLon.fromDegrees(40.6, -120.6));
            this.polygon = new ExtrudedPolygon(arrayList, 10000.0);
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.LIGHT_GRAY);
            basicShapeAttributes.setInteriorOpacity(0.6);
            this.polygon.setCapAttributes(basicShapeAttributes);
            this.polygon.setSideAttributes(basicShapeAttributes);
            this.shapeLayer = new RenderableLayer();
            this.shapeLayer.addRenderable(this.polygon);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), this.shapeLayer);
            this.resultsLayer = new RenderableLayer();
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), this.resultsLayer);
            this.terrain = new HighResolutionTerrain(this.getWwd().getModel().getGlobe(), 20.0);
            Timer timer = new Timer(3000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Position position = Position.fromDegrees(40.5, -120.7, 5000.0);
                    Position position2 = Position.fromDegrees(40.5, -120.3, 5000.0);
                    AppFrame.this.drawLine(position, position2);
                    AppFrame.this.performIntersection(position, position2);
                    position = Position.fromDegrees(40.5, -120.5, 0.0);
                    position2 = new Position(position, 20000.0);
                    AppFrame.this.drawLine(position, position2);
                    AppFrame.this.performIntersection(position, position2);
                    ((Timer)actionEvent.getSource()).stop();
                }
            });
            timer.start();
        }

        protected void performIntersection(Position position, Position position2) {
            try {
                Vec4 vec4 = this.terrain.getSurfacePoint(position);
                Vec4 vec42 = this.terrain.getSurfacePoint(position2);
                Line line = new Line(vec42, vec4.subtract3(vec42));
                List<Intersection> list = this.polygon.intersect(line, this.terrain);
                if (list != null) {
                    for (Intersection intersection : list) {
                        this.drawIntersection(intersection);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }

        protected void drawLine(Position position, Position position2) {
            Path path = new Path(position, position2);
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            path.setAltitudeMode(2);
            basicShapeAttributes.setOutlineMaterial(Material.GREEN);
            basicShapeAttributes.setOutlineOpacity(0.6);
            basicShapeAttributes.setDrawOutline(true);
            basicShapeAttributes.setDrawInterior(false);
            path.setAttributes(basicShapeAttributes);
            this.resultsLayer.addRenderable(path);
            this.layerPanel.update(this.getWwd());
            this.getWwd().redraw();
        }

        protected void drawIntersection(Intersection intersection) {
            PointPlacemark pointPlacemark = new PointPlacemark(intersection.getIntersectionPosition());
            pointPlacemark.setAltitudeMode(2);
            PointPlacemarkAttributes pointPlacemarkAttributes = new PointPlacemarkAttributes();
            pointPlacemarkAttributes.setLineMaterial(Material.CYAN);
            pointPlacemarkAttributes.setScale(8.0);
            pointPlacemarkAttributes.setUsePointAsDefaultImage(true);
            pointPlacemark.setAttributes(pointPlacemarkAttributes);
            this.resultsLayer.addRenderable(pointPlacemark);
            this.layerPanel.update(this.getWwd());
            this.getWwd().redraw();
        }
    }
}

