/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.kml;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.ogc.kml.KMLAbstractFeature;
import gov.nasa.worldwind.ogc.kml.KMLAbstractView;
import gov.nasa.worldwind.ogc.kml.KMLGroundOverlay;
import gov.nasa.worldwind.ogc.kml.KMLNetworkLink;
import gov.nasa.worldwind.ogc.kml.KMLPlacemark;
import gov.nasa.worldwind.ogc.kml.KMLRoot;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.tree.TreeNode;
import gov.nasa.worldwindx.examples.kml.KMLViewController;
import gov.nasa.worldwindx.examples.util.BalloonController;
import java.awt.Component;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class KMLApplicationController
implements SelectListener,
PropertyChangeListener {
    protected WorldWindow wwd;
    protected TreeNode highlightedNode;
    protected BalloonController balloonController;

    public KMLApplicationController(WorldWindow worldWindow) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
        this.wwd.addSelectListener(this);
        this.wwd.getSceneController().addPropertyChangeListener(this);
    }

    public BalloonController getBalloonController() {
        return this.balloonController;
    }

    public void setBalloonController(BalloonController balloonController) {
        this.balloonController = balloonController;
    }

    @Override
    public void selected(SelectEvent selectEvent) {
        if (selectEvent.isLeftClick()) {
            Object object;
            Object object2 = selectEvent.getTopObject();
            if (object2 instanceof TreeNode && (object = ((TreeNode)object2).getValue("gov.nasa.worldwind.avkey.Context")) instanceof KMLAbstractFeature) {
                this.onFeatureSelected((KMLAbstractFeature)object);
            }
        } else if (selectEvent.isRollover()) {
            TreeNode treeNode;
            Object object;
            Object object3 = selectEvent.getTopObject();
            if (this.highlightedNode == object3) {
                return;
            }
            if (this.highlightedNode != null) {
                this.highlightedNode = null;
                this.setCursor(null);
            }
            if (object3 instanceof TreeNode && (object = (treeNode = (TreeNode)object3).getValue("gov.nasa.worldwind.avkey.Context")) instanceof KMLAbstractFeature && this.canSelect((KMLAbstractFeature)object)) {
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.highlightedNode = treeNode;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            if ("gov.nasa.worldwind.avkey.RetrievalStateSuccessful".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() instanceof KMLNetworkLink) {
                this.onNetworkLinkRefreshed((KMLNetworkLink)propertyChangeEvent.getNewValue());
            }
        }
        catch (Exception exception) {
            Logging.logger().warning(exception.getMessage() != null ? exception.getMessage() : exception.toString());
        }
    }

    protected void onNetworkLinkRefreshed(KMLNetworkLink kMLNetworkLink) {
        if (kMLNetworkLink == null) {
            return;
        }
        KMLRoot kMLRoot = kMLNetworkLink.getNetworkResource();
        if (kMLRoot == null) {
            return;
        }
        if (Boolean.TRUE.equals(kMLNetworkLink.getFlyToView())) {
            if (kMLRoot.getNetworkLinkControl() != null && kMLRoot.getNetworkLinkControl().getView() != null) {
                this.moveTo(kMLRoot.getNetworkLinkControl().getView());
                this.wwd.redraw();
            } else if (kMLRoot.getFeature() != null && kMLRoot.getFeature().getView() != null) {
                this.moveTo(kMLRoot.getFeature().getView());
                this.wwd.redraw();
            }
        }
    }

    protected void onFeatureSelected(KMLAbstractFeature kMLAbstractFeature) {
        this.moveTo(kMLAbstractFeature);
        if (this.balloonController != null) {
            this.balloonController.showBalloon(kMLAbstractFeature);
        }
    }

    protected void moveTo(KMLAbstractFeature kMLAbstractFeature) {
        KMLViewController kMLViewController = KMLViewController.create(this.wwd);
        if (kMLViewController == null) {
            return;
        }
        kMLViewController.goTo(kMLAbstractFeature);
    }

    protected void moveTo(KMLAbstractView kMLAbstractView) {
        KMLViewController kMLViewController = KMLViewController.create(this.wwd);
        if (kMLViewController == null) {
            return;
        }
        kMLViewController.goTo(kMLAbstractView);
    }

    protected void setCursor(Cursor cursor) {
        if (this.wwd instanceof Component) {
            ((Component)((Object)this.wwd)).setCursor(cursor);
        }
    }

    protected boolean canSelect(KMLAbstractFeature kMLAbstractFeature) {
        return this.canMoveTo(kMLAbstractFeature) || this.canShowBalloon(kMLAbstractFeature);
    }

    protected boolean canMoveTo(KMLAbstractFeature kMLAbstractFeature) {
        return kMLAbstractFeature.getView() != null || kMLAbstractFeature instanceof KMLPlacemark || kMLAbstractFeature instanceof KMLGroundOverlay;
    }

    protected boolean canShowBalloon(KMLAbstractFeature kMLAbstractFeature) {
        BalloonController balloonController = this.getBalloonController();
        return balloonController != null && balloonController.canShowBalloon(kMLAbstractFeature);
    }
}

