/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.applications.worldwindow.core.layermanager.LayerPath;
import gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager.LayerNode;
import gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager.LayerTreeGroupNode;
import gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager.LayerTreeNode;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class LayerTreeModel
extends DefaultTreeModel {
    private boolean includeInternalLayers = false;

    public LayerTreeModel() {
        super(new LayerTreeGroupNode("Root"), true);
    }

    public LayerTreeModel(LayerList layerList) {
        this();
        this.getRootNode().add(this.makeGroup(layerList));
    }

    public LayerTreeGroupNode getRootNode() {
        return (LayerTreeGroupNode)this.getRoot();
    }

    public LayerTreeGroupNode getDefaultGroupNode() {
        if (!(this.getRootNode().getFirstChild() instanceof LayerTreeGroupNode)) {
            Util.getLogger().severe("Illegal State: The default group node is not a layer node.");
            return null;
        }
        return (LayerTreeGroupNode)this.getRootNode().getFirstChild();
    }

    public boolean isIncludeInternalLayers() {
        return this.includeInternalLayers;
    }

    public static boolean isInternalLayer(Layer layer) {
        return layer.getValue("gov.nasa.worldwindx.applications.worldwindow.InternalLayer") != null;
    }

    public void setIncludeInternalLayers(boolean bl) {
        if (bl == this.includeInternalLayers) {
            return;
        }
        this.includeInternalLayers = bl;
        this.reload();
    }

    public void selectLayer(Layer layer, boolean bl) {
        List<LayerTreeNode> list = this.findLayerInstances(layer, null);
        if (list == null) {
            return;
        }
        for (LayerTreeNode layerTreeNode : list) {
            layerTreeNode.setSelected(bl);
            this.nodeChanged(layerTreeNode);
        }
    }

    public LayerTreeNode findChild(String string, LayerTreeNode layerTreeNode) {
        if (string == null) {
            return null;
        }
        if (layerTreeNode == null) {
            layerTreeNode = this.getRootNode();
        }
        for (int i = 0; i < layerTreeNode.getChildCount(); ++i) {
            if (!((LayerTreeNode)layerTreeNode.getChildAt(i)).getTitle().equals(string)) continue;
            return (LayerTreeNode)layerTreeNode.getChildAt(i);
        }
        return null;
    }

    public LayerTreeNode getLastNode(LayerPath layerPath) {
        if (LayerPath.isEmptyPath(layerPath)) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        for (String string : layerPath) {
            if (defaultMutableTreeNode == null) {
                defaultMutableTreeNode = this.getRootNode();
            }
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            defaultMutableTreeNode = null;
            while (enumeration.hasMoreElements()) {
                LayerTreeNode layerTreeNode = (LayerTreeNode)enumeration.nextElement();
                if (!layerTreeNode.getTitle().equals(string)) continue;
                defaultMutableTreeNode = layerTreeNode;
                break;
            }
            if (defaultMutableTreeNode != null) continue;
            return null;
        }
        return defaultMutableTreeNode;
    }

    protected LayerTreeGroupNode makeGroup(LayerList layerList) {
        LayerTreeGroupNode layerTreeGroupNode = new LayerTreeGroupNode(layerList.getDisplayName());
        for (Layer layer : layerList) {
            if (layer.getValue("gov.nasa.worldwindx.applications.worldwindow.InternalLayer") != null && !this.isIncludeInternalLayers()) continue;
            LayerTreeNode layerTreeNode = new LayerTreeNode(layer);
            layerTreeNode.setAllowsChildren(false);
            layerTreeGroupNode.add(layerTreeNode);
        }
        return layerTreeGroupNode;
    }

    public void refresh(LayerList layerList) {
        if (layerList == null || layerList.size() == 0) {
            return;
        }
        for (Layer layer : layerList) {
            LayerTreeNode layerTreeNode = this.findLayer(layer, null);
            if (layerTreeNode != null && LayerTreeModel.isInternalLayer(layer) && !this.isIncludeInternalLayers()) {
                this.removeNodeFromParent(layerTreeNode);
                continue;
            }
            if (LayerTreeModel.isInternalLayer(layer) && !this.isIncludeInternalLayers()) continue;
            if (layerTreeNode == null) {
                LayerTreeNode layerTreeNode2 = (LayerTreeNode)this.getRootNode().getChildAt(0);
                if (!(layerTreeNode2 instanceof LayerTreeGroupNode)) {
                    Util.getLogger().severe("Illegal State: The root node is not a layer node.");
                    return;
                }
                layerTreeNode = new LayerTreeNode(layer);
                layerTreeNode.setAllowsChildren(false);
                this.insertNodeInto(layerTreeNode, layerTreeNode2, layerTreeNode2.getChildCount());
            }
            layerTreeNode.setSelected(true);
        }
    }

    public void removeNode(Object object) {
        if (object == null) {
            return;
        }
        LayerTreeNode layerTreeNode = null;
        if (object instanceof Layer) {
            layerTreeNode = this.findLayer((Layer)object, null);
        } else if (object instanceof LayerNode) {
            layerTreeNode = this.find((LayerTreeNode)object);
        }
        if (layerTreeNode != null) {
            this.removeNodeFromParent(layerTreeNode);
        }
    }

    public LayerTreeNode findLayer(Layer layer, LayerTreeGroupNode layerTreeGroupNode) {
        if (layer == null) {
            return null;
        }
        if (layerTreeGroupNode == null) {
            layerTreeGroupNode = this.getRootNode();
        }
        Enumeration<TreeNode> enumeration = layerTreeGroupNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            LayerTreeNode layerTreeNode = (LayerTreeNode)enumeration.nextElement();
            if (layerTreeNode == null || layerTreeNode instanceof LayerTreeGroupNode || layerTreeNode.getLayer() != layer) continue;
            return layerTreeNode;
        }
        return null;
    }

    public List<LayerTreeNode> findLayerInstances(Layer layer, LayerTreeGroupNode layerTreeGroupNode) {
        if (layer == null) {
            return null;
        }
        if (layerTreeGroupNode == null) {
            layerTreeGroupNode = this.getRootNode();
        }
        ArrayList<LayerTreeNode> arrayList = new ArrayList<LayerTreeNode>();
        Enumeration<TreeNode> enumeration = layerTreeGroupNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            LayerTreeNode layerTreeNode = (LayerTreeNode)enumeration.nextElement();
            if (layerTreeNode == null || layerTreeNode instanceof LayerTreeGroupNode || layerTreeNode.getLayer() != layer) continue;
            arrayList.add(layerTreeNode);
        }
        return arrayList;
    }

    public LayerTreeNode findByTitle(String string, LayerTreeNode layerTreeNode) {
        if (WWUtil.isEmpty(string)) {
            return null;
        }
        if (layerTreeNode == null) {
            layerTreeNode = this.getRootNode();
        }
        Enumeration<TreeNode> enumeration = layerTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            LayerTreeNode layerTreeNode2 = (LayerTreeNode)enumeration.nextElement();
            if (layerTreeNode2 == null || !layerTreeNode2.getTitle().equals(string)) continue;
            return layerTreeNode2;
        }
        return null;
    }

    public LayerTreeNode findByTitle(String string) {
        if (this.getRoot() == null || string == null) {
            return null;
        }
        Enumeration<TreeNode> enumeration = this.getRootNode().breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            LayerTreeNode layerTreeNode = (LayerTreeNode)enumeration.nextElement();
            if (layerTreeNode == null || layerTreeNode.getTitle() == null || !layerTreeNode.getTitle().equals(string)) continue;
            return layerTreeNode;
        }
        return null;
    }

    public LayerTreeNode findByTitle(String string, String string2) {
        LayerTreeNode layerTreeNode;
        if (string == null) {
            return null;
        }
        LayerTreeNode layerTreeNode2 = layerTreeNode = string2 != null ? this.findByTitle(string2) : this.getRootNode();
        if (!(layerTreeNode instanceof LayerTreeGroupNode)) {
            return null;
        }
        Enumeration<TreeNode> enumeration = layerTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            LayerTreeNode layerTreeNode3 = (LayerTreeNode)enumeration.nextElement();
            if (layerTreeNode3 == null || layerTreeNode3.getTitle() == null || !layerTreeNode3.getTitle().equals(string)) continue;
            return layerTreeNode3;
        }
        return null;
    }

    public LayerTreeNode find(LayerNode layerNode) {
        if (this.getRoot() == null || layerNode == null) {
            return null;
        }
        Enumeration<TreeNode> enumeration = this.getRootNode().preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            LayerTreeNode layerTreeNode = (LayerTreeNode)enumeration.nextElement();
            if (layerTreeNode == null || !layerTreeNode.getID().equals(layerNode.getID())) continue;
            return layerTreeNode;
        }
        return null;
    }
}

