/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.core.layermanager.LayerPath;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeature;

public abstract class AbstractOnDemandLayerFeature
extends AbstractFeature {
    protected String group;
    protected Layer layer;
    protected boolean on = false;

    protected abstract Layer createLayer();

    public AbstractOnDemandLayerFeature(String string, String string2, String string3, String string4, Registry registry) {
        super(string, string2, string3, registry);
        this.group = string4;
    }

    @Override
    public boolean isTwoState() {
        return true;
    }

    @Override
    public boolean isOn() {
        return this.on;
    }

    @Override
    public void turnOn(boolean bl) {
        if (bl == this.on) {
            return;
        }
        if (bl && this.layer == null) {
            this.layer = this.createLayer();
        }
        if (this.layer == null) {
            return;
        }
        if (bl) {
            LayerPath layerPath = new LayerPath(this.group, new String[0]);
            this.addLayer(layerPath);
            this.controller.getLayerManager().selectLayer(this.layer, true);
        } else {
            this.removeLayer();
        }
        this.on = bl;
    }

    protected void addLayer(LayerPath layerPath) {
        this.controller.getLayerManager().addLayer(this.layer, layerPath);
    }

    protected void removeLayer() {
        this.controller.getLayerManager().removeLayer(this.layer);
    }
}

