/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.applications.sar.SARAnnotation;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SARAnnotationWriter {
    private final Document doc;
    private final Result result;

    public SARAnnotationWriter(String string) throws IOException, ParserConfigurationException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.doc = documentBuilderFactory.newDocumentBuilder().newDocument();
        this.result = new StreamResult(new File(string));
        this.createAnnotationsDocument(this.doc);
    }

    public SARAnnotationWriter(OutputStream outputStream) throws IOException, ParserConfigurationException {
        if (outputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.doc = documentBuilderFactory.newDocumentBuilder().newDocument();
        this.result = new StreamResult(outputStream);
        this.createAnnotationsDocument(this.doc);
    }

    public void writeAnnotation(SARAnnotation sARAnnotation) throws TransformerException {
        if (sARAnnotation == null) {
            String string = "nullValue.SARAnnotationIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.doWriteAnnotation(sARAnnotation, this.doc.getDocumentElement());
    }

    public void writeAnnotations(Iterable<SARAnnotation> iterable) throws TransformerException {
        if (iterable == null) {
            String string = "nullValue.SARAnnotationIterableIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (SARAnnotation sARAnnotation : iterable) {
            if (sARAnnotation == null) continue;
            this.doWriteAnnotation(sARAnnotation, this.doc.getDocumentElement());
        }
        this.doFlush();
    }

    public void close() {
    }

    private void createAnnotationsDocument(Document document) {
        if (document != null) {
            if (document.getDocumentElement() != null) {
                document.removeChild(document.getDocumentElement());
            }
            Element element = document.createElement("sarTrackAnnotations");
            document.appendChild(element);
        }
    }

    private void doWriteAnnotation(SARAnnotation sARAnnotation, Element element) {
        if (sARAnnotation != null) {
            Text text;
            Element element2;
            Element element3 = this.doc.createElement("sarAnnotation");
            if (sARAnnotation.getPosition() != null) {
                element2 = this.doc.createElement("latitude");
                text = this.doc.createTextNode(Double.toString(sARAnnotation.getPosition().getLatitude().degrees));
                element2.appendChild(text);
                element3.appendChild(element2);
                Element element4 = this.doc.createElement("longitude");
                Text text2 = this.doc.createTextNode(Double.toString(sARAnnotation.getPosition().getLongitude().degrees));
                element4.appendChild(text2);
                element3.appendChild(element4);
            }
            if (sARAnnotation.getId() != null) {
                element2 = this.doc.createElement("id");
                text = this.doc.createTextNode(sARAnnotation.getId());
                element2.appendChild(text);
                element3.appendChild(element2);
            }
            if (sARAnnotation.getText() != null) {
                element2 = this.doc.createElement("text");
                text = this.doc.createCDATASection(sARAnnotation.getText());
                element2.appendChild(text);
                element3.appendChild(element2);
            }
            element.appendChild(element3);
        }
    }

    private void doFlush() throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource dOMSource = new DOMSource(this.doc);
        transformer.transform(dOMSource, this.result);
    }
}

