/*
 * Decompiled with CFR 0.152.
 */
package jams.gui.tools;

import jams.JAMS;
import jams.SystemProperties;
import jams.gui.tools.RestrictedFileSystemView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class GUIHelper {
    public static final int NO_OPTION = 1;
    public static final int YES_OPTION = 0;
    public static final int CANCEL_OPTION = 2;
    private static HashMap<FileFilter, JFileChooser> choosers = new HashMap();

    public static void removeGBComponent(Container cont, Component c) {
        cont.remove(c);
    }

    public static Component addGBComponent(Container cont, GridBagLayout gbl, Component c, int x, int y, int width, int height, double weightx, double weighty) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbl.setConstraints(c, gbc);
        return cont.add(c);
    }

    public static Component addGBComponent(Container cont, GridBagLayout gbl, Component c, int x, int y, int width, int height, double weightx, double weighty, int filling) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = filling;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbl.setConstraints(c, gbc);
        return cont.add(c);
    }

    public static Component addGBComponent(Container cont, GridBagLayout gbl, Component c, int x, int y, int width, int height, int topInset, int leftInset, int bottomInset, int rightInset, double weightx, double weighty) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(topInset, leftInset, bottomInset, rightInset);
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbl.setConstraints(c, gbc);
        return cont.add(c);
    }

    public static Component addGBComponent(Container cont, GridBagLayout gbl, Component c, int x, int y, int width, int height, double weightx, double weighty, int fill, int anchor) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = fill;
        gbc.anchor = anchor;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbl.setConstraints(c, gbc);
        return cont.add(c);
    }

    public static int showYesNoCancelDlg(Component owner, String message, String title) {
        Object[] options = new Object[]{JAMS.i18n("Yes"), JAMS.i18n("No"), JAMS.i18n("Cancel")};
        int result = JOptionPane.showOptionDialog(owner, message, title, 1, 3, null, options, options[0]);
        return result;
    }

    public static int showYesNoDlg(Component owner, String message, String title) {
        Object[] options = new Object[]{JAMS.i18n("Yes"), JAMS.i18n("No")};
        int result = JOptionPane.showOptionDialog(owner, message, title, 0, 3, null, options, options[0]);
        return result;
    }

    public static void showInfoDlg(Component owner, String message, String title) {
        JOptionPane.showMessageDialog(owner, message, title, 1);
    }

    public static void showInfoDlg(Component owner, String message) {
        JOptionPane.showMessageDialog(owner, message, JAMS.i18n("INFO"), 1);
    }

    public static void showErrorDlg(Component owner, String message, String title) {
        JOptionPane.showMessageDialog(owner, message, title, 0);
    }

    public static void showErrorDlg(Component owner, String message) {
        JOptionPane.showMessageDialog(owner, message, JAMS.i18n("ERROR"), 0);
    }

    public static String showInputDlg(Component owner, String message, String initalValue) {
        return JOptionPane.showInputDialog(owner, message, initalValue);
    }

    public static String showInputDlg(Component owner, String message, String title, String initalValue) {
        return (String)JOptionPane.showInputDialog(owner, message, title, 3, null, null, initalValue);
    }

    public static JFileChooser getJFileChooser(boolean useShellFolder) {
        if (useShellFolder) {
            try {
                return new JFileChooser();
            }
            catch (Throwable t) {
                return GUIHelper.getJFileChooser(false);
            }
        }
        return new JFileChooser(new File("."), (FileSystemView)new RestrictedFileSystemView()){

            @Override
            protected void setup(FileSystemView view) {
                this.putClientProperty("FileChooser.useShellFolder", Boolean.FALSE);
                super.setup(view);
            }
        };
    }

    public static JFileChooser getJFileChooser(FileFilter filter) {
        JFileChooser jfc = choosers.get(filter);
        if (jfc == null) {
            jfc = GUIHelper.getJFileChooser(true);
            jfc.setFileFilter(filter);
            choosers.put(filter, jfc);
        }
        return jfc;
    }

    public static JFileChooser getJFileChooser() {
        return GUIHelper.getJFileChooser(true);
    }

    public static void openURL(String url) {
        String osName = System.getProperty("os.name");
        String errMsg = JAMS.i18n("Error_attempting_to_launch_web_browser");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception(JAMS.i18n("Could_not_find_web_browser"));
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, errMsg + ":\n" + e.getLocalizedMessage());
        }
    }

    public static void setupLogHandler(Logger logger, final Component owner) {
        logger.addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                String msg = record.getMessage();
                int i = 0;
                Object[] params = record.getParameters();
                if (params != null) {
                    for (Object o : params) {
                        msg = msg.replace("{" + i + "}", o.toString());
                        ++i;
                    }
                }
                if (record.getLevel().intValue() <= Level.INFO.intValue()) {
                    GUIHelper.showInfoDlg(owner, msg, JAMS.i18n("INFO"));
                } else if (record.getLevel().intValue() <= Level.SEVERE.intValue()) {
                    GUIHelper.showErrorDlg(owner, msg, JAMS.i18n("ERROR"));
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        });
    }

    public static JMenuItem getRecentMenu(SystemProperties properties) {
        JMenuItem recentMenu = new JMenuItem(JAMS.i18n("Recent_Files"));
        return recentMenu;
    }

    public static void centerOnScreen(Component c, boolean absolute) {
        int width = c.getWidth();
        int height = c.getHeight();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = screenSize.width / 2 - width / 2;
        int y = screenSize.height / 2 - height / 2;
        if (!absolute) {
            x /= 2;
            y /= 2;
        }
        c.setLocation(x, y);
    }

    public static void centerOnParent(Window child, boolean absolute) {
        int y;
        int x;
        child.pack();
        boolean useChildsOwner = child.getOwner() != null ? child.getOwner() instanceof JFrame || child.getOwner() instanceof JDialog : false;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension parentSize = useChildsOwner ? child.getOwner().getSize() : screenSize;
        Point parentLocationOnScreen = useChildsOwner ? child.getOwner().getLocationOnScreen() : new Point(0, 0);
        Dimension childSize = child.getSize();
        childSize.width = Math.min(childSize.width, screenSize.width);
        childSize.height = Math.min(childSize.height, screenSize.height);
        child.setSize(childSize);
        if (child.getOwner() != null && child.getOwner().isShowing()) {
            x = (parentSize.width - childSize.width) / 2;
            y = (parentSize.height - childSize.height) / 2;
            x += parentLocationOnScreen.x;
            y += parentLocationOnScreen.y;
        } else {
            x = (screenSize.width - childSize.width) / 2;
            y = (screenSize.height - childSize.height) / 2;
        }
        if (!absolute) {
            x /= 2;
            y /= 2;
        }
        child.setLocation(x, y);
    }

    public static Window findWindow(Component c) {
        if (c == null) {
            return JOptionPane.getRootFrame();
        }
        if (c instanceof Window) {
            return (Window)c;
        }
        return GUIHelper.findWindow(c.getParent());
    }
}

