/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdflib;

import java.io.OutputStream;
import ncsa.hdf.hdflib.HDFArray;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFLibrary;
import ncsa.hdf.hdflib.HDFNativeData;

public class HDFDeprecated
extends HDFLibrary {
    public static final String H45PATH_PROPERTY_KEY = "ncsa.hdf.libh4toh5.h4toh5.h45lib";
    public static final String HDFPATH_PROPERTY_KEY = "ncsa.hdf.hdflib.HDFLibrary.hdflib";

    public static native boolean DFANaddfds(int var0, String var1, int var2) throws HDFException;

    public static native boolean DFANaddfid(int var0, String var1) throws HDFException;

    public static native boolean DFANclear() throws HDFException;

    public static native boolean DFANgetdesc(String var0, short var1, short var2, String[] var3, int var4) throws HDFException;

    public static native int DFANgetdesclen(String var0, short var1, short var2) throws HDFException;

    public static native int DFANgetfds(int var0, String[] var1, int var2, int var3) throws HDFException;

    public int DFANgetfds(int file_id, String[] desc_buf, int buf_len, boolean isfirst) throws HDFException {
        if (isfirst) {
            return HDFDeprecated.DFANgetfds(file_id, desc_buf, buf_len, 1);
        }
        return HDFDeprecated.DFANgetfds(file_id, desc_buf, buf_len, 0);
    }

    public static native int DFANgetfdslen(int var0, int var1) throws HDFException;

    public int DFANgetfdslen(int file_id, boolean isfirst) throws HDFException {
        if (isfirst) {
            return HDFDeprecated.DFANgetfdslen(file_id, 1);
        }
        return HDFDeprecated.DFANgetfdslen(file_id, 0);
    }

    public static native int DFANgetfid(int var0, String[] var1, int var2, int var3) throws HDFException;

    public int DFANgetfid(int file_id, String[] desc_buf, int buf_len, boolean isfirst) throws HDFException {
        if (isfirst) {
            return HDFDeprecated.DFANgetfid(file_id, desc_buf, buf_len, 1);
        }
        return HDFDeprecated.DFANgetfid(file_id, desc_buf, buf_len, 0);
    }

    public static native int DFANgetfidlen(int var0, int var1) throws HDFException;

    public int DFANgetfidlen(int file_id, boolean isfirst) throws HDFException {
        if (isfirst) {
            return HDFDeprecated.DFANgetfidlen(file_id, 1);
        }
        return HDFDeprecated.DFANgetfidlen(file_id, 0);
    }

    public static native boolean DFANgetlabel(String var0, short var1, short var2, String[] var3, int var4) throws HDFException;

    public static native int DFANgetlablen(String var0, short var1, short var2) throws HDFException;

    public static native int DFANlablist(String var0, short var1, short[] var2, String[] var3, int var4, int var5, int var6) throws HDFException;

    public static native short DFANlastref() throws HDFException;

    public static native boolean DFANputdesc(String var0, short var1, short var2, String var3, int var4) throws HDFException;

    public static native boolean DFANputlabel(String var0, short var1, short var2, String var3) throws HDFException;

    public static native boolean DFSDadddata(String var0, int var1, int[] var2, byte[] var3) throws HDFException;

    public boolean DFSDadddata(String filename, int rank, int[] dimsizes, Object theData) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.byteify();
        return HDFDeprecated.DFSDadddata(filename, rank, dimsizes, data);
    }

    public static native boolean DFSDclear() throws HDFException;

    public static native boolean DFSDendslab() throws HDFException;

    public static native boolean DFSDendslice() throws HDFException;

    public static native boolean DFSDgetcal(double[] var0) throws HDFException;

    public static native boolean DFSDgetdata(String var0, int[] var1, int[] var2, byte[] var3) throws HDFException;

    public boolean DFSDgetdata(String filename, int[] rank, int[] dimsizes, Object theData) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.emptyBytes();
        boolean rval = HDFDeprecated.DFSDgetdata(filename, rank, dimsizes, data);
        theData = theArray.arrayify(data);
        return rval;
    }

    public static native boolean DFSDgetdatalen(int[] var0) throws HDFException;

    public static native boolean DFSDgetdatastrs(String[] var0) throws HDFException;

    public static native boolean DFSDgetdimlen(int var0, int[] var1) throws HDFException;

    public static native boolean DFSDgetdims(String var0, int[] var1, int[] var2, int var3) throws HDFException;

    public static native boolean DFSDgetdimscale(int var0, int var1, byte[] var2) throws HDFException;

    public boolean DFSDgetdimscale(int dim, int size, Object theScale) throws HDFException {
        HDFArray theArray = new HDFArray(theScale);
        byte[] scale = theArray.emptyBytes();
        boolean rval = HDFDeprecated.DFSDgetdimscale(dim, size, scale);
        theScale = theArray.arrayify(scale);
        return rval;
    }

    public static native boolean DFSDgetdimstrs(int var0, String[] var1) throws HDFException;

    public static native boolean DFSDgetfillvalue(byte[] var0) throws HDFException;

    public boolean DFSDgetfillvalue(Object[] theFillValue) throws HDFException {
        byte[] d1;
        boolean rval;
        int[] nt = new int[1];
        HDFDeprecated.DFSDgetNT(nt);
        int NT = nt[0];
        if ((NT & 0x4000) != 0) {
            NT -= 16384;
        }
        if (!(rval = HDFDeprecated.DFSDgetfillvalue(d1 = new byte[8]))) {
            return rval;
        }
        if (NT == 20 || NT == 4 || NT == 4) {
            theFillValue[0] = new Byte(d1[0]);
        } else if (NT == 21 || NT == 3 || NT == 3) {
            Byte f = new Byte(d1[0]);
            theFillValue[0] = f.shortValue() < 0 ? new Short((short)(f.intValue() + 256)) : new Short(f.shortValue());
        } else if (NT == 22 || NT == 42) {
            short[] fx = HDFNativeData.byteToShort(0, 1, d1);
            theFillValue[0] = new Short(fx[0]);
        } else if (NT == 23 || NT == 43) {
            short[] fmx = HDFNativeData.byteToShort(0, 1, d1);
            Short f = new Short(fmx[0]);
            theFillValue[0] = f.intValue() < 0 ? new Integer(f.intValue() + 65536) : new Integer(f.intValue());
        } else if (NT == 24) {
            int[] fx = HDFNativeData.byteToInt(0, 1, d1);
            theFillValue[0] = new Integer(fx[0]);
        } else if (NT == 25) {
            int[] fmx = HDFNativeData.byteToInt(0, 1, d1);
            Integer i = new Integer(fmx[0]);
            theFillValue[0] = i.floatValue() < 0.0f ? new Float((float)((double)i.floatValue() + 4.294967296E9)) : new Float(i.floatValue());
        } else if (NT == 5) {
            float[] fx = HDFNativeData.byteToFloat(0, 1, d1);
            theFillValue[0] = new Float(fx[0]);
        } else if (NT == 6) {
            double[] fx = HDFNativeData.byteToDouble(0, 1, d1);
            theFillValue[0] = new Double(fx[0]);
        } else {
            System.out.println("Error: DFSDgetfillvalue not converting, type " + NT);
        }
        return rval;
    }

    public static native boolean DFSDgetNT(int[] var0) throws HDFException;

    public static native boolean DFSDgetrange(byte[] var0, byte[] var1) throws HDFException;

    public boolean DFSDgetrange(double[] maxmin) throws HDFException {
        byte[] d2;
        byte[] d1;
        boolean rval;
        int[] nt = new int[1];
        HDFDeprecated.DFSDgetNT(nt);
        int NT = nt[0];
        if ((NT & 0x4000) != 0) {
            NT -= 16384;
        }
        if (!(rval = HDFDeprecated.DFSDgetrange(d1 = new byte[8], d2 = new byte[8]))) {
            return rval;
        }
        if (NT == 20 || NT == 4 || NT == 4) {
            Byte f = new Byte(d1[0]);
            maxmin[0] = f.doubleValue();
            f = new Byte(d2[0]);
            maxmin[1] = f.doubleValue();
        } else if (NT == 21 || NT == 3 || NT == 3) {
            Byte f = new Byte(d1[0]);
            Short fmx = f.shortValue() < 0 ? new Short((short)(f.intValue() + 256)) : new Short(f.shortValue());
            maxmin[0] = fmx.doubleValue();
            f = new Byte(d2[0]);
            fmx = new Short(f.shortValue());
            maxmin[1] = fmx.doubleValue();
        } else if (NT == 22 || NT == 42) {
            short[] fmx = HDFNativeData.byteToShort(0, 1, d1);
            short[] fmn = HDFNativeData.byteToShort(0, 1, d2);
            Short f = new Short(fmx[0]);
            maxmin[0] = f.doubleValue();
            f = new Short(fmn[0]);
            maxmin[1] = f.doubleValue();
        } else if (NT == 23 || NT == 23) {
            short[] fmx = HDFNativeData.byteToShort(0, 1, d1);
            Short f = new Short(fmx[0]);
            Integer i = f.intValue() < 0 ? new Integer(f.intValue() + 65536) : new Integer(f.intValue());
            maxmin[0] = i.doubleValue();
            fmx = HDFNativeData.byteToShort(0, 1, d2);
            f = new Short(fmx[0]);
            i = f.intValue() < 0 ? new Integer(f.intValue() + 65536) : new Integer(f.intValue());
            maxmin[0] = i.doubleValue();
            fmx = HDFNativeData.byteToShort(0, 1, d2);
            f = new Short(fmx[0]);
            i = f.intValue() < 0 ? new Integer(f.intValue() + 65536) : new Integer(f.intValue());
            maxmin[1] = i.doubleValue();
        } else if (NT == 24) {
            int[] fmx = HDFNativeData.byteToInt(0, 1, d1);
            int[] fmn = HDFNativeData.byteToInt(0, 1, d2);
            Integer f = new Integer(fmx[0]);
            maxmin[0] = f.doubleValue();
            f = new Integer(fmn[0]);
            maxmin[1] = f.doubleValue();
        } else if (NT == 25) {
            int[] fmx = HDFNativeData.byteToInt(0, 1, d1);
            Integer i = new Integer(fmx[0]);
            Float f = i.floatValue() < 0.0f ? new Float((float)((double)i.floatValue() + 4.294967296E9)) : new Float(i.floatValue());
            maxmin[0] = f.doubleValue();
            fmx = HDFNativeData.byteToInt(0, 1, d1);
            i = new Integer(fmx[0]);
            f = i.floatValue() < 0.0f ? new Float((float)((double)i.floatValue() + 4.294967296E9)) : new Float(i.floatValue());
            maxmin[1] = f.doubleValue();
        } else if (NT == 5) {
            float[] fmx = HDFNativeData.byteToFloat(0, 1, d1);
            float[] fmn = HDFNativeData.byteToFloat(0, 1, d2);
            Float f = new Float(fmx[0]);
            maxmin[0] = f.doubleValue();
            f = new Float(fmn[0]);
            maxmin[1] = f.doubleValue();
        } else if (NT == 6) {
            double[] fmx = HDFNativeData.byteToDouble(0, 1, d1);
            double[] fmn = HDFNativeData.byteToDouble(0, 1, d2);
            Double f = new Double(fmx[0]);
            maxmin[0] = f;
            f = new Double(fmn[0]);
            maxmin[1] = f;
        } else {
            System.out.println("Error: DFSDgetrange not converting, type " + NT);
        }
        return rval;
    }

    public static native boolean DFSDgetslice(String var0, int[] var1, int[] var2, byte[] var3, int[] var4) throws HDFException;

    public boolean DFSDgetslice(String filename, int[] winst, int[] windims, Object theData, int[] dims) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.emptyBytes();
        boolean rval = HDFDeprecated.DFSDgetslice(filename, winst, windims, data, dims);
        theData = theArray.arrayify(data);
        return rval;
    }

    public static native int DFSDlastref() throws HDFException;

    public static native int DFSDndatasets(String var0) throws HDFException;

    public boolean DFSDpre32sdg(String filename, short ref, boolean ispre32) throws HDFException {
        int[] iv = new int[1];
        boolean rval = HDFDeprecated.DFSDpre32sdg(filename, ref, iv);
        ispre32 = iv[0] != 0;
        return rval;
    }

    public static native boolean DFSDpre32sdg(String var0, short var1, int[] var2) throws HDFException;

    public static native boolean DFSDputdata(String var0, int var1, int[] var2, byte[] var3) throws HDFException;

    public boolean DFSDputdata(String filename, int rank, int[] dimsizes, Object theData) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.byteify();
        return HDFDeprecated.DFSDputdata(filename, rank, dimsizes, data);
    }

    public static native boolean DFSDputslice(int[] var0, byte[] var1, int[] var2) throws HDFException;

    public boolean DFSDputslice(int[] windims, Object source, int[] dims) throws HDFException {
        HDFArray theArray = new HDFArray(source);
        byte[] data = theArray.byteify();
        return HDFDeprecated.DFSDputslice(windims, data, dims);
    }

    public static native boolean DFSDreadref(String var0, short var1) throws HDFException;

    public static native boolean DFSDreadslab(String var0, int[] var1, int[] var2, int[] var3, byte[] var4, int[] var5) throws HDFException;

    public boolean DFSDreadslab(String filename, int[] start, int[] slab_size, int[] stride, Object theData, int[] buffer_size) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.byteify();
        return HDFDeprecated.DFSDreadslab(filename, start, slab_size, stride, data, buffer_size);
    }

    public static native boolean DFSDrestart() throws HDFException;

    public static native boolean DFSDsetcal(double var0, double var2, double var4, double var6, int var8) throws HDFException;

    public static native boolean DFSDsetdatastrs(String var0, String var1, String var2, String var3) throws HDFException;

    public static native boolean DFSDsetdims(int var0, int[] var1) throws HDFException;

    public static native boolean DFSDsetdimscale(int var0, int var1, byte[] var2) throws HDFException;

    public boolean DFSDsetdimscale(int dim, int dimsize, Object theScale) throws HDFException {
        HDFArray theArray = new HDFArray(theScale);
        byte[] data = theArray.byteify();
        return HDFDeprecated.DFSDsetdimscale(dim, dimsize, data);
    }

    public static native boolean DFSDsetdimstrs(int var0, String var1, String var2, String var3) throws HDFException;

    public static native boolean DFSDsetfillvalue(Object var0) throws HDFException;

    public static native boolean DFSDsetlengths(int var0, int var1, int var2, int var3) throws HDFException;

    public static native boolean DFSDsetNT(int var0) throws HDFException;

    public static native boolean DFSDsetrange(byte[] var0, byte[] var1) throws HDFException;

    public boolean DFSDsetrange(Object max, Object min) throws HDFException {
        byte[] d1 = null;
        byte[] d2 = null;
        Class<?> mincl = min.getClass();
        String mncn = mincl.getName();
        Class<?> nc = mincl.getSuperclass();
        String s = nc.getName();
        if (!s.equals("java.lang.Number")) {
            return false;
        }
        Class<?> maxcl = max.getClass();
        String mxcn = maxcl.getName();
        nc = maxcl.getSuperclass();
        s = nc.getName();
        if (!s.equals("java.lang.Number")) {
            return false;
        }
        if (!mncn.equals(mxcn)) {
            return false;
        }
        System.out.println("DFSDsetrange: min,max are sub-class of Number ");
        if (mncn.equals("java.lang.Integer")) {
            Integer fmx = (Integer)max;
            Integer fmn = (Integer)min;
            d1 = HDFNativeData.intToByte((int)fmx);
            d2 = HDFNativeData.intToByte((int)fmn);
        } else if (mncn.equals("java.lang.Float")) {
            Float fmx = (Float)max;
            Float fmn = (Float)min;
            d1 = HDFNativeData.floatToByte(fmx.floatValue());
            d2 = HDFNativeData.floatToByte(fmn.floatValue());
        } else if (mncn.equals("java.lang.Double")) {
            Double fmx = (Double)max;
            Double fmn = (Double)min;
            d1 = HDFNativeData.doubleToByte((double)fmx);
            d2 = HDFNativeData.doubleToByte((double)fmn);
        } else if (mncn.equals("java.lang.Short")) {
            Short fmx = (Short)max;
            Short fmn = (Short)min;
            d1 = HDFNativeData.shortToByte((short)fmx);
            d2 = HDFNativeData.shortToByte((short)fmn);
        } else if (mncn.equals("java.lang.Byte")) {
            Byte fmx = (Byte)max;
            Byte fmn = (Byte)min;
            d1 = HDFNativeData.byteToByte((byte)fmx);
            d2 = HDFNativeData.byteToByte((byte)fmn);
        } else {
            return false;
        }
        return HDFDeprecated.DFSDsetrange(d1, d2);
    }

    public static native boolean DFSDstartslab(String var0) throws HDFException;

    public static native boolean DFSDstartslice(String var0) throws HDFException;

    public static native boolean DFSDwriteref(String var0, short var1) throws HDFException;

    public static native boolean DFSDwriteslab(int[] var0, int[] var1, int[] var2, byte[] var3) throws HDFException;

    public boolean DFSDwriteslab(int[] start, int[] stride, int[] count, Object theData) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.byteify();
        return HDFDeprecated.DFSDwriteslab(start, stride, count, data);
    }

    public static native boolean DFUfptoimage(int var0, int var1, float var2, float var3, float[] var4, float[] var5, float[] var6, byte[] var7, String var8, int var9, int var10, int var11, int var12) throws HDFException;

    public static native boolean Vclose(int var0) throws HDFException;

    public static native int Vopen(String var0, int var1, short var2) throws HDFException;

    public static native void VSdump(int var0) throws HDFException;

    public static native void HEprint(OutputStream var0, int var1) throws HDFException;

    static {
        String string = HDFLibrary.getJHIVersion();
        HDFLibrary.getJHIVersion();
    }
}

