/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import jams.model.Model;
import jams.tools.JAMSTools;
import java.util.ArrayList;
import java.util.List;
import org.unijena.j2k.J2KFunctions;

public class StandardEntityReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity parameter file name")
    public Attribute.String entityFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="entity collection")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Name of identifier", defaultValue="ID")
    public Attribute.String identName;

    public void init() {
        ArrayList collection = J2KFunctions.readParas((String)JAMSTools.CreateAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.entityFileName.getValue()), (Model)this.getModel());
        for (Attribute.Entity e : collection) {
            try {
                e.setId((long)e.getDouble(this.identName.getValue()));
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendErrorMsg("Couldn't find attribute \"" + this.identName + "\" while reading J2K HRU parameter file (" + this.entityFileName.getValue() + ")!");
            }
        }
        this.entities.setEntities((List)collection);
        int nEnt = this.entities.getEntityArray().length;
        this.getModel().getRuntime().println("Entities read and created successfull! (" + nEnt + ")", 1);
    }
}

