/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;

public class WeightedDistributedSumAggregator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Collection of entity objects")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="id of dst entity")
    public Attribute.Double entityID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute name of sum")
    public Attribute.String[] dstAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="")
    public Attribute.Double[] srcAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="weight value")
    public Attribute.Double weight;

    public void run() {
        int id = (int)this.entityID.getValue();
        Attribute.Entity entity = this.entities.getEntity((long)id);
        if (entity == null) {
            this.getModel().getRuntime().sendHalt("Entity " + id + " is not existing!");
            return;
        }
        if (this.srcAttribute.length != this.dstAttributeName.length) {
            this.getModel().getRuntime().sendHalt("Lengths of srcAttribute and dstAttribute differs!");
            return;
        }
        for (int i = 0; i < this.srcAttribute.length; ++i) {
            double value1 = entity.getDouble(this.dstAttributeName[i].getValue());
            double value2 = this.srcAttribute[i].getValue() / this.weight.getValue();
            entity.setDouble(this.dstAttributeName[i].getValue(), value1 + value2);
        }
    }
}

