/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Groundwater", author="Peter Krause", description="Description")
public class Groundwater
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="recision coefficient k")
    public Attribute.Double k;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="groundwater recharge")
    public Attribute.Double gwRecharge;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="groundwater storages")
    public Attribute.Double storage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="baseflow basQ")
    public Attribute.Double basQ;

    public void init() {
    }

    public void run() {
        double storage = this.storage.getValue();
        double input = this.gwRecharge.getValue();
        double outflow = 1.0 / this.k.getValue() * (storage += input);
        this.storage.setValue(storage -= outflow);
        this.basQ.setValue(outflow);
    }

    public void cleanup() {
    }
}

