/*
 * Decompiled with CFR 0.152.
 */
package ccindex.explorer.tree;

import ccindex.explorer.tree.DSTreeNode;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JAMSTree
extends JTree {
    private Insets autoscrollInsets = new Insets(20, 20, 20, 20);
    private Enumeration<TreePath> expandedPaths;

    public JAMSTree() {
        this.setAutoscrolls(true);
        this.setRootVisible(true);
        this.setShowsRootHandles(false);
        this.getSelectionModel().setSelectionMode(1);
        this.setSelectionRow(0);
        this.setCellRenderer(new JAMSTreeRenderer());
        this.setDragEnabled(true);
    }

    public void autoscroll(Point cursorLocation) {
        Insets insets = this.getAutoscrollInsets();
        Rectangle outer = this.getVisibleRect();
        Rectangle inner = new Rectangle(outer.x + insets.left, outer.y + insets.top, outer.width - (insets.left + insets.right), outer.height - (insets.top + insets.bottom));
        if (!inner.contains(cursorLocation)) {
            Rectangle scrollRect = new Rectangle(cursorLocation.x - insets.left, cursorLocation.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
            this.scrollRectToVisible(scrollRect);
        }
    }

    @Override
    public boolean isPathEditable(TreePath path) {
        return false;
    }

    public Insets getAutoscrollInsets() {
        return this.autoscrollInsets;
    }

    public void expandAll() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            this.expandRow(row);
        }
    }

    public void collapseAll() {
        for (int row = this.getRowCount() - 1; row > 0; --row) {
            this.collapseRow(row);
        }
    }

    public void saveExpandedState(TreePath sourcePath) {
        this.expandedPaths = this.getExpandedDescendants(sourcePath);
    }

    public void restoreExpandedState() {
        if (this.expandedPaths != null) {
            while (this.expandedPaths.hasMoreElements()) {
                TreePath tmpPath = this.expandedPaths.nextElement();
                this.expandPath(new TreePath(((DefaultMutableTreeNode)tmpPath.getLastPathComponent()).getPath()));
            }
        }
    }

    class JAMSTreeRenderer
    extends DefaultTreeCellRenderer {
        JAMSTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            TreeNode node = (TreeNode)value;
            if (node instanceof DSTreeNode) {
                DSTreeNode jNode = (DSTreeNode)node;
                this.setIcon(DSTreeNode.NODE_ICON[jNode.getType()]);
            }
            return this;
        }
    }
}

