/*
 * Decompiled with CFR 0.152.
 */
package ccindex.explorer.spreadsheet;

import ccindex.explorer.spreadsheet.GraphProperties;
import ccindex.explorer.spreadsheet.JTSConfigurator;
import ccindex.explorer.spreadsheet.JXYConfigurator;
import ccindex.explorer.spreadsheet.STPConfigurator;
import jams.JAMS;
import jams.gui.tools.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PropertyPanel {
    JFrame parent;
    ImageIcon up_icon = JAMS.getScaledIcon("ccindex/explorer/resources/images/arrowup.png", 6, 6);
    ImageIcon down_icon = JAMS.getScaledIcon("ccindex/explorer/resources/images/arrowdown.png", 6, 6);
    ImageIcon plot_icon = JAMS.getIcon("ccindex/explorer/resources/images/correct.png");
    ImageIcon add_icon = JAMS.getIcon("ccindex/explorer/resources/images/add.png");
    ImageIcon rem_icon = JAMS.getScaledIcon("ccindex/explorer/resources/images/remove.png", 8, 8);
    JScrollPane scpane;
    int index = 0;
    int plotType;
    String legendName;
    int color;
    String name;
    int position;
    int type;
    int[] d_range = new int[2];
    boolean is_x_series = false;
    boolean result = false;
    boolean x_changed;
    JComboBox setColumn;
    JComboBox colorchoice;
    JComboBox typechoice;
    JComboBox poschoice;
    JComboBox timechoice_START;
    JComboBox timechoice_END;
    JTextField datachoice_START;
    JTextField datachoice_END;
    JPanel datachoice_panel;
    JButton datachoice_max;
    JButton addButton;
    JButton remButton;
    JButton plotButton;
    JButton upButton;
    JButton downButton;
    JButton customizeButton;
    JCheckBox invBox;
    JToggleButton isXAxis;
    JLabel nameLabel;
    JTextField setName;
    JLabel setLegend;
    JTSConfigurator ctsconf;
    JXYConfigurator cxyconf;
    STPConfigurator stpconf;
    private String[] colors = new String[]{"red", "blue", "green", "black", "magenta", "cyan", "yellow", "gray", "orange", "lightgray", "pink"};
    private String[] types = new String[]{JAMS.i18n("LINE"), JAMS.i18n("BAR"), JAMS.i18n("LINE_AND_SHAPE"), "Area", "Line and Base", "Dot", "Step", "StepArea", "Difference"};
    private String[] positions = new String[]{JAMS.i18n("LEFT"), JAMS.i18n("RIGHT")};
    JPanel graphpanel = new JPanel();
    JPanel datapanel = new JPanel();
    JPanel buttonpanel = new JPanel();
    Stroke series_stroke;
    Shape series_shape;
    Color series_paint;
    Stroke series_outline_stroke;
    Color series_outline_paint;
    Color series_fill_paint;
    JLabel colorlabel;
    JLabel scolorlabel;
    boolean outlineVisible;
    boolean linesVisible;
    boolean shapesVisible;
    HashMap<String, Color> colorTable = new HashMap();
    CustomizeRendererDlg cr_dlg;
    String[] headers;
    int columnCount = 0;
    int rowCount = 0;
    GraphProperties prop;
    MouseAdapter timeListener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent me) {
            PropertyPanel.this.prop.setTimeSTART(PropertyPanel.this.timechoice_START.getSelectedIndex());
            PropertyPanel.this.prop.setTimeEND(PropertyPanel.this.timechoice_END.getSelectedIndex());
        }

        @Override
        public void mousePressed(MouseEvent me) {
            PropertyPanel.this.prop.setTimeSTART(PropertyPanel.this.timechoice_START.getSelectedIndex());
            PropertyPanel.this.prop.setTimeEND(PropertyPanel.this.timechoice_END.getSelectedIndex());
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            PropertyPanel.this.prop.setTimeSTART(PropertyPanel.this.timechoice_START.getSelectedIndex());
            PropertyPanel.this.prop.setTimeEND(PropertyPanel.this.timechoice_END.getSelectedIndex());
        }
    };
    ActionListener timeListener2 = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PropertyPanel.this.prop.setTimeSTART(PropertyPanel.this.timechoice_START.getSelectedIndex());
            PropertyPanel.this.prop.setTimeEND(PropertyPanel.this.timechoice_END.getSelectedIndex());
        }
    };
    ActionListener rendererListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            if (PropertyPanel.this.plotType == 0) {
                PropertyPanel.this.prop.setPosition(PropertyPanel.this.poschoice.getSelectedIndex());
                PropertyPanel.this.ctsconf.handleRenderer();
            }
            if (PropertyPanel.this.plotType == 1) {
                PropertyPanel.this.prop.setPosition(PropertyPanel.this.poschoice.getSelectedIndex());
                PropertyPanel.this.cxyconf.handleRenderer();
            }
        }
    };
    ActionListener addListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            if (PropertyPanel.this.plotType == 0) {
                PropertyPanel.this.ctsconf.addGraph(PropertyPanel.this.prop);
            }
            if (PropertyPanel.this.plotType == 1) {
                PropertyPanel.this.cxyconf.addGraph(PropertyPanel.this.prop);
            }
        }
    };
    ActionListener removeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            if (PropertyPanel.this.plotType == 0) {
                PropertyPanel.this.ctsconf.removeGraph(PropertyPanel.this.prop);
            }
            if (PropertyPanel.this.plotType == 1) {
                PropertyPanel.this.cxyconf.removeGraph(PropertyPanel.this.prop);
            }
        }
    };
    ActionListener upListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            if (PropertyPanel.this.plotType == 0) {
                PropertyPanel.this.ctsconf.upGraph(PropertyPanel.this.prop);
            }
            if (PropertyPanel.this.plotType == 1) {
                PropertyPanel.this.cxyconf.upGraph(PropertyPanel.this.prop);
            }
        }
    };
    ActionListener downListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            if (PropertyPanel.this.plotType == 0) {
                PropertyPanel.this.ctsconf.downGraph(PropertyPanel.this.prop);
            }
            if (PropertyPanel.this.plotType == 1) {
                PropertyPanel.this.cxyconf.downGraph(PropertyPanel.this.prop);
            }
        }
    };
    ActionListener isXListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent xe) {
            PropertyPanel.this.cxyconf.xChanged(PropertyPanel.this.prop);
            PropertyPanel.this.cxyconf.setMaxDataIntervals(PropertyPanel.this.prop);
            PropertyPanel.this.updateGUI();
        }
    };
    ItemListener endListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent xe) {
        }
    };
    ActionListener max_listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent me) {
            PropertyPanel.this.cxyconf.setMaxDataIntervals(PropertyPanel.this.prop);
            PropertyPanel.this.updateGUI();
        }
    };
    ActionListener columnChangedListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent me) {
            String name = (String)PropertyPanel.this.setColumn.getSelectedItem();
            PropertyPanel.this.prop.setName(name);
            PropertyPanel.this.prop.setSelectedColumn(PropertyPanel.this.setColumn.getSelectedIndex());
            PropertyPanel.this.setLegend.setText(name);
            PropertyPanel.this.cr_dlg.setLegendField(name);
            PropertyPanel.this.cr_dlg.setNameLabel(name);
        }
    };
    ActionListener customize_listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent me) {
            PropertyPanel.this.cr_dlg.handleGUI();
            PropertyPanel.this.cr_dlg.updateName(PropertyPanel.this.prop.getName());
            PropertyPanel.this.cr_dlg.setVisible(true);
        }
    };
    ActionListener dataSTARTListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PropertyPanel.this.datachoice_START.selectAll();
        }
    };
    ActionListener dataENDListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PropertyPanel.this.datachoice_END.selectAll();
        }
    };
    MouseAdapter column_listener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent me) {
            PropertyPanel.this.prop.setSelectedColumn(PropertyPanel.this.setColumn.getSelectedIndex());
        }
    };
    DocumentListener d_start_listener = new DocumentListener(){
        double d_start;

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.changeValue();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changeValue();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changeValue();
        }

        private void changeValue() {
            try {
                this.d_start = new Double(PropertyPanel.this.datachoice_START.getText());
            }
            catch (NumberFormatException nfe) {
                this.d_start = 0.0;
            }
            PropertyPanel.this.prop.setDataSTART(this.d_start);
            PropertyPanel.this.cxyconf.dStartChanged(true);
        }
    };
    DocumentListener d_end_listener = new DocumentListener(){
        double d_end;

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.changeValue();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changeValue();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changeValue();
        }

        private void changeValue() {
            try {
                this.d_end = new Double(PropertyPanel.this.datachoice_END.getText());
            }
            catch (NumberFormatException nfe) {
                this.d_end = 0.0;
            }
            PropertyPanel.this.prop.setDataEND(this.d_end);
            PropertyPanel.this.cxyconf.dEndChanged(true);
        }
    };

    public PropertyPanel(JTSConfigurator ctsconf, GraphProperties prop) {
        this.parent = ctsconf;
        this.ctsconf = ctsconf;
        this.prop = prop;
        this.plotType = 0;
        this.timechoice_START = new JComboBox<String>(prop.getTimeIntervals());
        this.timechoice_START.setPreferredSize(new Dimension(40, 14));
        this.timechoice_START.addMouseListener(this.timeListener);
        this.timechoice_START.addActionListener(this.timeListener2);
        this.timechoice_END = new JComboBox<String>(prop.getTimeIntervals());
        this.timechoice_END.setPreferredSize(new Dimension(40, 14));
        this.timechoice_END.addMouseListener(this.timeListener);
        this.timechoice_END.addActionListener(this.timeListener2);
        this.createPanel();
        this.updateGUI();
    }

    public PropertyPanel(JXYConfigurator cxyconf, GraphProperties prop) {
        this.parent = cxyconf;
        this.cxyconf = cxyconf;
        this.prop = prop;
        this.plotType = prop.getPlotType();
        this.datachoice_panel = new JPanel();
        this.datachoice_panel.setLayout(new FlowLayout());
        this.datachoice_panel.setSize(20, 50);
        this.datachoice_max = new JButton("max");
        this.datachoice_max.addActionListener(this.max_listener);
        this.datachoice_START = new JTextField();
        this.datachoice_START.setHorizontalAlignment(4);
        this.datachoice_START.setPreferredSize(new Dimension(40, 14));
        this.datachoice_START.addActionListener(this.dataSTARTListener);
        this.datachoice_START.getDocument().addDocumentListener(this.d_start_listener);
        this.datachoice_END = new JTextField();
        this.datachoice_END.setPreferredSize(new Dimension(40, 14));
        this.datachoice_END.setHorizontalAlignment(4);
        this.datachoice_END.addActionListener(this.dataENDListener);
        this.datachoice_END.getDocument().addDocumentListener(this.d_end_listener);
        this.datachoice_panel.add(this.datachoice_END);
        this.datachoice_panel.add(this.datachoice_max);
        this.createPanel();
        this.updateGUI();
    }

    public void createPanel() {
        this.addButton = new JButton();
        this.remButton = new JButton();
        this.plotButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.customizeButton = new JButton(JAMS.i18n("CUSTOMIZE"));
        this.upButton.setIcon(this.up_icon);
        this.downButton.setIcon(this.down_icon);
        this.plotButton.setIcon(this.plot_icon);
        this.addButton.setIcon(this.add_icon);
        this.remButton.setIcon(this.rem_icon);
        this.plotButton.setToolTipText(JAMS.i18n("PLOT_GRAPH"));
        this.upButton.setToolTipText(JAMS.i18n("MOVE_UP"));
        this.downButton.setToolTipText(JAMS.i18n("MOVE_DOWN"));
        this.addButton.setToolTipText(JAMS.i18n("ADD_GRAPH"));
        this.remButton.setToolTipText(JAMS.i18n("REMOVE_BUTTON"));
        this.isXAxis = new JRadioButton(JAMS.i18n("SET_X"));
        this.isXAxis.addActionListener(this.isXListener);
        this.addButton.setBorder(new SoftBevelBorder(0));
        this.addButton.setPreferredSize(new Dimension(20, 14));
        this.addButton.addActionListener(this.addListener);
        this.remButton.addActionListener(this.removeListener);
        this.upButton.addActionListener(this.upListener);
        this.downButton.addActionListener(this.downListener);
        this.customizeButton.addActionListener(this.customize_listener);
        this.remButton.setPreferredSize(new Dimension(20, 14));
        this.upButton.setPreferredSize(new Dimension(20, 14));
        this.plotButton.setPreferredSize(new Dimension(20, 14));
        this.downButton.setPreferredSize(new Dimension(20, 14));
        this.colorchoice = new JComboBox<String>(this.colors);
        this.colorchoice.setPreferredSize(new Dimension(40, 14));
        this.colorchoice.setSelectedIndex(0);
        this.typechoice = new JComboBox<String>(this.types);
        this.typechoice.setPreferredSize(new Dimension(40, 14));
        this.typechoice.setSelectedIndex(0);
        this.poschoice = new JComboBox<String>(this.positions);
        this.poschoice.setPreferredSize(new Dimension(40, 14));
        this.poschoice.setSelectedIndex(0);
        this.poschoice.addActionListener(this.rendererListener);
        JButton okButton = new JButton(JAMS.i18n("OK"));
        JButton cancelButton = new JButton(JAMS.i18n("CANCEL"));
        this.nameLabel = new JLabel();
        this.setLegend = new JLabel(this.name);
        this.setColumn = new JComboBox<String>(this.prop.getColumns());
        this.setColumn.setPreferredSize(new Dimension(40, 14));
        this.setColumn.setSelectedIndex(this.prop.getSelectedColumn());
        this.nameLabel.setText(this.prop.getColumns()[this.prop.getSelectedColumn()]);
        this.setName = new JTextField(this.name, 14);
        this.setName.setPreferredSize(new Dimension(40, 14));
        this.setLegend.setPreferredSize(new Dimension(40, 14));
        this.datapanel.setLayout(new FlowLayout());
        this.graphpanel.setLayout(new FlowLayout());
        this.graphpanel.add(this.setColumn);
        this.graphpanel.add(this.poschoice);
        this.graphpanel.add(this.typechoice);
        this.graphpanel.add(this.colorchoice);
        this.datapanel.add(this.nameLabel);
        this.buttonpanel.add(okButton);
        this.buttonpanel.add(cancelButton);
        this.cr_dlg = new CustomizeRendererDlg(this.prop.getName());
        this.setColumn.addActionListener(this.columnChangedListener);
        this.colorlabel = new JLabel("      ");
        this.colorlabel.setOpaque(true);
        this.colorlabel.setBackground(this.prop.getSeriesPaint());
        this.scolorlabel = new JLabel("");
        this.scolorlabel.setOpaque(false);
        this.scolorlabel.setBackground(this.prop.getSeriesPaint());
    }

    private void updateGUI() {
        this.setLegendField(this.prop.getLegendName());
        if (this.plotType == 0) {
            int start = this.prop.getTimeSTART();
            int end = this.prop.getTimeEND();
            this.setTimeSTART(start);
            this.setTimeEND(end);
        }
        if (this.plotType == 1 && this.prop.isXSeries()) {
            this.isXAxis.setSelected(true);
            this.setDataSTART(this.prop.getDataSTART());
            this.setDataEND(this.prop.getDataEND());
        }
        this.setPosition(this.prop.getPosition());
        this.setColorLabelColor();
        this.setSColorLabelColor();
        this.setLegendField(this.prop.getLegendName());
        this.setLegend.setText(this.prop.getLegendName());
        this.setLinesVisBox(this.prop.getLinesVisible());
        this.setShapesVisBox(this.prop.getShapesVisible());
        this.setStrokeSlider(this.prop.getStrokeType());
        this.setShapeSlider(this.prop.getSizeType());
        this.setOutlineSlider(this.prop.getOutlineType());
        this.setShapeBox(this.prop.getShapeType());
        this.cr_dlg.setNameLabel(this.name);
    }

    public void setColorLabelColor() {
        if (this.prop.getPlotType() == 1) {
            if (this.prop.getShapesVisible() && this.cxyconf.getRendererLeft() == 0 && this.prop.getPosition() == 0 || this.cxyconf.getRendererRight() == 0 && this.prop.getPosition() == 1) {
                this.colorlabel.setBackground(this.prop.getSeriesFillPaint());
            } else {
                this.colorlabel.setBackground(this.prop.getSeriesPaint());
            }
        }
        if (this.prop.getPlotType() == 0) {
            if (this.prop.getShapesVisible() && this.ctsconf.getRendererLeft() == 0 && this.prop.getPosition() == 0 || this.ctsconf.getRendererRight() == 0 && this.prop.getPosition() == 1) {
                this.colorlabel.setBackground(this.prop.getSeriesFillPaint());
            } else {
                this.colorlabel.setBackground(this.prop.getSeriesPaint());
            }
        }
    }

    public void setSColorLabelColor() {
        this.scolorlabel.setBackground(this.prop.getSeriesFillPaint());
    }

    public JPanel getGraphPanel() {
        return this.datapanel;
    }

    public void setXChanged(boolean state) {
        this.x_changed = state;
    }

    public void setLegendField(String s) {
        this.cr_dlg.setLegendField(s);
    }

    public void setPosition(int position) {
        this.position = position;
        this.poschoice.setSelectedItem(position);
    }

    public void setTimeSTART(int index) {
        this.timechoice_START.setSelectedIndex(index);
    }

    public void setTimeEND(int index) {
        this.timechoice_END.setSelectedIndex(index);
    }

    public void setDataSTART(double d_start) {
        String f_string = d_start > 100.0 ? "%3.0f" : "%3.2f";
        String s = String.format(Locale.US, f_string, d_start);
        this.datachoice_START.setText(s);
    }

    public void setDataEND(double d_end) {
        String f_string = d_end > 100.0 ? "%3.0f" : "%3.2f";
        String s = String.format(Locale.US, f_string, d_end);
        this.datachoice_END.setText(s);
    }

    private double readDataSTART() {
        String text = this.datachoice_START.getText();
        double d_start = new Double(text);
        return d_start;
    }

    private double readDataEND() {
        double d_end = new Double(this.datachoice_END.getText());
        return d_end;
    }

    public boolean axisInverted() {
        return this.invBox.isSelected();
    }

    public JCheckBox getInvBox() {
        return this.invBox;
    }

    public JToggleButton getIsXAxisButton() {
        return this.isXAxis;
    }

    public JLabel getNameLabel() {
        return this.nameLabel;
    }

    public JComboBox getPosChoice() {
        return this.poschoice;
    }

    public JComboBox getTypeChoice() {
        return this.typechoice;
    }

    public JComboBox getColorChoice() {
        return this.colorchoice;
    }

    public JLabel getLegendLabel() {
        return this.setLegend;
    }

    public JComboBox getDataChoice() {
        return this.setColumn;
    }

    public JComboBox getTimeChoiceSTART() {
        return this.timechoice_START;
    }

    public JComboBox getTimeChoiceEND() {
        return this.timechoice_END;
    }

    public JTextField getDataChoiceSTART() {
        return this.datachoice_START;
    }

    public JTextField getDataChoiceEND() {
        return this.datachoice_END;
    }

    public JButton getMaxButton() {
        return this.datachoice_max;
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    public JButton getRemButton() {
        return this.remButton;
    }

    public JButton getUpButton() {
        return this.upButton;
    }

    public JButton getDownButton() {
        return this.downButton;
    }

    public JButton getPlotButton() {
        return this.plotButton;
    }

    public JButton getCustomizeButton() {
        return this.customizeButton;
    }

    public JLabel getColorLabel() {
        return this.colorlabel;
    }

    public JLabel getSColorLabel() {
        return this.scolorlabel;
    }

    public void setSeriesPaint(Color paint) {
        this.series_paint = paint;
        this.cr_dlg.setStrokeButtonColor(paint);
    }

    public void setSeriesFillPaint(Color fill) {
        this.series_fill_paint = fill;
        this.cr_dlg.setFillButtonColor(fill);
    }

    public void setSeriesOutlinePaint(Color out) {
        this.series_outline_paint = out;
        this.cr_dlg.setOutlineButtonColor(out);
    }

    private void drawLegendItem() {
        JPanel pane = new JPanel();
        pane.setSize(20, 20);
    }

    public void setOutlineSlider(int value) {
        this.cr_dlg.setOutlineSlider(value);
    }

    public void setStrokeSlider(int value) {
        this.cr_dlg.setStrokeSlider(value);
    }

    public void setShapeSlider(int value) {
        this.cr_dlg.setShapeSlider(value);
    }

    public void setShapesVisBox(boolean state) {
        this.cr_dlg.setShapesVisBox(state);
    }

    public void setLinesVisBox(boolean state) {
        this.cr_dlg.setLinesVisBox(state);
    }

    public void setShapeBox(int index) {
        this.cr_dlg.setShapeBox(index);
    }

    public class ColorLabel
    extends JLabel {
        Color shape_fill;
        Color outline_color;
        Color line_color;
        Shape shape;

        public ColorLabel(Color shape_fill, Color outline_color, Shape shape) {
            this.shape_fill = shape_fill;
            this.outline_color = outline_color;
            this.shape = shape;
        }

        public void paint(Graphics2D g) {
            g.setColor(this.shape_fill);
            g.fill(this.shape);
            g.setColor(this.outline_color);
            g.draw(this.shape);
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, 15, 15);
        }

        public void setSymbol(Shape shape, Color shape_fill, Color outline_color) {
            this.shape_fill = shape_fill;
            this.outline_color = outline_color;
            this.shape = shape;
        }
    }

    public class ColorButton
    extends JButton {
        Color color;

        public ColorButton(Color color) {
            this.color = color;
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(this.color);
            g.fillRect(1, 1, 14, 14);
            g.setColor(Color.DARK_GRAY);
            g.drawRect(0, 0, 15, 15);
        }

        public void setColor(Color newColor) {
            this.color = newColor;
        }
    }

    private class CustomizeRendererDlg
    extends JDialog {
        boolean result;
        int max;
        String side;
        int side_index;
        int position;
        JDialog thiscrd;
        JPanel optionspanel;
        JPanel colorpanel;
        JPanel buttonpanel;
        JPanel namepanel;
        Color line_color;
        Color shape_fill;
        Color outline_color;
        JLabel renderer_label;
        JLabel stroke_label;
        JLabel shape_label;
        JLabel paint_label;
        JLabel outline_stroke_label;
        JLabel outline_paint_label;
        JLabel lines_visible_label;
        JLabel shapes_visible_label;
        JLabel fill_label;
        JLabel shape_size_label;
        JLabel setLegendLabel;
        JLabel nameLabel;
        JTextField setLegendField;
        JComboBox renderer_box;
        JComboBox stroke_box;
        JComboBox shape_box;
        JComboBox paint_box;
        JComboBox outline_stroke_box;
        JComboBox outline_paint_box;
        JComboBox fill_box;
        JCheckBox shapes_vis_box;
        JCheckBox lines_vis_box;
        JComboBox shape_size_box;
        JSlider stroke_slider;
        JSlider shape_slider;
        JSlider outline_slider;
        JSeparator divider;
        JButton stroke_button;
        JButton fill_button;
        JButton outline_button;
        JButton ok_button;
        JButton apply_button;
        final String[] SHAPES;
        final String[] COLORS;
        final String[] SHAPE_COLORS;
        final String[] RENDERER;
        final int MIN = 0;
        final int MAX = 12;
        final int STROKE = 2;
        final int SHAPE = 5;
        final int OUTLINE = 1;
        MouseAdapter stroke_slider_listener;
        MouseAdapter shape_listener;
        ActionListener shape_listener2;
        MouseAdapter outline_stroke_listener;
        KeyAdapter legend_listener;
        ActionListener lines_visible_listener;
        ActionListener shapes_visible_listener;
        ActionListener ok;
        ActionListener apply;
        ActionListener stroke_button_listener;
        ActionListener fill_button_listener;
        ActionListener outline_button_listener;
        ActionListener cancel;

        public CustomizeRendererDlg(String series_name) {
            super(PropertyPanel.this.parent, JAMS.i18n("CUSTOMIZE_RENDERER"), true);
            this.result = false;
            this.thiscrd = this;
            this.SHAPES = new String[]{JAMS.i18n("SQUARE"), JAMS.i18n("CIRCLE"), JAMS.i18n("TRIANGLE_UP"), JAMS.i18n("TRIANGLE_DOWN"), JAMS.i18n("DIAMOND"), JAMS.i18n("CROSS_DIAGONAL"), JAMS.i18n("CROSS_REGULAR")};
            this.COLORS = new String[]{"custom", "red", "blue", "green", "black", "magenta", "cyan", "yellow", "gray", "orange", "lightgray", "pink"};
            this.SHAPE_COLORS = new String[]{"custom", "white", "red", "blue", "green", "black", "magenta", "cyan", "yellow", "gray", "orange", "lightgray", "pink"};
            this.RENDERER = new String[]{"Line and Shape", "Bar", "Area", "Step", "StepArea", "Difference"};
            this.MIN = 0;
            this.MAX = 12;
            this.STROKE = 2;
            this.SHAPE = 5;
            this.OUTLINE = 1;
            this.stroke_slider_listener = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent me) {
                    PropertyPanel.this.prop.setStroke(CustomizeRendererDlg.this.stroke_slider.getValue());
                }
            };
            this.shape_listener = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent me) {
                    PropertyPanel.this.prop.setShape(CustomizeRendererDlg.this.shape_box.getSelectedIndex(), CustomizeRendererDlg.this.shape_slider.getValue());
                }
            };
            this.shape_listener2 = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertyPanel.this.prop.setShape(CustomizeRendererDlg.this.shape_box.getSelectedIndex(), CustomizeRendererDlg.this.shape_slider.getValue());
                }
            };
            this.outline_stroke_listener = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent me) {
                    PropertyPanel.this.prop.setOutlineStroke(CustomizeRendererDlg.this.outline_slider.getValue());
                }
            };
            this.legend_listener = new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent ke) {
                    PropertyPanel.this.prop.setLegendName(CustomizeRendererDlg.this.setLegendField.getText());
                    PropertyPanel.this.setLegend.setText(CustomizeRendererDlg.this.setLegendField.getText());
                }

                @Override
                public void keyReleased(KeyEvent ke) {
                    PropertyPanel.this.prop.setLegendName(CustomizeRendererDlg.this.setLegendField.getText());
                    PropertyPanel.this.setLegend.setText(CustomizeRendererDlg.this.setLegendField.getText());
                }
            };
            this.lines_visible_listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertyPanel.this.prop.setLinesVisible(CustomizeRendererDlg.this.lines_vis_box.isSelected());
                }
            };
            this.shapes_visible_listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertyPanel.this.prop.setShapesVisible(CustomizeRendererDlg.this.shapes_vis_box.isSelected());
                }
            };
            this.ok = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomizeRendererDlg.this.setVisible(false);
                    CustomizeRendererDlg.this.updateColors();
                    PropertyPanel.this.setColorLabelColor();
                    PropertyPanel.this.setSColorLabelColor();
                }
            };
            this.apply = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomizeRendererDlg.this.updateColors();
                    PropertyPanel.this.setColorLabelColor();
                    PropertyPanel.this.setSColorLabelColor();
                    if (PropertyPanel.this.ctsconf != null) {
                        PropertyPanel.this.ctsconf.plotAllGraphs();
                    }
                    if (PropertyPanel.this.cxyconf != null) {
                        PropertyPanel.this.cxyconf.plotAllGraphs();
                    }
                }
            };
            this.stroke_button_listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color new_line_color = JColorChooser.showDialog(CustomizeRendererDlg.this.thiscrd, "Choose Line Color", CustomizeRendererDlg.this.line_color);
                    if (new_line_color != null) {
                        CustomizeRendererDlg.this.line_color = new_line_color;
                    }
                    PropertyPanel.this.prop.setSeriesPaint(CustomizeRendererDlg.this.line_color);
                    CustomizeRendererDlg.this.stroke_button.setBackground(CustomizeRendererDlg.this.line_color);
                }
            };
            this.fill_button_listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color new_shape_fill = JColorChooser.showDialog(CustomizeRendererDlg.this.thiscrd, "Choose Shape Color", CustomizeRendererDlg.this.shape_fill);
                    if (new_shape_fill != null) {
                        CustomizeRendererDlg.this.shape_fill = new_shape_fill;
                    }
                    PropertyPanel.this.prop.setSeriesFillPaint(CustomizeRendererDlg.this.shape_fill);
                    CustomizeRendererDlg.this.fill_button.setBackground(CustomizeRendererDlg.this.shape_fill);
                }
            };
            this.outline_button_listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color new_outline_color = JColorChooser.showDialog(CustomizeRendererDlg.this.thiscrd, "Choose Outline Color", CustomizeRendererDlg.this.outline_color);
                    if (new_outline_color != null) {
                        CustomizeRendererDlg.this.outline_color = new_outline_color;
                    }
                    PropertyPanel.this.prop.setSeriesOutlinePaint(CustomizeRendererDlg.this.outline_color);
                    CustomizeRendererDlg.this.outline_button.setBackground(CustomizeRendererDlg.this.outline_color);
                }
            };
            this.cancel = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomizeRendererDlg.this.setVisible(false);
                }
            };
            Point parentloc = PropertyPanel.this.parent.getLocation();
            this.setLocation(parentloc.x + 50, parentloc.y + 50);
            try {
                this.line_color = PropertyPanel.this.prop.getSeriesPaint();
                this.shape_fill = PropertyPanel.this.prop.getSeriesFillPaint();
                this.outline_color = PropertyPanel.this.prop.getSeriesOutlinePaint();
            }
            catch (Exception cce) {
                this.line_color = Color.RED;
                this.shape_fill = Color.RED;
                this.outline_color = Color.GRAY;
            }
            this.createPanel();
        }

        public void updateName(String name) {
            this.nameLabel.setText(name);
        }

        public void updateColors() {
            this.line_color = PropertyPanel.this.prop.getSeriesPaint();
            this.shape_fill = PropertyPanel.this.prop.getSeriesFillPaint();
            this.outline_color = PropertyPanel.this.prop.getSeriesOutlinePaint();
            this.stroke_button.setBackground(this.line_color);
            this.fill_button.setBackground(this.shape_fill);
            this.outline_button.setBackground(this.outline_color);
        }

        public void setStrokeButtonColor(Color lc) {
            this.stroke_button.setBackground(lc);
        }

        public void setFillButtonColor(Color fc) {
            this.fill_button.setBackground(fc);
        }

        public void setOutlineButtonColor(Color oc) {
            this.outline_button.setBackground(oc);
        }

        public void setOutlineSlider(int value) {
            this.outline_slider.setValue(value);
        }

        public void setStrokeSlider(int value) {
            this.stroke_slider.setValue(value);
        }

        public void setShapeSlider(int value) {
            this.shape_slider.setValue(value);
        }

        public void setShapesVisBox(boolean state) {
            this.shapes_vis_box.setSelected(state);
        }

        public void setLinesVisBox(boolean state) {
            this.lines_vis_box.setSelected(state);
        }

        public void setShapeBox(int index) {
            this.shape_box.setSelectedIndex(index);
        }

        public void setLegendField(String legendName) {
            this.setLegendField.setText(legendName);
        }

        void createPanel() {
            this.optionspanel = new JPanel();
            this.colorpanel = new JPanel();
            this.buttonpanel = new JPanel();
            this.namepanel = new JPanel();
            GridBagLayout gbl = new GridBagLayout();
            BorderLayout brl = new BorderLayout();
            GridBagLayout option_gbl = new GridBagLayout();
            GridBagLayout button_gbl = new GridBagLayout();
            this.setLayout(brl);
            this.optionspanel.setLayout(option_gbl);
            this.ok_button = new JButton(JAMS.i18n("CLOSE"));
            this.ok_button.addActionListener(this.ok);
            this.apply_button = new JButton(JAMS.i18n("APPLY"));
            this.apply_button.addActionListener(this.apply);
            this.paint_label = new JLabel(JAMS.i18n("COLOR:"));
            this.stroke_label = new JLabel(JAMS.i18n("STROKE:"));
            this.nameLabel = new JLabel(PropertyPanel.this.prop.getName());
            this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(1));
            this.shape_label = new JLabel(JAMS.i18n("SHAPE:"));
            this.shape_box = new JComboBox<String>(this.SHAPES);
            this.shape_box.setSelectedIndex(PropertyPanel.this.prop.getShapeType());
            this.shape_box.addActionListener(this.shape_listener2);
            this.shape_box.addMouseListener(this.shape_listener);
            this.outline_stroke_label = new JLabel(JAMS.i18n("OUTLINE_STROKE:"));
            this.outline_paint_label = new JLabel(JAMS.i18n("OUTLINE_COLOR:"));
            this.outline_paint_box = new JComboBox<String>(this.SHAPE_COLORS);
            this.outline_paint_box.setSelectedIndex(PropertyPanel.this.prop.getShapeType());
            this.fill_label = new JLabel(JAMS.i18n("COLOR:"));
            this.fill_box = new JComboBox<String>(this.SHAPE_COLORS);
            this.fill_box.setSelectedIndex(2);
            this.setLegendLabel = new JLabel(JAMS.i18n("LEGEND_NAME:"));
            this.setLegendField = new JTextField();
            this.shape_size_label = new JLabel(JAMS.i18n("SIZE"));
            this.lines_visible_label = new JLabel(JAMS.i18n("LINES"));
            this.lines_vis_box = new JCheckBox();
            this.lines_vis_box.setSelected(PropertyPanel.this.prop.getLinesVisible());
            this.shapes_visible_label = new JLabel(JAMS.i18n("SHAPES"));
            this.shapes_vis_box = new JCheckBox();
            this.shapes_vis_box.setSelected(PropertyPanel.this.prop.getLinesVisible());
            this.stroke_slider = new JSlider(0, 0, 12, 2);
            this.shape_slider = new JSlider(0, 1, 12, 5);
            this.outline_slider = new JSlider(0, 0, 12, 1);
            this.stroke_slider.setMajorTickSpacing(4);
            this.stroke_slider.setMinorTickSpacing(1);
            this.stroke_slider.setPaintTicks(true);
            this.stroke_slider.setPaintLabels(true);
            this.stroke_slider.setSnapToTicks(true);
            this.shape_slider.setMajorTickSpacing(4);
            this.shape_slider.setMinorTickSpacing(1);
            this.shape_slider.setPaintTicks(true);
            this.shape_slider.setPaintLabels(true);
            this.shape_slider.setSnapToTicks(true);
            this.outline_slider.setMajorTickSpacing(4);
            this.outline_slider.setMinorTickSpacing(1);
            this.outline_slider.setPaintTicks(true);
            this.outline_slider.setPaintLabels(true);
            this.outline_slider.setSnapToTicks(true);
            this.divider = new JSeparator(1);
            this.stroke_button = new JButton(JAMS.i18n("COLOR"));
            this.fill_button = new JButton(JAMS.i18n("COLOR"));
            this.outline_button = new JButton(JAMS.i18n("COLOR"));
            this.stroke_button.setBackground(this.line_color);
            this.fill_button.setBackground(this.shape_fill);
            this.outline_button.setBackground(this.outline_color);
            this.stroke_button.setSize(15, 15);
            this.fill_button.setSize(15, 15);
            this.outline_button.setSize(15, 15);
            this.stroke_button.addActionListener(this.stroke_button_listener);
            this.fill_button.addActionListener(this.fill_button_listener);
            this.outline_button.addActionListener(this.outline_button_listener);
            this.lines_vis_box.addActionListener(this.lines_visible_listener);
            this.shapes_vis_box.addActionListener(this.shapes_visible_listener);
            this.stroke_slider.addMouseListener(this.stroke_slider_listener);
            this.shape_slider.addMouseListener(this.shape_listener);
            this.outline_slider.addMouseListener(this.outline_stroke_listener);
            this.setLegendField.addKeyListener(this.legend_listener);
            this.shape_box.addMouseListener(this.shape_listener);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, new JLabel(JAMS.i18n("LINE")), 0, 0, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, new JLabel(JAMS.i18n("SYMBOL")), 4, 0, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, this.stroke_label, 0, 1, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, this.stroke_slider, 1, 1, 1, 2, 0.0, 0.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, this.paint_label, 0, 3, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, this.stroke_button, 1, 3, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, this.lines_visible_label, 0, 4, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, this.lines_vis_box, 1, 4, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, this.shapes_visible_label, 0, 5, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, this.shapes_vis_box, 1, 5, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, this.setLegendLabel, 0, 6, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, this.setLegendField, 1, 6, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, this.divider, 2, 1, 1, 8, 1.0, 1.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, this.shape_label, 4, 1, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, this.shape_box, 5, 1, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, this.shape_size_label, 4, 2, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, this.shape_slider, 5, 2, 1, 2, 0.0, 0.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, this.fill_label, 4, 4, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, this.fill_button, 5, 4, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, this.outline_stroke_label, 4, 5, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, this.outline_slider, 5, 5, 1, 2, 0.0, 0.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, this.outline_paint_label, 4, 7, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this.optionspanel, option_gbl, this.outline_button, 5, 7, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this.buttonpanel, button_gbl, this.ok_button, 0, 0, 1, 1, 1.0, 1.0);
            GUIHelper.addGBComponent(this.buttonpanel, button_gbl, this.apply_button, 1, 0, 1, 1, 1.0, 1.0);
            this.namepanel.add(this.nameLabel);
            this.add((Component)this.namepanel, "North");
            this.add((Component)this.optionspanel, "Center");
            this.add((Component)this.buttonpanel, "South");
            this.handleGUI();
            this.pack();
            this.setVisible(false);
        }

        private void handleGUI() {
            if (PropertyPanel.this.prop.getRendererType() == 0) {
                this.stroke_slider.setEnabled(true);
                this.shape_box.setEnabled(true);
                this.stroke_button.setEnabled(true);
                this.outline_slider.setEnabled(true);
                this.outline_button.setEnabled(true);
                this.fill_button.setEnabled(true);
                this.shapes_vis_box.setEnabled(true);
                this.lines_vis_box.setEnabled(true);
                this.shape_slider.setEnabled(true);
            }
            if (PropertyPanel.this.prop.getRendererType() == 2) {
                this.stroke_slider.setEnabled(false);
                this.shape_box.setEnabled(false);
                this.stroke_button.setEnabled(true);
                this.outline_slider.setEnabled(false);
                this.outline_button.setEnabled(false);
                this.fill_button.setEnabled(false);
                this.shapes_vis_box.setEnabled(false);
                this.lines_vis_box.setEnabled(false);
                this.shape_slider.setEnabled(false);
            }
            if (PropertyPanel.this.prop.getRendererType() == 5) {
                this.stroke_slider.setEnabled(true);
                this.shape_box.setEnabled(true);
                this.stroke_button.setEnabled(true);
                this.outline_slider.setEnabled(false);
                this.outline_button.setEnabled(false);
                this.fill_button.setEnabled(false);
                this.shapes_vis_box.setEnabled(true);
                this.lines_vis_box.setEnabled(true);
                this.shape_slider.setEnabled(true);
            }
            if (PropertyPanel.this.prop.getRendererType() == 1 || PropertyPanel.this.prop.getRendererType() == 3 || PropertyPanel.this.prop.getRendererType() == 4) {
                this.stroke_slider.setEnabled(false);
                this.shape_box.setEnabled(false);
                this.stroke_button.setEnabled(true);
                this.outline_slider.setEnabled(false);
                this.outline_button.setEnabled(false);
                this.fill_button.setEnabled(false);
                this.shapes_vis_box.setEnabled(false);
                this.lines_vis_box.setEnabled(false);
                this.shape_slider.setEnabled(false);
            }
        }

        private void setNameLabel(String name) {
            this.nameLabel.setText(name);
        }
    }
}

