/*
 * Decompiled with CFR 0.152.
 */
package ccindex.explorer.spreadsheet;

import ccindex.explorer.spreadsheet.GraphProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.EPSDocumentGraphics2D;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class JAMSTimePlot {
    Vector<GraphProperties> propVector;
    DateAxis dateAxis;
    ValueAxis axisLEFT;
    ValueAxis axisRIGHT;
    int graphCount = 0;
    int graphCountRight = 0;
    int graphCountLeft = 0;
    double weight;
    String xAxisTitle;
    String leftAxisTitle;
    String rightAxisTitle;
    String title;
    ChartPanel chartPanel;
    TimeSeriesCollection dataLeft = new TimeSeriesCollection();
    TimeSeriesCollection dataRight = new TimeSeriesCollection();
    XYItemRenderer rightRenderer;
    XYItemRenderer leftRenderer;
    XYPlot plot;
    JFreeChart chart;
    JPanel panel;
    JButton saveButton;
    HashMap<String, Color> colorTable = new HashMap();

    public JAMSTimePlot() {
        this.colorTable.put("yellow", Color.yellow);
        this.colorTable.put("orange", Color.orange);
        this.colorTable.put("red", Color.red);
        this.colorTable.put("pink", Color.pink);
        this.colorTable.put("magenta", Color.magenta);
        this.colorTable.put("cyan", Color.cyan);
        this.colorTable.put("blue", Color.blue);
        this.colorTable.put("green", Color.green);
        this.colorTable.put("gray", Color.gray);
        this.colorTable.put("lightgray", Color.lightGray);
        this.colorTable.put("black", Color.black);
        this.setDefaultValues();
    }

    public JAMSTimePlot(Vector<GraphProperties> propVector) {
        this.propVector = propVector;
        this.colorTable.put("yellow", Color.yellow);
        this.colorTable.put("orange", Color.orange);
        this.colorTable.put("red", Color.red);
        this.colorTable.put("pink", Color.pink);
        this.colorTable.put("magenta", Color.magenta);
        this.colorTable.put("cyan", Color.cyan);
        this.colorTable.put("blue", Color.blue);
        this.colorTable.put("green", Color.green);
        this.colorTable.put("gray", Color.gray);
        this.colorTable.put("lightgray", Color.lightGray);
        this.colorTable.put("black", Color.black);
        this.setDefaultValues();
    }

    public XYPlot getXYPlot() {
        return this.chart.getXYPlot();
    }

    public DateAxis getDateAxis() {
        return this.dateAxis;
    }

    public void setDefaultValues() {
        String xAxisTitle = "x axis title";
        String leftAxisTitle = "left axis title";
        String rightAxisTitle = "right axis title";
        String title = "CTSPlot ver. 1.00";
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public BufferedImage getBufferedImage(int width, int height) {
        BufferedImage bi = this.chart.createBufferedImage(width, height);
        return bi;
    }

    public void saveAsEPS(File outfile) {
        try {
            FileOutputStream out = new FileOutputStream(outfile);
            EPSDocumentGraphics2D g2d = new EPSDocumentGraphics2D(false);
            g2d.setGraphicContext(new GraphicContext());
            int width = 600;
            int height = 400;
            g2d.setupDocument((OutputStream)out, width, height);
            this.chart.draw((Graphics2D)g2d, (Rectangle2D)new Rectangle(width, height));
            g2d.finish();
            out.flush();
            ((OutputStream)out).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void removeLegendAndXAxis() {
        this.chart.removeLegend();
        this.dateAxis.setVisible(false);
    }

    private XYItemRenderer getRenderer(int type) {
        XYBarRenderer r;
        switch (type) {
            case 0: {
                XYLineAndShapeRenderer lsr = new XYLineAndShapeRenderer();
                lsr.setBaseShapesVisible(false);
                r = lsr;
                break;
            }
            case 1: {
                r = new XYBarRenderer();
                break;
            }
            case 2: {
                r = new XYAreaRenderer();
                break;
            }
            case 3: {
                XYLineAndShapeRenderer lsr = new XYLineAndShapeRenderer();
                lsr.setBaseShapesVisible(true);
                r = lsr;
                break;
            }
            case 4: {
                XYDotRenderer dotR = new XYDotRenderer();
                dotR.setDefaultEntityRadius(2);
                dotR.setDotHeight(5);
                dotR.setDotWidth(5);
                r = dotR;
                break;
            }
            case 7: {
                r = new XYDifferenceRenderer();
                break;
            }
            case 5: {
                r = new XYStepRenderer();
                break;
            }
            case 6: {
                r = new XYStepAreaRenderer();
                break;
            }
            default: {
                XYLineAndShapeRenderer lsr = new XYLineAndShapeRenderer();
                lsr.setBaseShapesVisible(false);
                r = lsr;
            }
        }
        return r;
    }

    public void createPlot() {
        this.chart = ChartFactory.createTimeSeriesChart((String)"title", (String)"xAxisTitle", (String)"leftAxisTitle", (XYDataset)this.dataLeft, (boolean)true, (boolean)false, (boolean)false);
        this.chartPanel = new ChartPanel(this.chart, true);
        this.chartPanel.setBackground(Color.WHITE);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.setBackground(Color.WHITE);
        this.panel.add((Component)this.chartPanel, "Center");
        this.panel.add((Component)this.chartPanel);
        this.plot = this.chart.getXYPlot();
        DateAxis dateAxis = (DateAxis)this.plot.getDomainAxis();
        dateAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat("dd-MM-yyyy"));
        this.axisLEFT = new NumberAxis(this.leftAxisTitle);
        this.axisRIGHT = new NumberAxis(this.rightAxisTitle);
    }

    public void setPropVector(Vector<GraphProperties> propVector) {
        this.propVector = propVector;
    }

    public Vector<GraphProperties> getPropVector() {
        return this.propVector;
    }

    public void plotLeft(XYItemRenderer leftRenderer, String nameLeft, String xAxisTitle, boolean inverted) {
        int plot_count = 0;
        int c = this.propVector.size();
        int right = 0;
        this.dataLeft = new TimeSeriesCollection();
        DateAxis dateAxis = (DateAxis)this.plot.getDomainAxis();
        this.axisLEFT.setInverted(inverted);
        this.axisLEFT.setLabel(nameLeft);
        dateAxis.setLabel(xAxisTitle);
        for (int k = 0; k < c; ++k) {
            GraphProperties prop = this.propVector.get(k);
            if (this.propVector.get(k).getPosition() == 0) {
                ++plot_count;
                this.dataLeft.addSeries(prop.getTS());
                this.dataRight.removeSeries(prop.getTS());
                continue;
            }
            this.dataLeft.removeSeries(prop.getTS());
            ++right;
        }
        if (right == 0) {
            this.dataRight.removeAllSeries();
            this.axisRIGHT.setVisible(false);
            this.axisLEFT.setVisible(true);
            this.plot.setRangeAxisLocation(0, AxisLocation.BOTTOM_OR_LEFT);
            this.plot.setRangeAxis(0, this.axisLEFT);
            this.plot.setDataset(0, (XYDataset)this.dataLeft);
            this.plot.setRenderer(0, leftRenderer);
            this.plot.mapDatasetToRangeAxis(0, 0);
        } else {
            this.axisRIGHT.setVisible(true);
            this.plot.setRangeAxisLocation(0, AxisLocation.BOTTOM_OR_LEFT);
            this.plot.setRangeAxis(0, this.axisLEFT);
            this.plot.setDataset(0, (XYDataset)this.dataLeft);
            this.plot.setRenderer(0, leftRenderer);
            this.plot.mapDatasetToRangeAxis(0, 0);
        }
    }

    public void setTitle(String title) {
        this.chart.setTitle(title);
    }

    public String getTitle() {
        return this.title;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public double getWeight() {
        return this.weight;
    }

    public void plotEmpty() {
        boolean plot_count = false;
        int c = this.propVector.size();
        boolean corr = false;
        this.dataLeft = new TimeSeriesCollection();
        this.axisLEFT.setInverted(false);
        this.axisLEFT.setLabel("Left axis title");
        this.leftRenderer = this.getRenderer(0);
        this.dataLeft.removeAllSeries();
        this.dataRight.removeAllSeries();
        this.axisRIGHT.setVisible(false);
        this.axisLEFT.setVisible(true);
        this.plot.setRangeAxisLocation(0, AxisLocation.BOTTOM_OR_LEFT);
        this.plot.setRangeAxis(0, this.axisLEFT);
        this.plot.setDataset(0, (XYDataset)this.dataLeft);
        this.plot.setRenderer(0, this.leftRenderer);
        this.plot.mapDatasetToRangeAxis(0, 0);
    }

    public void setDateFormat(boolean yy, boolean mm, boolean dd, boolean hm) {
        String timeFormat = "";
        if (dd) {
            timeFormat = timeFormat + "dd. ";
        }
        if (mm) {
            timeFormat = timeFormat + "MM. ";
        }
        if (yy) {
            timeFormat = timeFormat + "yyyy ";
        }
        if (hm) {
            timeFormat = timeFormat + "hh:mm";
        }
        this.dateAxis = (DateAxis)this.plot.getDomainAxis();
        this.dateAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat(timeFormat));
    }

    public void plotRight(XYItemRenderer rightRenderer, String nameRight, String xAxisTitle, boolean inverted) {
        int plot_count = 0;
        int c = this.propVector.size();
        int left = 0;
        this.dataRight = new TimeSeriesCollection();
        DateAxis dateAxis = (DateAxis)this.plot.getDomainAxis();
        dateAxis.setLabel(xAxisTitle);
        this.axisRIGHT.setInverted(inverted);
        this.axisRIGHT.setLabel(nameRight);
        for (int k = 0; k < c; ++k) {
            GraphProperties prop = this.propVector.get(k);
            if (this.propVector.get(k).getPosition() == 1) {
                ++plot_count;
                this.dataRight.addSeries(prop.getTS());
                this.dataLeft.removeSeries(prop.getTS());
                continue;
            }
            ++left;
            this.dataRight.removeSeries(prop.getTS());
        }
        if (left == 0) {
            this.dataLeft.removeAllSeries();
            this.axisLEFT.setVisible(false);
            this.axisRIGHT.setVisible(true);
            this.plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
            this.plot.setRangeAxis(1, this.axisRIGHT);
            this.plot.setDataset(1, (XYDataset)this.dataRight);
            this.plot.setRenderer(1, rightRenderer);
            this.plot.mapDatasetToRangeAxis(1, 1);
        } else {
            this.axisLEFT.setVisible(true);
            this.plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
            this.plot.setRangeAxis(1, this.axisRIGHT);
            this.plot.setDataset(1, (XYDataset)this.dataRight);
            this.plot.setRenderer(1, rightRenderer);
            this.plot.mapDatasetToRangeAxis(1, 1);
        }
        this.plot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
    }

    public void cleanup() {
    }
}

