/*
 * Decompiled with CFR 0.152.
 */
package ccindex.explorer.ensembles.implementation;

import ccindex.explorer.ensembles.api.EnsembleProcessor;
import ccindex.explorer.ensembles.gui.EnsembleControlPanel;
import ccindex.explorer.ensembles.implementation.ClimateEnsemble;
import ccindex.explorer.ensembles.implementation.ClimateModel;
import jams.data.Attribute;
import jams.data.JAMSCalendar;
import jams.workspace.dsproc.AbstractDataStoreProcessor;
import jams.workspace.dsproc.DataMatrix;
import jams.workspace.dsproc.DataStoreProcessor;
import jams.workspace.dsproc.TimeSpaceProcessor;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClimateEnsembleProcessor
implements EnsembleProcessor<ClimateModel, ClimateEnsemble> {
    static final Logger logger = Logger.getLogger(ClimateEnsembleProcessor.class.getName());
    ClimateEnsemble ensemble;
    String outputDatastoreName;
    HashMap<ClimateModel, TimeSpaceProcessor> procs;

    public ClimateEnsembleProcessor(ClimateEnsemble ensemble, String output) {
        EnsembleControlPanel.registerLogHandler(logger);
        this.ensemble = null;
        this.outputDatastoreName = null;
        this.procs = new HashMap();
        this.ensemble = ensemble;
        this.outputDatastoreName = output;
    }

    @Override
    public int getModelCount() {
        return this.ensemble.getSize();
    }

    public int getNettoModelCount(String outputName) {
        int count = 0;
        for (ClimateModel model : this.ensemble.getModelSet()) {
            for (String outputDirectory : model.outputFiles.keySet()) {
                File outputDatastore;
                if (!model.isOutputSelected(outputDirectory) || !(outputDatastore = new File(new File(new File(model.getLocation(), "output"), outputDirectory), outputName)).exists()) continue;
                ++count;
            }
        }
        return count;
    }

    public void init() {
        for (ClimateModel model : this.ensemble.getModelSet()) {
            DataStoreProcessor[] dsProcs;
            for (DataStoreProcessor dsProc : dsProcs = model.getDataStoreProcessors(this.outputDatastoreName)) {
                if (dsProc == null || !dsProc.isTimeSpaceDatastore()) continue;
                try {
                    dsProc.createDB();
                }
                catch (Exception e) {
                    if (dsProc != null && dsProc.getFile() != null) {
                        logger.log(Level.SEVERE, "During initialisation of %1 an error occured.".replace("%1", dsProc.getFile().getAbsolutePath()));
                    }
                    logger.log(Level.SEVERE, "dsProc is null");
                }
                TimeSpaceProcessor tsp = new TimeSpaceProcessor(dsProc);
                this.procs.put(model, tsp);
            }
        }
    }

    public void close() throws SQLException {
        for (TimeSpaceProcessor tsp : this.procs.values()) {
            tsp.close();
        }
    }

    public boolean isModelOutputValid(ClimateModel model) {
        return this.procs.get(model) != null;
    }

    @Override
    public Attribute.Calendar[] getTimeDomain() throws SQLException {
        TreeSet<JAMSCalendar> result = new TreeSet<JAMSCalendar>();
        if (!this.procs.isEmpty()) {
            result.addAll(Arrays.asList(this.procs.values().iterator().next().getTimeSteps()));
            for (ClimateModel model : this.procs.keySet()) {
                result.retainAll(Arrays.asList(this.procs.get(model).getTimeSteps()));
            }
        }
        return result.toArray(new Attribute.Calendar[0]);
    }

    public double[][] getTimeSlice(long[] entityIds, String dateIds) throws SQLException, IOException {
        double[][] result = new double[this.ensemble.getSize()][entityIds.length];
        int j = 0;
        for (ClimateModel model : this.procs.keySet()) {
            TimeSpaceProcessor tsp = this.procs.get(model);
            if (tsp != null) {
                for (AbstractDataStoreProcessor.AttributeData a : tsp.getDataStoreProcessor().getAttributes()) {
                    a.setSelected(true);
                }
                DataMatrix matrix = this.procs.get(model).getCrossProduct(entityIds, new String[]{dateIds});
                for (int i = 0; i < entityIds.length; ++i) {
                    result[j][i] = matrix.get(0, i);
                }
            }
            ++j;
        }
        return result;
    }

    private String date() {
        return "[" + new Date().getTime() + "]";
    }

    public double[][] getModelSlice(ClimateModel model) throws SQLException, IOException {
        System.out.println(this.date() + ":Working on getModelSlice ");
        System.out.println(this.date() + ":getEntityIDs");
        long[] entityIDs = this.getEntityIDs();
        System.out.println(this.date() + ":getTimeDomain");
        Attribute.Calendar[] dateIds = this.getTimeDomain();
        String[] dateIdsAsString = new String[dateIds.length];
        for (int i = 0; i < dateIds.length; ++i) {
            dateIdsAsString[i] = dateIds[i].toString();
        }
        double[][] result = new double[dateIdsAsString.length][entityIDs.length];
        TimeSpaceProcessor tsp = this.procs.get(model);
        if (tsp != null) {
            for (AbstractDataStoreProcessor.AttributeData a : tsp.getDataStoreProcessor().getAttributes()) {
                a.setSelected(true);
            }
            System.out.println(this.date() + ":getCrossProduct");
            DataMatrix matrix = this.procs.get(model).getCrossProduct(entityIDs, dateIdsAsString);
            System.out.println(this.date() + ":finished");
            for (int i = 0; i < entityIDs.length; ++i) {
                for (int j = 0; j < dateIdsAsString.length; ++j) {
                    result[j][i] = matrix.get(j, i);
                }
            }
        }
        return result;
    }

    @Override
    public long[] getEntityIDs() throws SQLException, IOException {
        TreeSet<Long> result = new TreeSet<Long>();
        if (!this.procs.keySet().isEmpty()) {
            result.addAll(Arrays.asList(this.procs.values().iterator().next().getEntityIDs()));
            for (ClimateModel model : this.procs.keySet()) {
                TreeSet<Long> sortedList = new TreeSet<Long>(Arrays.asList(this.procs.get(model).getEntityIDs()));
                result.retainAll(sortedList);
            }
        }
        long[] convResult = new long[result.size()];
        int i = 0;
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            convResult[i++] = l;
        }
        return convResult;
    }

    @Override
    public double[][] getSpatialMean() throws SQLException, IOException {
        long[] entityIDs = this.getEntityIDs();
        Attribute.Calendar[] timeIDsSource = this.getTimeDomain();
        String[] timeIDs = new String[timeIDsSource.length];
        for (int i = 0; i < timeIDsSource.length; ++i) {
            timeIDs[i] = timeIDsSource[i].toString();
        }
        double[][] result = new double[this.ensemble.getSize()][timeIDs.length];
        int i = 0;
        for (ClimateModel model : this.ensemble.modelSet) {
            TimeSpaceProcessor tsp = this.procs.get(model);
            Arrays.fill(result[i], Double.NaN);
            if (tsp != null) {
                for (AbstractDataStoreProcessor.AttributeData a : tsp.getDataStoreProcessor().getAttributes()) {
                    a.setSelected(true);
                }
                DataMatrix m = tsp.getCrossProduct(entityIDs, timeIDs);
                double[] avg = m.getAvgCol();
                System.arraycopy(avg, 0, result[i], 0, timeIDs.length);
            }
            ++i;
        }
        return result;
    }

    @Override
    public double[] getSpatialMean(ClimateModel model) throws SQLException, IOException {
        TimeSpaceProcessor tsp = this.procs.get(model);
        if (tsp == null) {
            return null;
        }
        long[] entityIDs = this.getEntityIDs();
        Attribute.Calendar[] timeIDsSource = this.getTimeDomain();
        String[] timeIDs = new String[timeIDsSource.length];
        for (int i = 0; i < timeIDsSource.length; ++i) {
            timeIDs[i] = timeIDsSource[i].toString();
        }
        DataMatrix m = tsp.getCrossProduct(entityIDs, timeIDs);
        return m.getAvgRow();
    }

    @Override
    public DataMatrix calculate(String s) {
        return null;
    }
}

