/*
 * Decompiled with CFR 0.152.
 */
package ccindex.explorer.ensembles.gui;

import ccindex.explorer.ensembles.gui.EnsembleControlPanel;
import ccindex.explorer.ensembles.gui.EnsembleTree;
import ccindex.explorer.ensembles.implementation.ClimateEnsemble;
import ccindex.explorer.ensembles.implementation.ClimateModel;
import jams.JAMS;
import jams.JAMSFileFilter;
import jams.gui.JAMSLauncher;
import jams.gui.WorkerDlg;
import jams.tools.FileTools;
import jams.tools.XMLTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;

public class EnsembleOverview
extends JPanel {
    private static final Logger logger = Logger.getLogger(EnsembleOverview.class.getName());
    private ClimateEnsemble dataset;
    private JAMSLauncher launcher;
    private EnsembleTree tree;
    private final JFileChooser jfc;
    private final JButton newEnsembleItem;
    private final JButton openEnsembleItem;
    private final JButton saveEnsembleItem;
    private final JButton addModelItem;
    private final JButton createBatchFileItem;
    private final JButton startModelItem;
    private final JButton confModelItem;
    private final JButton duplicateModelItem;
    private final JButton removeModelItem;
    private JToolBar toolbar;
    ArrayList<EnsembleChangeListener> ensembleChangeListeners;

    public EnsembleOverview(ClimateEnsemble dataset, JAMSLauncher launcher) {
        EnsembleControlPanel.registerLogHandler(logger);
        this.tree = new EnsembleTree();
        this.jfc = new JFileChooser(new File("").getAbsolutePath());
        this.newEnsembleItem = new JButton(JAMS.getIcon("resources/images/ModelNew.png"));
        this.openEnsembleItem = new JButton(JAMS.getIcon("resources/images/ModelOpen.png"));
        this.saveEnsembleItem = new JButton(JAMS.getIcon("resources/images/ModelSave.png"));
        this.addModelItem = new JButton(JAMS.getIcon("ccindex/explorer/resources/images/add-icon.png"));
        this.createBatchFileItem = new JButton(JAMS.getIcon("ccindex/explorer/resources/images/bat.png"));
        this.startModelItem = new JButton(JAMS.getIcon("resources/images/ModelRun.png"));
        this.confModelItem = new JButton(JAMS.getIcon("resources/images/Preferences.png"));
        this.duplicateModelItem = new JButton(JAMS.getIcon("resources/images/Copy.png"));
        this.removeModelItem = new JButton(JAMS.getIcon("ccindex/explorer/resources/images/minus-icon.png"));
        this.toolbar = new JToolBar();
        this.ensembleChangeListeners = new ArrayList();
        this.launcher = launcher;
        logger.entering(this.getClass().getName(), "EnsembleOverview");
        this.dataset = dataset;
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolbar, "North");
        this.add((Component)new JScrollPane(this.tree), "Center");
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.isControlDown() && e.getKeyCode() == 76) {
                    EnsembleOverview.this.loadEnsembleAction();
                }
                if (e.isControlDown() && e.getKeyCode() == 83) {
                    EnsembleOverview.this.saveEnsembleAction();
                }
                return false;
            }
        });
        this.init();
        logger.exiting(this.getClass().getName(), "EnsembleOverview");
    }

    private void init() {
        logger.entering(this.getClass().getName(), "init");
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        this.toolbar.add(this.newEnsembleItem);
        this.newEnsembleItem.setToolTipText("Create a new ensemble ..");
        this.toolbar.add(this.openEnsembleItem);
        this.openEnsembleItem.setToolTipText("Load an existing ensemble ..");
        this.toolbar.add(this.saveEnsembleItem);
        this.saveEnsembleItem.setToolTipText("Save ensemble ..");
        this.toolbar.addSeparator();
        this.toolbar.add(this.createBatchFileItem);
        this.createBatchFileItem.setToolTipText("Create batch file ..");
        this.toolbar.add(this.startModelItem);
        this.startModelItem.setToolTipText("Start the selected model ..");
        this.toolbar.add(this.confModelItem);
        this.confModelItem.setToolTipText("Configure model ..");
        this.toolbar.addSeparator();
        this.toolbar.add(this.addModelItem);
        this.addModelItem.setToolTipText("Add a model ..");
        this.toolbar.add(this.removeModelItem);
        this.removeModelItem.setToolTipText("Remove selected model ..");
        this.toolbar.add(this.duplicateModelItem);
        this.duplicateModelItem.setToolTipText("Duplicate selected model ..");
        this.newEnsembleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnsembleOverview.this.newModelAction();
            }
        });
        this.addModelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkerDlg worker = new WorkerDlg(null, "Loading models");
                worker.setTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            EnsembleOverview.this.addModelAction();
                        }
                        catch (Throwable t) {
                            logger.log(Level.SEVERE, "Sorry, I failed to add this model!", t);
                        }
                    }
                });
                worker.execute();
            }
        });
        this.removeModelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnsembleOverview.this.removeModelAction();
            }
        });
        this.duplicateModelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnsembleOverview.this.duplicateModelAction();
            }
        });
        this.startModelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnsembleOverview.this.startModelAction();
            }
        });
        this.createBatchFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnsembleOverview.this.createBatchFileAction();
            }
        });
        this.saveEnsembleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnsembleOverview.this.saveEnsembleAction();
            }
        });
        this.openEnsembleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnsembleOverview.this.loadEnsembleAction();
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath p = e.getNewLeadSelectionPath();
                if (p == null) {
                    EnsembleOverview.this.setSelectionState(SelectionState.NOTHING_SELETED, null);
                    return;
                }
                Object o = p.getLastPathComponent();
                if (o instanceof ClimateEnsemble.ModelTreeNode) {
                    EnsembleOverview.this.setSelectionState(SelectionState.MODEL_SELECTED, o);
                } else {
                    EnsembleOverview.this.setSelectionState(SelectionState.ROOT_SELECTED, o);
                }
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3 && e.getClickCount() == 1) {
                    TreePath path = EnsembleOverview.this.tree.getPathForLocation(e.getX(), e.getY());
                    if (path == null) {
                        return;
                    }
                    Object o = path.getLastPathComponent();
                    if (o != null && o instanceof ClimateEnsemble.OutputDirectoryTreeNode) {
                        ClimateEnsemble.OutputDirectoryTreeNode odtn = (ClimateEnsemble.OutputDirectoryTreeNode)o;
                        odtn.getModel().toggleOutputSelection(odtn.getOutputDirectory());
                    }
                    EnsembleOverview.this.tree.repaint();
                }
            }
        });
        this.setClimateEnsembleChanged();
        logger.exiting(this.getClass().getName(), "init");
    }

    public void addEnsembleChangeListener(EnsembleChangeListener listener) {
        this.ensembleChangeListeners.add(listener);
    }

    public boolean removeEnsembleChangeListener(EnsembleChangeListener listener) {
        return this.ensembleChangeListeners.remove(listener);
    }

    private void setSelectionState(SelectionState state, Object o) {
        logger.entering(this.getClass().getName(), "setSelectionState");
        this.addModelItem.setEnabled(true);
        this.createBatchFileItem.setEnabled(true);
        this.startModelItem.setEnabled(true);
        this.confModelItem.setEnabled(true);
        this.duplicateModelItem.setEnabled(false);
        this.removeModelItem.setEnabled(false);
        int n = this.tree.getSelectionCount();
        if (state == SelectionState.MODEL_SELECTED && n == 1) {
            this.startModelItem.setEnabled(true);
            this.duplicateModelItem.setEnabled(true);
            this.removeModelItem.setEnabled(true);
        }
        if (state != SelectionState.MODEL_SELECTED || n != 1) {
            this.startModelItem.setEnabled(false);
            this.duplicateModelItem.setEnabled(false);
            this.removeModelItem.setEnabled(true);
        }
        if (this.launcher == null) {
            this.confModelItem.setEnabled(false);
            this.startModelItem.setEnabled(false);
        }
        logger.exiting(this.getClass().getName(), "setSelectionState");
    }

    public ArrayList<ClimateModel> getSelectedClimateModels() {
        logger.entering(this.getClass().getName(), "getSelectedClimateModels");
        TreePath[] paths = this.tree.getSelectionPaths();
        ArrayList<ClimateModel> selectedModels = new ArrayList<ClimateModel>();
        if (paths != null) {
            for (TreePath p : paths) {
                Object o = p.getLastPathComponent();
                if (!(o instanceof ClimateEnsemble.ModelTreeNode)) continue;
                ClimateEnsemble.ModelTreeNode node = (ClimateEnsemble.ModelTreeNode)o;
                selectedModels.add(node.getModel());
            }
        }
        logger.exiting(this.getClass().getName(), "getSelectedClimateModels");
        return selectedModels;
    }

    public void setClimateEnsemble(ClimateEnsemble ce) {
        this.dataset = ce;
        this.setClimateEnsembleChanged();
    }

    public ClimateEnsemble getClimateEnsemble() {
        return this.dataset;
    }

    public void setClimateEnsembleChanged() {
        logger.entering(this.getClass().getName(), "setClimateEnsembleChanged");
        this.tree.setModel(this.dataset.getTreeModel());
        for (EnsembleChangeListener listener : this.ensembleChangeListeners) {
            listener.changed(this.dataset);
        }
        logger.exiting(this.getClass().getName(), "setClimateEnsembleChanged");
    }

    public JTree getTree() {
        return this.tree;
    }

    protected void newModelAction() {
        logger.entering(this.getClass().getName(), "newModelAction");
        this.dataset = new ClimateEnsemble("new ensemble");
        this.setClimateEnsembleChanged();
        logger.exiting(this.getClass().getName(), "newModelAction");
    }

    protected void addModelAction() {
        logger.entering(this.getClass().getName(), "addModelAction");
        this.jfc.setMultiSelectionEnabled(true);
        this.jfc.setFileSelectionMode(2);
        this.jfc.setFileFilter(JAMSFileFilter.getXMLFilter());
        int result = this.jfc.showOpenDialog(this);
        if (result == 0) {
            File[] files;
            for (File f : files = this.jfc.getSelectedFiles()) {
                if (f.isDirectory()) {
                    File[] list = f.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith("jam") || name.endsWith("xml");
                        }
                    });
                    if (list.length > 1) continue;
                    this.dataset.addModel(new ClimateModel(0, list[0]));
                    continue;
                }
                this.dataset.addModel(new ClimateModel(0, f));
            }
            this.setClimateEnsembleChanged();
        }
        logger.exiting(this.getClass().getName(), "addModelAction");
    }

    protected void duplicateModelAction() {
        String result;
        logger.entering(this.getClass().getName(), "duplicateModelAction");
        ArrayList<ClimateModel> models = this.getSelectedClimateModels();
        if (models.size() > 1) {
            logger.log(Level.SEVERE, "Duplicate called for several selected nodes");
            return;
        }
        ClimateModel model = models.get(0);
        int numberOfDuplicates = 0;
        while ((result = JOptionPane.showInputDialog(this, (Object)"Specify number of duplicates")) != null) {
            try {
                numberOfDuplicates = Integer.parseInt(result);
                if (numberOfDuplicates < 0) {
                    throw new NumberFormatException();
                }
                break;
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this.tree, "Please enter a valid postive number or zero if you don't want to create any duplicates.");
            }
        }
        if (numberOfDuplicates > 0) {
            try {
                ClimateModel[] duplicates;
                for (ClimateModel cm : duplicates = model.createDuplicates(numberOfDuplicates)) {
                    this.dataset.addModel(cm);
                }
                this.setClimateEnsembleChanged();
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, "Sorry, I am not able to copy the directory", ioe);
            }
        }
        logger.exiting(this.getClass().getName(), "duplicateModelAction");
    }

    protected void removeModelAction() {
        logger.entering(this.getClass().getName(), "removeModelAction");
        ArrayList<ClimateModel> models = this.getSelectedClimateModels();
        for (ClimateModel model : models) {
            this.getClimateEnsemble().removeModel(model);
        }
        this.setClimateEnsembleChanged();
        logger.exiting(this.getClass().getName(), "removeModelAction");
    }

    protected void deleteModelAction() {
        logger.entering(this.getClass().getName(), "deleteModelAction");
        ArrayList<ClimateModel> models = this.getSelectedClimateModels();
        if (models.size() <= 0) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(this, "Really delete %1 models?".replace("%1", Integer.toString(models.size())), "Please confirm", 0);
        if (result != 0) {
            return;
        }
        for (ClimateModel model : models) {
            try {
                this.getClimateEnsemble().deleteModel(model);
            }
            catch (IOException ioe) {
                if (model.getLocation() != null) {
                    logger.log(Level.SEVERE, "Sorry, I cannot delete the workspace of %1".replace("%1", model.getLocation().getAbsolutePath()), ioe);
                    continue;
                }
                logger.log(Level.SEVERE, "Sorry, I cannot delete the workspace of an unlocated model!", ioe);
            }
        }
        this.setClimateEnsembleChanged();
        logger.exiting(this.getClass().getName(), "deleteModelAction");
    }

    protected void startModelAction() {
        if (this.launcher == null) {
            logger.severe("Please start the Ensemble Manager from JAMS Launcher to enable model execution.");
            return;
        }
        logger.entering(this.getClass().getName(), "startModelAction");
        ArrayList<ClimateModel> models = this.getSelectedClimateModels();
        if (models.size() > 1) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Duplicate called for several selected nodes");
            return;
        }
        if (models.size() > 0) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Please select the model you want to start!");
            return;
        }
        ClimateModel model = models.get(0);
        File modelFile = model.getModelfile();
        Document doc = XMLTools.getDocument(modelFile.getAbsolutePath());
        JAMSLauncher myLauncher = new JAMSLauncher(this.launcher, this.launcher.getProperties(), doc, modelFile){
            {
                this.init();
                this.runModel();
            }
        };
        logger.exiting(this.getClass().getName(), "startModelAction");
    }

    protected void createBatchFileAction() {
        logger.entering(this.getClass().getName(), "createBatchFileAction");
        ArrayList<ClimateModel> models = this.getSelectedClimateModels();
        logger.exiting(this.getClass().getName(), "createBatchFileAction");
    }

    protected void loadEnsembleAction() {
        logger.entering(this.getClass().getName(), "loadEnsembleAction");
        this.jfc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getAbsolutePath().endsWith(".edf");
            }

            @Override
            public String getDescription() {
                return "Ensemble Description Files (.edf)";
            }
        });
        this.jfc.setFileSelectionMode(0);
        int result = this.jfc.showOpenDialog(this);
        if (result == 0) {
            File f = this.jfc.getSelectedFile();
            try {
                ClimateEnsemble ens = FileTools.deserializeObjectFromXMLwithJAXB(f, ClimateEnsemble.class);
                ens.setBasePath(f.getParentFile());
                this.setClimateEnsemble(ens);
            }
            catch (Throwable ex) {
                if (f == null) {
                    logger.log(Level.SEVERE, "Sorry, I am not able to load a null file, ex");
                }
                logger.log(Level.SEVERE, "Sorry, I am not able to load the file %1".replace("%1", f.getAbsolutePath()), ex);
            }
        }
        logger.exiting(this.getClass().getName(), "loadEnsembleAction");
    }

    protected void saveEnsembleAction() {
        logger.entering(this.getClass().getName(), "saveEnsembleAction");
        this.jfc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getAbsolutePath().endsWith(".edf");
            }

            @Override
            public String getDescription() {
                return "Ensemble Description Files (.edf)";
            }
        });
        this.jfc.setFileSelectionMode(0);
        int result = this.jfc.showSaveDialog(this);
        if (result == 0) {
            File f = this.jfc.getSelectedFile();
            if (!f.getAbsolutePath().endsWith(".edf")) {
                f = new File(f.getParentFile(), f.getName() + ".edf");
            }
            if (f.exists()) {
                JOptionPane.showConfirmDialog(this.tree, "%1 already exists! Do you want to replace it?".replace("%1", f.getName()));
            }
            try {
                this.getClimateEnsemble().relocate(f.getParentFile());
                this.getClimateEnsemble().save();
                FileTools.serializeObjectToXMLwithJAXB(this.getClimateEnsemble(), f);
                JOptionPane.showMessageDialog(null, "Ensemble saved!");
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ex.toString(), ex);
            }
        }
        logger.exiting(this.getClass().getName(), "saveEnsembleAction");
    }

    static enum SelectionState {
        ROOT_SELECTED,
        MODEL_SELECTED,
        NOTHING_SELETED;

    }

    public static interface EnsembleChangeListener {
        public void changed(ClimateEnsemble var1);
    }
}

