/*
 * Decompiled with CFR 0.152.
 */
package ccindex.explorer;

import ccindex.explorer.DisplayManager;
import ccindex.explorer.gui.ExplorerFrame;
import jams.JAMS;
import jams.JAMSProperties;
import jams.SystemProperties;
import jams.gui.tools.GUIHelper;
import jams.runtime.JAMSRuntime;
import jams.runtime.StandardRuntime;
import jams.workspace.InvalidWorkspaceException;
import jams.workspace.JAMSWorkspace;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JAMSExplorer {
    public static final String APP_TITLE = JAMS.i18n("JADE");
    public static final int SCREEN_WIDTH = 1200;
    public static final int SCREEN_HEIGHT = 1000;
    protected ExplorerFrame explorerFrame;
    protected JAMSRuntime runtime;
    protected SystemProperties properties;
    protected DisplayManager displayManager;
    protected JAMSWorkspace workspace;
    protected ArrayList<Window> childWindows = new ArrayList();
    private boolean standAlone;
    protected static JAMSExplorer explorer;

    public JAMSExplorer(JAMSRuntime runtime) {
        this(runtime, true);
    }

    public JAMSExplorer(JAMSRuntime runtime, boolean standAlone) {
        this.standAlone = standAlone;
        this.properties = JAMSProperties.createProperties();
        File defaultFile = new File(JAMS.getBaseDir(), "default.jap");
        if (defaultFile.exists() && standAlone) {
            try {
                this.properties.load(defaultFile.getAbsolutePath());
            }
            catch (IOException ioe) {
                Logger.getLogger(JAMSExplorer.class.getName()).log(Level.SEVERE, ioe.getMessage(), ioe);
            }
        }
        if (runtime == null) {
            this.runtime = new StandardRuntime(this.properties);
            this.runtime.setDebugLevel(2);
            this.runtime.addErrorLogObserver(new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    GUIHelper.showErrorDlg(JAMSExplorer.this.explorerFrame, arg.toString(), JAMS.i18n("Error"));
                }
            });
            this.runtime.addInfoLogObserver(new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                }
            });
        } else {
            this.runtime = runtime;
        }
        this.displayManager = new DisplayManager(this);
        this.explorerFrame = new ExplorerFrame(this);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    explorer = new JAMSExplorer(null, true);
                }
            });
        }
        catch (InterruptedException ex) {
            Logger.getLogger(JAMSExplorer.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(JAMSExplorer.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        explorer.getExplorerFrame().setVisible(true);
        if (args.length > 0) {
            try {
                explorer.getExplorerFrame().open(new File(args[0]));
            }
            catch (InvalidWorkspaceException ex) {
                Logger.getLogger(JAMSExplorer.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public JAMSRuntime getRuntime() {
        return this.runtime;
    }

    public SystemProperties getProperties() {
        return this.properties;
    }

    public ExplorerFrame getExplorerFrame() {
        return this.explorerFrame;
    }

    public DisplayManager getDisplayManager() {
        return this.displayManager;
    }

    public JAMSWorkspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(JAMSWorkspace workspace) {
        this.workspace = workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChild(Window window) {
        JAMSExplorer jAMSExplorer = this;
        synchronized (jAMSExplorer) {
            this.childWindows.add(window);
            window.addWindowListener(new WindowListener(){

                @Override
                public void windowOpened(WindowEvent e) {
                }

                @Override
                public void windowClosing(WindowEvent e) {
                }

                @Override
                public void windowClosed(WindowEvent e) {
                    JAMSExplorer.this.getChildWindows().remove(e.getWindow());
                }

                @Override
                public void windowIconified(WindowEvent e) {
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                }

                @Override
                public void windowActivated(WindowEvent e) {
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                }
            });
        }
    }

    public ArrayList<Window> getChildWindows() {
        return this.childWindows;
    }

    public void exit() {
        if (this.isStandAlone()) {
            System.exit(0);
        }
    }

    public boolean isStandAlone() {
        return this.standAlone;
    }
}

