/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.topology;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JAMSComponentDescription(title="ReachSubbasin", author="Sven Kralisch", description="Retrieve the subbasin of a given reach", date="2020-10-25", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class ReachSubbasin
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of hrus")
    public Attribute.EntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of reaches")
    public Attribute.EntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of sub-basin attribute in HRUs", defaultValue="subbasin")
    public Attribute.String subbasinAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of sub-basin entity collection in reaches", defaultValue="subbasinhrus")
    public Attribute.String subbasinEntitiesAttributeName;
    private Map<Attribute.Entity, List<Attribute.Entity>> reach2hruMap = new HashMap<Attribute.Entity, List<Attribute.Entity>>();

    public void init() {
        HashMap<Long, Attribute.Entity> reachMap = new HashMap<Long, Attribute.Entity>();
        for (Attribute.Entity reach : this.reaches.getEntities()) {
            reachMap.put(reach.getId(), reach);
        }
        for (Attribute.Entity hru : this.hrus.getEntities()) {
            double subbasinID = hru.getDouble(this.subbasinAttributeName.getValue());
            Attribute.Entity reach = (Attribute.Entity)reachMap.get((long)subbasinID);
            List<Attribute.Entity> hruList = this.reach2hruMap.get(reach);
            if (hruList == null) {
                hruList = new ArrayList<Attribute.Entity>();
                this.reach2hruMap.put(reach, hruList);
            }
            hruList.add(hru);
        }
        for (Attribute.Entity reach : this.reaches.getEntities()) {
            List<Attribute.Entity> hruList = this.reach2hruMap.get(reach);
            Attribute.EntityCollection hrus = this.getModel().getRuntime().getDataFactory().createEntityCollection();
            hrus.setEntities(hruList);
            reach.setObject(this.subbasinEntitiesAttributeName.getValue(), (Object)hrus);
        }
    }
}

